/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jautodoc.templates.ITemplateRegistry;
import net.sf.jautodoc.templates.TemplateEntry;
import net.sf.jautodoc.templates.TemplateSet;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;

public class VelocityTemplateRegistry
implements ITemplateRegistry {
    private Map<String, TemplateEntry> templates = new HashMap<String, TemplateEntry>();
    private StringResourceRepository repository = StringResourceLoader.getRepository();

    @Override
    public TemplateEntry getTemplate(String templateName) {
        return this.templates.get(templateName);
    }

    @Override
    public void putTemplates(TemplateSet templates) {
        this.clearTemplates();
        this.registerTemplates(templates);
    }

    @Override
    public void putTemplate(TemplateEntry entry) {
        this.templates.put(entry.getName(), entry);
        this.repository.putStringResource(entry.getName(), entry.getText());
    }

    @Override
    public boolean containsTemplate(String templateName) {
        return this.templates.containsKey(templateName);
    }

    private void clearTemplates() {
        for (String name : this.templates.keySet()) {
            this.repository.removeStringResource(name);
        }
        this.templates.clear();
    }

    private void registerTemplates(TemplateSet templates) {
        this.registerTemplates(templates.getTypeTemplates());
        this.registerTemplates(templates.getMethodTemplates());
        this.registerTemplates(templates.getFieldTemplates());
        this.registerTemplates(templates.getParameterTemplates());
        this.registerTemplates(templates.getExceptionTemplates());
    }

    private void registerTemplates(List<TemplateEntry> templateList) {
        int size = templateList.size();
        int i = 0;
        while (i < size) {
            TemplateEntry entry = templateList.get(i);
            this.putTemplate(entry);
            this.registerTemplates(entry.getChildTemplates());
            ++i;
        }
    }
}

