/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import net.sf.jautodoc.templates.AbstractTemplateManager;
import net.sf.jautodoc.templates.ITemplateRegistry;
import net.sf.jautodoc.templates.MatchingElement;
import net.sf.jautodoc.templates.ValidationException;
import net.sf.jautodoc.templates.velocity.VelocityLogger;
import net.sf.jautodoc.templates.velocity.VelocityTemplateRegistry;
import net.sf.jautodoc.templates.wrapper.DateWrapper;
import net.sf.jautodoc.templates.wrapper.JavaElementWrapper;
import net.sf.jautodoc.templates.wrapper.PropertyWrapper;
import net.sf.jautodoc.velocity.log.VelocityLogChuteProxy;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.parser.ParseException;
import org.eclipse.jdt.core.IJavaElement;

public class VelocityTemplateManager
extends AbstractTemplateManager {
    public static final String KEY_ELEMENT = "e";
    public static final String KEY_PROPERTIES = "p";
    public static final String KEY_USER = "user";
    public static final String KEY_DATE = "date";
    public static final String KEY_TIME = "time";
    public static final String KEY_YEAR = "year";
    public static final String KEY_PROJECT = "project_name";
    public static final String KEY_PACKAGE = "package_name";
    public static final String KEY_FILE = "file_name";
    public static final String KEY_TYPE = "type_name";
    private VelocityContext velocityCtx;
    private ITemplateRegistry registry;

    @Override
    public void validateTemplate(String template) throws ValidationException, Exception {
        try {
            RuntimeSingleton.parse((Reader)new StringReader(template), (String)"TemplateValidation");
        }
        catch (ParseException pe) {
            if (pe.currentToken != null && pe.currentToken.next != null) {
                throw new ValidationException(pe, pe.currentToken.next.beginLine - 1, pe.currentToken.next.beginColumn - 1);
            }
            throw new ValidationException(pe);
        }
    }

    @Override
    public String evaluateTemplate(IJavaElement javaElement, String template, String templateName, Map<String, String> properties) throws Exception {
        this.prepareVelocityContext(javaElement, properties);
        StringWriter writer = new StringWriter();
        Velocity.evaluate((Context)this.velocityCtx, (Writer)writer, (String)templateName, (String)template);
        return this.resolveEscapes(writer.toString());
    }

    @Override
    protected String applyTemplate(MatchingElement me, Map<String, String> properties) throws Exception {
        Template template = Velocity.getTemplate((String)me.getEntry().getName());
        this.prepareVelocityContext(me, properties);
        StringWriter writer = new StringWriter();
        template.merge((Context)this.velocityCtx, (Writer)writer);
        return this.resolveEscapes(writer.toString());
    }

    @Override
    protected String evaluateTemplate(MatchingElement me, String template, Map<String, String> properties) throws Exception {
        this.prepareVelocityContext(me, properties);
        StringWriter writer = new StringWriter();
        Velocity.evaluate((Context)this.velocityCtx, (Writer)writer, (String)"TemplateTest", (String)template);
        return this.resolveEscapes(writer.toString());
    }

    private String resolveEscapes(String string) {
        return string.replaceAll("\\\\\\$", "\\$");
    }

    @Override
    protected void onInit() throws Exception {
        this.initVelocity();
    }

    @Override
    protected ITemplateRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = new VelocityTemplateRegistry();
        }
        return this.registry;
    }

    private void prepareVelocityContext(MatchingElement me, Map<String, String> properties) {
        this.velocityCtx.put(KEY_ELEMENT, (Object)me);
        this.velocityCtx.put(KEY_PROJECT, (Object)new JavaElementWrapper(me, 1));
        this.velocityCtx.put(KEY_PACKAGE, (Object)new JavaElementWrapper(me, 2));
        this.velocityCtx.put(KEY_FILE, (Object)new JavaElementWrapper(me, 3));
        this.velocityCtx.put(KEY_TYPE, (Object)new JavaElementWrapper(me, 4));
        this.prepareProperties(properties);
    }

    private void prepareVelocityContext(IJavaElement je, Map<String, String> properties) {
        this.velocityCtx.remove((Object)KEY_ELEMENT);
        this.velocityCtx.put(KEY_PROJECT, (Object)new JavaElementWrapper(je, 1));
        this.velocityCtx.put(KEY_PACKAGE, (Object)new JavaElementWrapper(je, 2));
        this.velocityCtx.put(KEY_FILE, (Object)new JavaElementWrapper(je, 3));
        this.velocityCtx.put(KEY_TYPE, (Object)new JavaElementWrapper(je, 4));
        this.prepareProperties(properties);
    }

    private void prepareProperties(Map<String, String> properties) {
        for (String key : properties.keySet()) {
            this.velocityCtx.put(key, (Object)new PropertyWrapper(key, properties));
        }
    }

    private void initVelocity() throws Exception {
        if (this.velocityCtx != null) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            VelocityLogChuteProxy.setLogChute((LogChute)new VelocityLogger());
            Properties velProps = new Properties();
            velProps.load(this.getClass().getResourceAsStream("velocity.properties"));
            Velocity.init((Properties)velProps);
            this.initVelocityContext();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void initVelocityContext() {
        this.velocityCtx = new VelocityContext();
        this.velocityCtx.put(KEY_PROPERTIES, (Object)new PropertyWrapper());
        this.velocityCtx.put(KEY_USER, (Object)new PropertyWrapper("user.name", null));
        this.velocityCtx.put(KEY_DATE, (Object)new DateWrapper(DateWrapper.DATE));
        this.velocityCtx.put(KEY_TIME, (Object)new DateWrapper(DateWrapper.TIME));
        this.velocityCtx.put(KEY_YEAR, (Object)new DateWrapper(DateWrapper.YEAR));
    }
}

