/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jautodoc.ResourceManager;
import net.sf.jautodoc.templates.replacements.ITemplateReplacementsListener;
import net.sf.jautodoc.templates.replacements.ITemplateReplacementsProvider;
import net.sf.jautodoc.templates.replacements.TemplateReplacementsChangeEvent;
import net.sf.jautodoc.templates.rules.IRulesStrategy;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TemplateReplacementsRulesStrategy
implements IRulesStrategy {
    private ITemplateReplacementsProvider replacementsProvider;

    public TemplateReplacementsRulesStrategy(ITemplateReplacementsProvider replacementsProvider) {
        this.replacementsProvider = replacementsProvider;
    }

    @Override
    public List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add(new TemplateReplacementsRule());
        return rules;
    }

    private class TemplateReplacementsRule
    implements IRule,
    ITemplateReplacementsListener {
        private List<IRule> rules = null;

        private TemplateReplacementsRule() {
        }

        public IToken evaluate(ICharacterScanner scanner) {
            this.initRules();
            IToken token = Token.UNDEFINED;
            int i = 0;
            while (i < this.rules.size() && token == Token.UNDEFINED) {
                IRule rule = this.rules.get(i);
                token = rule.evaluate(scanner);
                ++i;
            }
            return token;
        }

        private void initRules() {
            if (this.rules != null) {
                return;
            }
            this.rules = new ArrayList<IRule>();
            IToken token = ResourceManager.getToken("result");
            Iterator<String> iter = TemplateReplacementsRulesStrategy.this.replacementsProvider.getReplacements().iterator();
            while (iter.hasNext()) {
                String replacement = iter.next().trim();
                if (replacement.length() <= 0) continue;
                this.rules.add(new WordCombinationRule(replacement, token));
            }
            TemplateReplacementsRulesStrategy.this.replacementsProvider.addTemplateReplacementsListener(this);
        }

        @Override
        public void templateReplacementsChange(TemplateReplacementsChangeEvent e) {
            this.rules = null;
        }
    }

    private class WordCombinationRule
    implements IRule {
        private char[] word;
        private IToken token;

        public WordCombinationRule(String word, IToken token) {
            this.word = word.toCharArray();
            this.token = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int i = 0;
            while (i < this.word.length) {
                int c = scanner.read();
                if (c == -1) {
                    scanner.unread();
                    return Token.UNDEFINED;
                }
                if (Character.toLowerCase((char)c) != Character.toLowerCase(this.word[i])) {
                    int j = i;
                    while (j >= 0) {
                        scanner.unread();
                        --j;
                    }
                    return Token.UNDEFINED;
                }
                ++i;
            }
            return this.token;
        }
    }
}

