/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.rules;

import java.util.ArrayList;
import java.util.List;
import net.sf.jautodoc.ResourceManager;
import net.sf.jautodoc.templates.rules.IRulesStrategy;
import net.sf.jautodoc.templates.rules.TagDetector;
import net.sf.jautodoc.templates.rules.TemplateCodeScanner;
import net.sf.jautodoc.utils.ResettableScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class GeneralRulesStrategie
implements IRulesStrategy {
    @Override
    public List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new StringRule("\"", "\"", ResourceManager.getToken("string")));
        rules.add((IRule)new StringRule("'", "'", ResourceManager.getToken("string")));
        rules.add((IRule)new StringRule("\\", "$", ResourceManager.getToken("escapes")));
        rules.add((IRule)new StringRule("\\", "#", ResourceManager.getToken("escapes")));
        rules.add((IRule)new MarkupRule(ResourceManager.getToken("markup")));
        rules.add(new OperatorRule(ResourceManager.getToken("operator")));
        rules.add(new NumberRule(ResourceManager.getToken("number")));
        rules.add((IRule)new WordRule((IWordDetector)new TagDetector(), ResourceManager.getToken("tag")));
        return rules;
    }

    private static class MarkupRule
    extends SingleLineRule {
        private ResettableScanner rScanner = new ResettableScanner();

        public MarkupRule(IToken token) {
            super("<", ">", token);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            this.rScanner.setScanner(scanner);
            IToken result = super.evaluate((ICharacterScanner)this.rScanner);
            if (result != this.getSuccessToken() || !this.validate((TemplateCodeScanner)scanner)) {
                result = Token.UNDEFINED;
                this.rScanner.reset();
            }
            return result;
        }

        private boolean validate(TemplateCodeScanner scanner) {
            try {
                String token = String.valueOf(scanner.getDocument().get(scanner.getTokenOffset(), scanner.getTokenLength())) + ".";
                int offset = 0;
                char character = token.charAt(++offset);
                if (character == '/') {
                    character = token.charAt(++offset);
                }
                while (Character.isWhitespace(character)) {
                    character = token.charAt(++offset);
                }
                while (Character.isLetter(character)) {
                    character = token.charAt(++offset);
                }
                while (Character.isWhitespace(character)) {
                    character = token.charAt(++offset);
                }
                if (offset >= 2 && token.charAt(offset) == this.fEndSequence[0]) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
            return false;
        }
    }

    private static class NumberRule
    implements IRule {
        private final IToken token;

        public NumberRule(IToken token) {
            this.token = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (Character.isDigit((char)character)) {
                while (Character.isDigit((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.token;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static class OperatorRule
    implements IRule {
        private static final char[] OPERATORS = new char[]{'(', ')', '[', ']', '=', '>', '<', '+', '-', '!', ',', '|', '&', '%'};
        private final IToken token;

        public OperatorRule(IToken token) {
            this.token = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isOperator((char)character)) {
                while (this.isOperator((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.token;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }

        private boolean isOperator(char character) {
            int index = 0;
            while (index < OPERATORS.length) {
                if (OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }
    }

    private static class StringRule
    extends SingleLineRule {
        private String endSequence;
        private ResettableScanner rScanner = new ResettableScanner();

        public StringRule(String startSequence, String endSequence, IToken token) {
            super(startSequence, endSequence, token);
            this.endSequence = endSequence;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            this.rScanner.setScanner(scanner);
            IToken result = super.evaluate((ICharacterScanner)this.rScanner);
            if (result != this.getSuccessToken() || !this.validate((TemplateCodeScanner)scanner)) {
                result = Token.UNDEFINED;
                this.rScanner.reset();
            }
            return result;
        }

        public boolean validate(TemplateCodeScanner scanner) {
            try {
                String token = scanner.getDocument().get(scanner.getTokenOffset(), scanner.getTokenLength());
                return token.endsWith(this.endSequence);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }
}

