/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.contentassist;

import java.util.ArrayList;
import java.util.List;
import net.sf.jautodoc.templates.contentassist.ITemplateContentAssistant;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class TemplateAssistProcessor
implements IContentAssistProcessor {
    private ITemplateContentAssistant[] assistants;

    public TemplateAssistProcessor(ITemplateContentAssistant[] assistants) {
        this.assistants = assistants;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        List<Object> proposals = new ArrayList();
        IDocument document = viewer.getDocument();
        try {
            int pos = documentOffset == document.getLength() ? documentOffset - 1 : documentOffset;
            IRegion region = document.getLineInformationOfOffset(pos);
            int startPosition = 0;
            ITemplateContentAssistant currentAssistant = null;
            int i = 0;
            while (i < this.assistants.length) {
                int start = this.assistants[i].getStartPosition(document, region, documentOffset);
                if (start > startPosition) {
                    startPosition = start;
                    currentAssistant = this.assistants[i];
                }
                ++i;
            }
            if (currentAssistant == null) {
                return new ICompletionProposal[0];
            }
            int length = documentOffset - startPosition;
            proposals = currentAssistant.getCompletionProposals(document, startPosition, length);
        }
        catch (Exception exception) {}
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        int length = 0;
        int i = 0;
        while (i < this.assistants.length) {
            length += this.assistants[i].getActivationCharacters().length;
            ++i;
        }
        int index = 0;
        char[] activationCharacters = new char[length];
        int i2 = 0;
        while (i2 < this.assistants.length) {
            char[] chars = this.assistants[i2].getActivationCharacters();
            int j = 0;
            while (j < chars.length) {
                activationCharacters[index++] = chars[j];
                ++j;
            }
            ++i2;
        }
        return activationCharacters;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

