/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.contentassist;

import java.util.ArrayList;
import java.util.List;
import net.sf.jautodoc.templates.contentassist.AbstractTemplateContentAssistant;
import net.sf.jautodoc.templates.contentassist.TagManager;
import net.sf.jautodoc.templates.rules.TagDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class TagContentAssistant
extends AbstractTemplateContentAssistant {
    private static TagDetector tagDetector = new TagDetector();

    public TagContentAssistant() {
        super(new String[]{"{@", "@"}, new char[]{'@'});
    }

    @Override
    public List<ICompletionProposal> getCompletionProposals(IDocument document, int offset, int length) {
        try {
            String element = this.getElement(document, offset, length);
            if (element != null) {
                return TagManager.getCompletionProposals(element, offset, length);
            }
        }
        catch (Exception exception) {}
        return new ArrayList<ICompletionProposal>();
    }

    private String getElement(IDocument document, int offset, int length) throws BadLocationException {
        if (length <= 0) {
            return null;
        }
        String element = document.get(offset, length);
        if (element.startsWith("{@") && this.isValidElement(element.substring(1)) || element.startsWith("@") && this.isValidElement(element)) {
            return element;
        }
        return null;
    }

    private boolean isValidElement(String element) {
        char[] chars = element.toCharArray();
        if (chars.length == 0 || !tagDetector.isWordStart(chars[0])) {
            return false;
        }
        int i = 1;
        while (i < chars.length) {
            if (!tagDetector.isWordPart(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

