/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class AutoCloseStrategy
implements IAutoEditStrategy {
    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (d.getLength() == 0 || c.offset == -1 || c.length > 0 || c.text == null || c.text.length() != 1) {
            return;
        }
        char ch = c.text.charAt(0);
        if (ch == '(') {
            this.setClosingChar(c, ')');
        } else if (ch == '{') {
            this.setClosingChar(c, '}');
        } else if (ch == '[') {
            this.setClosingChar(c, ']');
        } else if (ch == ')') {
            this.checkClosingChar(d, c, '(', ')');
        } else if (ch == '}') {
            this.checkClosingChar(d, c, '{', '}');
        } else if (ch == ']') {
            this.checkClosingChar(d, c, '[', ']');
        } else if (ch == '\"') {
            this.checkQuoteChar(d, c, '\"');
        } else if (ch == '\'') {
            this.checkQuoteChar(d, c, '\'');
        }
    }

    private void setClosingChar(DocumentCommand c, char closingChar) {
        c.text = String.valueOf(c.text) + closingChar;
        c.caretOffset = c.offset + 1;
        c.shiftsCaret = false;
    }

    private void checkQuoteChar(IDocument d, DocumentCommand c, char quoteChar) {
        try {
            if (c.offset == d.getLength()) {
                if (this.countQuotes(d, c, quoteChar) % 2 == 0) {
                    this.setClosingChar(c, quoteChar);
                }
                return;
            }
            char ch = d.getChar(c.offset);
            if (ch == quoteChar) {
                c.caretOffset = c.offset + 1;
                c.shiftsCaret = false;
                c.text = "";
            } else if (this.countQuotes(d, c, quoteChar) % 2 == 0) {
                this.setClosingChar(c, quoteChar);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void checkClosingChar(IDocument d, DocumentCommand c, char openingChar, char closingChar) {
        if (c.offset == d.getLength()) {
            return;
        }
        try {
            char ch = d.getChar(c.offset);
            if (ch == closingChar && !this.needsClosingChar(d, c, openingChar, closingChar)) {
                c.caretOffset = c.offset + 1;
                c.shiftsCaret = false;
                c.text = "";
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean needsClosingChar(IDocument d, DocumentCommand c, char openingChar, char closingChar) throws BadLocationException {
        int countOpening = 0;
        int countClosing = 0;
        IRegion info = d.getLineInformationOfOffset(c.offset);
        int start = info.getOffset();
        int end = c.offset;
        int i = start;
        while (i <= end) {
            char ch = d.getChar(i);
            if (ch == openingChar) {
                ++countOpening;
            } else if (ch == closingChar) {
                ++countClosing;
            }
            ++i;
        }
        return countOpening > countClosing;
    }

    private int countQuotes(IDocument d, DocumentCommand c, char quoteChar) throws BadLocationException {
        int count = 0;
        IRegion info = d.getLineInformationOfOffset(c.offset);
        int start = info.getOffset();
        int end = c.offset;
        int i = start;
        while (i < end) {
            char ch = d.getChar(i);
            if (ch == quoteChar) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

