/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates;

import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import net.sf.jautodoc.templates.TemplateSet;

@XmlRootElement(name="jautodoc-template")
@XmlType(propOrder={"name", "useSignature", "defaultTemplate", "kind", "regex", "example", "text", "childTemplates"})
public class TemplateEntry {
    private int kind;
    private String name;
    private String regex;
    private String text;
    private String example;
    private TemplateSet childTemplates;
    private Pattern pattern;
    private boolean useSignature;
    private boolean defaultTemplate;
    private TemplateEntry parent;

    public TemplateEntry() {
        this(null);
    }

    public TemplateEntry(TemplateEntry parent, int kind) {
        this(parent);
        this.kind = kind;
    }

    public TemplateEntry(TemplateEntry parent) {
        this.parent = parent;
        this.childTemplates = new TemplateSet();
    }

    @XmlAttribute
    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
        this.pattern = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    @XmlAttribute
    public boolean isUseSignature() {
        return this.useSignature;
    }

    public void setUseSignature(boolean useSignature) {
        this.useSignature = useSignature;
    }

    @XmlTransient
    public TemplateEntry getParent() {
        return this.parent;
    }

    public void setParent(TemplateEntry parent) {
        this.parent = parent;
    }

    @XmlAttribute
    public boolean isDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(boolean defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    @XmlTransient
    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regex);
        }
        return this.pattern;
    }

    @XmlTransient
    public String getDescription() {
        String description = "";
        if (this.isType()) {
            description = "Type";
        } else if (this.isField()) {
            description = "Field";
        } else if (this.isMethod()) {
            description = "Method";
        } else if (this.isParameter()) {
            description = "Parameter";
        } else if (this.isException()) {
            description = "Exception";
        }
        return description;
    }

    public List<TemplateEntry> getChildTemplates(int templateKind) {
        List<TemplateEntry> list = null;
        switch (templateKind) {
            case 1: {
                list = this.childTemplates.getTypeTemplates();
                break;
            }
            case 2: {
                list = this.childTemplates.getFieldTemplates();
                break;
            }
            case 3: {
                list = this.childTemplates.getMethodTemplates();
                break;
            }
            case 4: {
                list = this.childTemplates.getParameterTemplates();
                break;
            }
            case 5: {
                list = this.childTemplates.getExceptionTemplates();
            }
        }
        return list;
    }

    public TemplateSet getChildTemplates() {
        return this.childTemplates;
    }

    public void setChildTemplates(TemplateSet children) {
        this.childTemplates = children;
    }

    public boolean isType() {
        return this.kind == 1;
    }

    public boolean isField() {
        return this.kind == 2;
    }

    public boolean isMethod() {
        return this.kind == 3;
    }

    public boolean isParameter() {
        return this.kind == 4;
    }

    public boolean isException() {
        return this.kind == 5;
    }

    public void addChildTemplate(TemplateEntry entry) {
        List<TemplateEntry> templates = null;
        if (entry.isType()) {
            templates = this.childTemplates.getTypeTemplates();
        } else if (entry.isField()) {
            templates = this.childTemplates.getFieldTemplates();
        } else if (entry.isMethod()) {
            templates = this.childTemplates.getMethodTemplates();
        } else if (entry.isParameter()) {
            templates = this.childTemplates.getParameterTemplates();
        } else if (entry.isException()) {
            templates = this.childTemplates.getExceptionTemplates();
        }
        templates.add(entry);
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("name: " + this.getName());
        tmp.append("\nkind: " + this.getKind());
        tmp.append("\nregex: " + this.getRegex());
        tmp.append("\nexample: " + this.getExample());
        tmp.append("\nsignature: " + this.isUseSignature());
        tmp.append("\ntext:\n" + this.getText());
        if (!this.childTemplates.isEmpty()) {
            tmp.append("\n++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        }
        tmp.append(this.childTemplates.toString());
        return tmp.toString();
    }
}

