/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.templates.ITemplateManager;
import net.sf.jautodoc.templates.ITemplateRegistry;
import net.sf.jautodoc.templates.MatchingElement;
import net.sf.jautodoc.templates.TemplateEntry;
import net.sf.jautodoc.templates.TemplateSerializer;
import net.sf.jautodoc.templates.TemplateSet;
import net.sf.jautodoc.templates.wrapper.IMemberWrapper;
import net.sf.jautodoc.templates.wrapper.WrapperFactory;
import org.apache.velocity.runtime.parser.ParseException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;

public abstract class AbstractTemplateManager
implements ITemplateManager {
    private static final String DEFAULT_TEMPLATES = new String("default_templates.xml");
    private static final File USER_TEMPLATES = JAutodocPlugin.getDefault().getStateLocation().append("user_templates.xml").toFile();
    private TemplateSet templates;
    private MatchingElement matchingParent;
    private MatchingElement matchingMethod;

    @Override
    public void initialize() throws Exception {
        this.onInit();
        this.loadTemplates();
    }

    protected abstract void onInit() throws Exception;

    @Override
    public void loadTemplates() throws Exception {
        if (USER_TEMPLATES.exists()) {
            this.loadTemplates(USER_TEMPLATES);
        } else {
            this.loadDefaultTemplates();
        }
    }

    @Override
    public void loadTemplates(File file) throws Exception {
        this.templates = TemplateSerializer.loadTemplates(file);
        this.getRegistry().putTemplates(this.templates);
    }

    @Override
    public void loadDefaultTemplates() throws Exception {
        this.templates = TemplateSerializer.loadTemplates(this.getClass().getResourceAsStream(DEFAULT_TEMPLATES));
        this.getRegistry().putTemplates(this.templates);
    }

    @Override
    public void storeTemplates() throws Exception {
        this.storeTemplates(USER_TEMPLATES);
    }

    @Override
    public void storeTemplates(File file) throws Exception {
        TemplateSerializer.storeTemplates(this.templates, file);
    }

    @Override
    public TemplateSet getTemplates() throws Exception {
        if (this.templates == null) {
            this.loadTemplates();
        }
        return this.templates;
    }

    @Override
    public void setTemplates(TemplateSet templates) throws Exception {
        this.templates = templates;
        this.getRegistry().putTemplates(templates);
    }

    @Override
    public List<TemplateEntry> getTypeTemplates() throws Exception {
        return this.getTemplates().getTypeTemplates();
    }

    @Override
    public List<TemplateEntry> getFieldTemplates() throws Exception {
        return this.getTemplates().getFieldTemplates();
    }

    @Override
    public List<TemplateEntry> getMethodTemplates() throws Exception {
        return this.getTemplates().getMethodTemplates();
    }

    @Override
    public List<TemplateEntry> getParameterTemplates() throws Exception {
        return this.getTemplates().getParameterTemplates();
    }

    @Override
    public List<TemplateEntry> getExceptionTemplates() throws Exception {
        return this.getTemplates().getExceptionTemplates();
    }

    @Override
    public String applyTemplate(IMember member, Map<String, String> properties) throws Exception {
        return this.applyTemplate(WrapperFactory.getWrapper(member), properties);
    }

    @Override
    public String applyParameterTemplate(IMember member, String type, String name, Map<String, String> properties) throws Exception {
        return this.applyTemplate(WrapperFactory.getParameterWrapper(member, type, name), properties);
    }

    @Override
    public String applyExceptionTemplate(IMethod method, String name, Map<String, String> properties) throws Exception {
        return this.applyTemplate(WrapperFactory.getExceptionWrapper(method, name), properties);
    }

    private String applyTemplate(IMemberWrapper member, Map<String, String> properties) throws Exception {
        MatchingElement me = this.searchMatchingElement(member);
        if (me != null) {
            return this.applyTemplate(me, properties);
        }
        return "";
    }

    protected abstract String applyTemplate(MatchingElement var1, Map<String, String> var2) throws Exception;

    private void ensureMatchingParent(IMemberWrapper member) throws Exception {
        IMemberWrapper parent = member.getParent();
        if (parent != null) {
            if (parent.isType()) {
                this.matchingMethod = null;
                if (this.matchingParent == null || !this.matchingParent.getMember().equals(parent)) {
                    this.matchingParent = this.searchMatchingElement(parent);
                }
            } else if (parent.isMethod() && (this.matchingMethod == null || !this.matchingMethod.getMember().equals(parent))) {
                this.matchingMethod = this.searchMatchingElement(parent);
            }
        } else if (member.isParameter() || member.isException()) {
            this.matchingMethod = null;
        } else {
            this.matchingParent = null;
        }
    }

    private MatchingElement searchMatchingElement(IMemberWrapper member) throws Exception {
        this.ensureMatchingParent(member);
        List<TemplateEntry> templates = null;
        if (member.isType()) {
            if (this.matchingParent != null) {
                templates = new ArrayList<TemplateEntry>(this.matchingParent.getChildTemplates().getTypeTemplates());
                templates.addAll(this.getTypeTemplates());
            } else {
                templates = this.getTypeTemplates();
            }
        } else if (member.isField()) {
            if (this.matchingParent != null) {
                templates = new ArrayList<TemplateEntry>(this.matchingParent.getChildTemplates().getFieldTemplates());
                templates.addAll(this.getFieldTemplates());
            } else {
                templates = this.getFieldTemplates();
            }
        } else if (member.isMethod()) {
            if (this.matchingParent != null) {
                templates = new ArrayList<TemplateEntry>(this.matchingParent.getChildTemplates().getMethodTemplates());
                templates.addAll(this.getMethodTemplates());
            } else {
                templates = this.getMethodTemplates();
            }
        } else if (member.isParameter()) {
            if (this.matchingMethod != null) {
                templates = new ArrayList<TemplateEntry>(this.matchingMethod.getChildTemplates().getParameterTemplates());
                templates.addAll(this.getParameterTemplates());
            } else {
                templates = this.getParameterTemplates();
            }
        } else if (member.isException()) {
            if (this.matchingMethod != null) {
                templates = new ArrayList<TemplateEntry>(this.matchingMethod.getChildTemplates().getExceptionTemplates());
                templates.addAll(this.getExceptionTemplates());
            } else {
                templates = this.getExceptionTemplates();
            }
        }
        MatchingElement me = this.searchMatchingElement(member, templates);
        if (member.isType()) {
            this.matchingParent = me;
        } else if (member.isMethod()) {
            this.matchingMethod = me;
        }
        return me;
    }

    private MatchingElement searchMatchingElement(IMemberWrapper member, List<TemplateEntry> templates) throws Exception {
        int size = templates.size();
        int i = 0;
        while (i < size) {
            MatchingElement me = this.getMatchingElement(member, templates.get(i));
            if (me != null) {
                return me;
            }
            ++i;
        }
        return null;
    }

    private MatchingElement getMatchingElement(IMemberWrapper member, TemplateEntry entry) throws Exception {
        String text = entry.isUseSignature() ? member.getSignature() : member.getName();
        Matcher matcher = entry.getPattern().matcher(text);
        if (!matcher.matches()) {
            return null;
        }
        MatchingElement parent = member.isParameter() || member.isException() ? this.matchingMethod : this.matchingParent;
        return new MatchingElement(member, entry, matcher, parent);
    }

    @Override
    public String evaluateTemplate(Matcher matcher, Matcher parentMatcher, String template, TemplateEntry entry, Map<String, String> properties) throws Exception {
        MatchingElement parentMe = null;
        if (parentMatcher != null && parentMatcher.matches()) {
            parentMe = new MatchingElement(null, entry.getParent(), parentMatcher, null);
        }
        MatchingElement me = new MatchingElement(null, entry, matcher, parentMe);
        return this.evaluateTemplate(me, template, properties);
    }

    @Override
    public abstract String evaluateTemplate(IJavaElement var1, String var2, String var3, Map<String, String> var4) throws Exception;

    protected abstract String evaluateTemplate(MatchingElement var1, String var2, Map<String, String> var3) throws Exception;

    @Override
    public abstract void validateTemplate(String var1) throws ParseException, Exception;

    @Override
    public String getTemplateText(String templateName) {
        TemplateEntry entry = this.getRegistry().getTemplate(templateName);
        if (entry != null) {
            return entry.getText();
        }
        return null;
    }

    @Override
    public boolean existsTemplate(String templateName) {
        return this.getRegistry().containsTemplate(templateName);
    }

    @Override
    public void putTemplate(TemplateEntry entry) {
        this.getRegistry().putTemplate(entry);
    }

    protected abstract ITemplateRegistry getRegistry();
}

