/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class JavadocTag {
    public static final String TAG_TYPE_PARAM = "@param";
    public static final String TAG_TYPE_RETURN = "@return";
    public static final String TAG_TYPE_THROWS = "@throws";
    public static final String TAG_TYPE_EXCEPTION = "@exception";
    private static final List<String> NAMED_TAG_TYPES = Arrays.asList("@param", "@throws", "@exception");
    private final String type;
    private final String name;
    private final List<String> comments;

    public JavadocTag(String type, String name) {
        this(type, name, new ArrayList<String>(0));
    }

    public JavadocTag(String type, String name, List<String> comments) {
        this.type = type;
        this.name = name;
        this.comments = comments;
    }

    public static boolean isNamedTag(String type) {
        return NAMED_TAG_TYPES.contains(type);
    }

    public boolean isParamTag() {
        return TAG_TYPE_PARAM.equals(this.getType());
    }

    public boolean isReturnTag() {
        return TAG_TYPE_RETURN.equals(this.getType());
    }

    public boolean isThrowsTag() {
        return TAG_TYPE_THROWS.equals(this.getType()) || TAG_TYPE_EXCEPTION.equals(this.getType());
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.substring(1);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public void addToJavadocString(StringBuilder javadoc, String indent, String lineSeparator) {
        this.startNewLine(javadoc, indent);
        javadoc.append(this.type).append(" ");
        if (this.name != null && this.name.length() > 0) {
            javadoc.append(this.name).append(" ");
        }
        if (this.comments.size() > 0) {
            javadoc.append(this.comments.get(0));
        }
        javadoc.append(lineSeparator);
        int i = 1;
        while (i < this.comments.size()) {
            this.startNewLine(javadoc, indent);
            javadoc.append(this.comments.get(i));
            javadoc.append(lineSeparator);
            ++i;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JavadocTag [type=");
        builder.append(this.type);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", comments=");
        builder.append(this.comments);
        builder.append("]");
        return builder.toString();
    }

    private void startNewLine(StringBuilder javadoc, String indent) {
        javadoc.append(indent);
        javadoc.append(" * ");
    }

    public static class TagComparator
    implements Comparator<JavadocTag> {
        private final List<String> tagOrder;
        private final List<String> paramOrder;
        private final List<String> throwsOrder;

        public TagComparator(List<String> tagOrder, List<String> paramOrder, List<String> throwsOrder) {
            this.tagOrder = tagOrder;
            this.paramOrder = paramOrder;
            this.throwsOrder = throwsOrder;
        }

        @Override
        public int compare(JavadocTag tag1, JavadocTag tag2) {
            if (tag1.isParamTag() && tag2.isParamTag()) {
                return this.getIndex(tag1.getName(), this.paramOrder) - this.getIndex(tag2.getName(), this.paramOrder);
            }
            if (tag1.isThrowsTag() && tag2.isThrowsTag()) {
                return this.getIndex(tag1.getName(), this.throwsOrder) - this.getIndex(tag2.getName(), this.throwsOrder);
            }
            return this.getIndex(tag1.getType(), this.tagOrder) - this.getIndex(tag2.getType(), this.tagOrder);
        }

        private int getIndex(String value, List<String> valueOrder) {
            int index = valueOrder.indexOf(value);
            return index < 0 ? Integer.MAX_VALUE : index;
        }
    }
}

