/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.source.JavadocTag;
import net.sf.jautodoc.utils.StringUtils;
import net.sf.jautodoc.utils.Utils;

public class JavadocInfo {
    private State state = State.STATE_TEXT;
    private String type = "";
    private String name = "";
    private List<String> currentText = new ArrayList<String>();
    private final List<String> comment = new ArrayList<String>();
    private final List<String> returnDoc = new ArrayList<String>();
    private final List<JavadocTag> otherDoc = new ArrayList<JavadocTag>();
    private final Map<String, JavadocTag> paramDoc = new LinkedHashMap<String, JavadocTag>();
    private final Map<String, JavadocTag> throwsDoc = new LinkedHashMap<String, JavadocTag>();

    public List<JavadocTag> getAllTagComments(String[] parameterNames, String[] exceptionTypes) {
        ArrayList<JavadocTag> tagComments = new ArrayList<JavadocTag>();
        String[] stringArray = parameterNames;
        int n = parameterNames.length;
        int n2 = 0;
        while (n2 < n) {
            String paramName = stringArray[n2];
            JavadocTag paramTag = this.paramDoc.get(paramName);
            if (paramTag != null) {
                tagComments.add(paramTag);
            }
            ++n2;
        }
        if (!this.returnDoc.isEmpty()) {
            tagComments.add(new JavadocTag("@return", null, this.returnDoc));
        }
        stringArray = exceptionTypes;
        n = exceptionTypes.length;
        n2 = 0;
        while (n2 < n) {
            String exceptionType = stringArray[n2];
            JavadocTag throwsTag = this.throwsDoc.get(exceptionType);
            if (throwsTag != null) {
                tagComments.add(throwsTag);
            }
            ++n2;
        }
        tagComments.addAll(this.otherDoc);
        return tagComments;
    }

    public Map<String, JavadocTag> getThrowsDoc() {
        return this.throwsDoc;
    }

    public Map<String, JavadocTag> getParamDoc() {
        return this.paramDoc;
    }

    public List<String> getReturnDoc() {
        return this.returnDoc;
    }

    public List<String> getComment() {
        return this.comment;
    }

    public List<JavadocTag> getOtherDoc() {
        return this.otherDoc;
    }

    public boolean isInheritDoc() {
        boolean isInheritDoc = false;
        for (String line : this.comment) {
            if (line.indexOf("{@inheritDoc}") == -1) continue;
            isInheritDoc = true;
            break;
        }
        return isInheritDoc;
    }

    public boolean isEmpty() {
        return this.comment.isEmpty() && this.paramDoc.isEmpty() && this.returnDoc.isEmpty() && this.throwsDoc.isEmpty() && this.otherDoc.isEmpty();
    }

    public boolean hasTags() {
        return !this.paramDoc.isEmpty() || !this.returnDoc.isEmpty() || !this.throwsDoc.isEmpty() || !this.otherDoc.isEmpty();
    }

    public boolean hasComment() {
        return !this.comment.isEmpty();
    }

    public boolean containsPeriod() {
        for (String string : this.comment) {
            if (string.indexOf(Constants.DOT) <= -1) continue;
            return true;
        }
        return false;
    }

    public void parseJavadoc(String buffer) throws IOException {
        String input = buffer.replaceFirst("/\\*\\*", "").replaceFirst("\\s*\\*/\\s*", "").replaceAll("\\n\\s*\\* ?", "\n");
        String line = null;
        this.state = State.STATE_TEXT;
        BufferedReader br = new BufferedReader(new StringReader(input));
        while ((line = br.readLine()) != null) {
            if (!line.trim().startsWith("@")) {
                this.currentText.add(line);
                continue;
            }
            this.endTag();
            this.startTag(line.trim());
        }
        this.endTag();
    }

    public JavadocInfo merge(JavadocInfo jdi) {
        this.merge(this.comment, jdi.comment);
        this.merge(this.returnDoc, jdi.returnDoc);
        this.merge(this.otherDoc, jdi.otherDoc);
        this.merge(this.paramDoc, jdi.paramDoc);
        this.merge(this.throwsDoc, jdi.throwsDoc);
        return this;
    }

    private <E> void merge(List<E> first, List<E> second) {
        if (first.isEmpty() && !second.isEmpty()) {
            first.addAll(second);
        }
    }

    private void merge(Map<String, JavadocTag> first, Map<String, JavadocTag> second) {
        for (JavadocTag secondTag : second.values()) {
            JavadocTag firstTag = first.get(secondTag.getName());
            if (firstTag == null) {
                firstTag = new JavadocTag(secondTag.getType(), secondTag.getName());
                first.put(firstTag.getName(), firstTag);
            }
            this.merge(firstTag.getComments(), secondTag.getComments());
        }
    }

    private void startTag(String line) {
        this.name = "";
        this.state = State.STATE_TAGS;
        this.currentText = new ArrayList<String>();
        String[] tokens = line.split("\\s", 2);
        this.type = tokens[0];
        if (tokens.length > 1 && JavadocTag.isNamedTag(this.type)) {
            tokens = tokens[1].split("\\s", 2);
            this.name = tokens[0];
        }
        if (tokens.length > 1) {
            this.currentText.add(tokens[1]);
        }
    }

    private void endTag() {
        this.currentText = Utils.trimStringList(this.currentText);
        if (this.state == State.STATE_TEXT) {
            this.comment.addAll(this.currentText);
        } else {
            JavadocTag javadocTag = new JavadocTag(this.type, this.name, this.currentText);
            if (javadocTag.isParamTag()) {
                if (!StringUtils.isEmpty(this.name)) {
                    this.paramDoc.put(this.name, javadocTag);
                }
            } else if (javadocTag.isThrowsTag()) {
                if (!StringUtils.isEmpty(this.name)) {
                    this.throwsDoc.put(this.name, javadocTag);
                }
            } else if (javadocTag.isReturnTag()) {
                this.returnDoc.addAll(this.currentText);
            } else {
                this.otherDoc.add(new JavadocTag(this.type, this.name, this.currentText));
            }
        }
    }

    private static enum State {
        STATE_TEXT,
        STATE_TAGS;

    }
}

