/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.source;

import java.util.Map;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.utils.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.core.util.SimpleDocument;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class JavadocFormatter {
    private static final int DEFAULT_TAB_SIZE = 4;
    private static JavadocFormatter instance;
    private ICompilationUnit compUnit;
    private IJavaProject currProject;
    private CodeFormatter formatter;
    private Map<?, ?> options;
    private int tabSize;

    public static JavadocFormatter getInstance() {
        if (instance == null) {
            instance = new JavadocFormatter();
        }
        return instance;
    }

    private JavadocFormatter() {
    }

    public void startFormatting(ICompilationUnit compUnit) {
        this.compUnit = compUnit;
        if (this.currProject == null || !this.currProject.equals(compUnit.getJavaProject())) {
            this.currProject = compUnit.getJavaProject();
            this.options = this.currProject.getOptions(true);
            this.formatter = new DefaultCodeFormatter(this.options);
            this.tabSize = this.getTabSize();
        }
    }

    public void stopFormatting() {
        this.compUnit = null;
        this.currProject = null;
        this.formatter = null;
        this.options = null;
    }

    public String format(String comment, String indent, String lineSeparator) {
        String result = comment;
        SimpleDocument document = new SimpleDocument(comment);
        int indentationLevel = StringUtils.inferIndentationLevel(indent, this.tabSize);
        TextEdit textEdit = this.formatter.format(64, comment, 0, comment.length(), indentationLevel, lineSeparator);
        try {
            textEdit.apply((IDocument)document, 0);
            result = document.get();
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException((IJavaElement)this.compUnit, (Throwable)e);
        }
        return result;
    }

    private int getTabSize() {
        if (this.options != null && this.options.containsKey("org.eclipse.jdt.core.formatter.tabulation.size")) {
            try {
                return Integer.parseInt(this.options.get("org.eclipse.jdt.core.formatter.tabulation.size").toString());
            }
            catch (Exception exception) {}
        }
        return 4;
    }
}

