/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.source;

import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.replacements.ReplacementManager;
import net.sf.jautodoc.utils.StringUtils;

public class CommentManager {
    public static final int NONE = 0;
    public static final int TYPE = 1;
    public static final int FIELD = 2;
    public static final int METHOD = 3;
    public static final int PARAMETER = 4;
    public static final int RETURN = 5;
    public static final int EXCEPTION = 6;
    public static final int FIRST_TO_LOWER = 1;
    public static final int FIRST_TO_UPPER = 2;

    public static String createComment(Configuration config, String string, int scope, boolean split, boolean replace) {
        return CommentManager.createComment(config, string, scope, split, replace, 0);
    }

    public static String createComment(Configuration config, String string, int scope, boolean split, boolean replace, int mode) {
        if (!split && !replace) {
            return CommentManager.applyMode(string, mode);
        }
        boolean hasSpaces = StringUtils.hasSpaces(string);
        boolean isConstant = StringUtils.isConstant(string);
        String[] strings = isConstant ? string.split("_") : StringUtils.splitByUpperCase(string);
        int rScope = CommentManager.getReplacementScope(scope);
        if (replace && rScope >= 0) {
            ReplacementManager rm = config.getReplacementManager();
            strings = rm.doReplacements(strings, rScope);
        }
        if (split) {
            strings = StringUtils.allToLower(strings, isConstant);
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            if ((split || hasSpaces) && i > 0) {
                buffer.append(" ");
            }
            buffer.append(strings[i]);
            ++i;
        }
        return CommentManager.applyMode(buffer.toString(), mode);
    }

    private static String applyMode(String string, int mode) {
        if (mode == 1) {
            if (string.length() < 2 || !Character.isUpperCase(string.charAt(1))) {
                return StringUtils.firstToLower(string);
            }
        } else if (mode == 2) {
            return StringUtils.firstToUpper(string);
        }
        return string;
    }

    private static int getReplacementScope(int scope) {
        if (scope == 2 || scope == 4) {
            return 2;
        }
        if (scope == 3 || scope == 5) {
            return 1;
        }
        return -1;
    }
}

