/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.source;

import java.util.ArrayList;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.preferences.IMemberFilter;
import net.sf.jautodoc.source.JavadocCreator;
import net.sf.jautodoc.utils.SourceUtils;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jface.text.IDocument;

public abstract class AbstractSourceProcessor {
    protected IDocument document;
    protected IScanner commentScanner;
    protected final ICompilationUnit compUnit;
    protected final Configuration config;
    protected final JavadocCreator javadocCreator;

    protected AbstractSourceProcessor(ICompilationUnit compUnit) {
        this(compUnit, null);
    }

    protected AbstractSourceProcessor(ICompilationUnit compUnit, Configuration config) {
        this.config = config == null ? ConfigurationManager.getConfiguration(compUnit) : config;
        this.compUnit = compUnit;
        this.javadocCreator = new JavadocCreator(this.config);
    }

    protected void doProcessing(IMemberFilter filter, IProgressMonitor monitor) throws Exception {
        IType type = this.compUnit.findPrimaryType();
        if (type != null) {
            ArrayList<IMember> members = new ArrayList<IMember>();
            if (SourceUtils.isMatchingType(type, filter)) {
                members.add((IMember)type);
            }
            SourceUtils.getMembers(type, members, filter);
            this.doProcessing(members.toArray(new IMember[members.size()]), monitor);
        }
    }

    protected void doProcessing(IMember[] members, IProgressMonitor monitor) throws Exception {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.compUnit.reconcile(0, false, null, null);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = this.compUnit.getPath();
        manager.connect(path, LocationKind.NORMALIZE, null);
        try {
            this.document = manager.getTextFileBuffer(path, LocationKind.NORMALIZE).getDocument();
            this.commentScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            this.commentScanner.setSource(this.document.get().toCharArray());
            monitor.beginTask(this.getTaskName(), members.length + 5);
            this.startProcessing();
            monitor.worked(1);
            this.processFileHeader();
            monitor.worked(1);
            this.processTodoForAutodoc(members);
            monitor.worked(1);
            this.processMembers(SourceUtils.sortMembers(members), monitor);
            monitor.worked(1);
            this.stopProcessing();
            monitor.worked(1);
        }
        finally {
            manager.disconnect(path, LocationKind.NORMALIZE, null);
        }
    }

    protected abstract void startProcessing() throws Exception;

    protected abstract void processFileHeader() throws Exception;

    protected abstract void processTodoForAutodoc(IMember[] var1) throws Exception;

    protected abstract void processMember(IMember var1) throws Exception;

    protected abstract void stopProcessing() throws Exception;

    protected abstract String getTaskName();

    private void processMembers(IMember[] members, IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < members.length) {
            if (monitor.isCanceled()) break;
            IMember member = members[i];
            monitor.subTask(member.getElementName());
            this.processMember(member);
            monitor.worked(1);
            ++i;
        }
    }
}

