/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.HashSet;
import net.sf.jautodoc.search.TaskSearchContentProvider;
import net.sf.jautodoc.search.TaskSearchResultPage;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.swt.widgets.Table;

public class TaskSearchTableContentProvider
extends TaskSearchContentProvider {
    public TaskSearchTableContentProvider(TaskSearchResultPage resultPage) {
        super(resultPage);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof AbstractTextSearchResult) {
            Object[] rawElements;
            HashSet<Object> filteredElements = new HashSet<Object>();
            int limit = this.getResultPage().getElementLimit();
            Object[] objectArray = rawElements = ((AbstractTextSearchResult)inputElement).getElements();
            int n = rawElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.getResultPage().getDisplayedFindingsCount(element) > 0) {
                    filteredElements.add(element);
                    if (limit != -1 && filteredElements.size() >= limit) break;
                }
                ++n2;
            }
            return filteredElements.toArray();
        }
        return this.EMPTY_ARR;
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
        if (this.getSearchResult() == null) {
            return;
        }
        int addLimit = this.getAddLimit();
        HashSet<Object> added = new HashSet<Object>();
        HashSet<Object> updated = new HashSet<Object>();
        HashSet<Object> removed = new HashSet<Object>();
        TableViewer viewer = (TableViewer)this.getResultPage().getViewer();
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.getResultPage().getDisplayedFindingsCount(element) > 0) {
                if (viewer.testFindItem(element) != null) {
                    updated.add(element);
                } else if (addLimit > 0) {
                    added.add(element);
                    --addLimit;
                }
            } else {
                removed.add(element);
            }
            ++n2;
        }
        viewer.add(added.toArray());
        viewer.remove(removed.toArray());
        viewer.update(updated.toArray(), new String[]{"net.sf.jautodoc.search.matchCount"});
    }

    private int getAddLimit() {
        int limit = this.getResultPage().getElementLimit();
        if (limit != -1) {
            Table table = (Table)this.getResultPage().getViewer().getControl();
            int itemCount = table.getItemCount();
            if (itemCount >= limit) {
                return 0;
            }
            return limit - itemCount;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void clear() {
        this.getResultPage().getViewer().refresh();
    }
}

