/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.HashSet;
import java.util.Set;
import net.sf.jautodoc.search.TaskSearchEngine;
import net.sf.jautodoc.search.TaskSearchPattern;
import net.sf.jautodoc.search.TaskSearchResult;
import net.sf.jautodoc.utils.Utils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;

public class TaskSearchResultUpdater
implements IElementChangedListener,
IQueryListener {
    private static final int CHANGED_FLAGS = 262153;
    private static final int REMOVED_FLAGS = 1152;
    private final TaskSearchResult searchResult;
    private final TaskSearchPattern searchPattern;
    private final Set<ICompilationUnit> scope;

    public TaskSearchResultUpdater(ICompilationUnit[] compUnits, TaskSearchPattern searchPattern, TaskSearchResult searchResult) {
        this.scope = Utils.asSet(compUnits);
        this.searchResult = searchResult;
        this.searchPattern = searchPattern;
        NewSearchUI.addQueryListener((IQueryListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        HashSet<Object> removedElements = new HashSet<Object>();
        HashSet<ICompilationUnit> changedCompilationUnits = new HashSet<ICompilationUnit>();
        this.collectAffected(changedCompilationUnits, removedElements, delta);
        this.handleChanged(changedCompilationUnits);
        this.handleRemoved(removedElements);
    }

    private void handleChanged(Set<ICompilationUnit> changedCompilationUnits) {
        for (ICompilationUnit compilationUnit : changedCompilationUnits) {
            new UpdateJob(compilationUnit).schedule();
        }
    }

    private void handleRemoved(Set<Object> removedElements) {
        Object[] objectArray = this.searchResult.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement;
            Object element = objectArray[n2];
            if (this.isContainedInRemoved(removedElements, element) && element instanceof IJavaElement && !(javaElement = (IJavaElement)element).exists()) {
                this.searchResult.removeMatches(this.searchResult.getMatches(javaElement));
            }
            ++n2;
        }
    }

    private boolean isContainedInRemoved(Set<Object> removedElements, Object object) {
        for (Object element : removedElements) {
            if (!this.isParentOf(element, object)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentOf(Object ancestor, Object descendant) {
        while (descendant != null && !ancestor.equals(descendant)) {
            descendant = this.getParent(descendant);
        }
        return descendant != null;
    }

    private Object getParent(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getParent();
        }
        return null;
    }

    private void collectAffected(Set<ICompilationUnit> changedCompilationUnits, Set<Object> removedElements, IJavaElementDelta delta) {
        if (delta.getKind() == 2) {
            removedElements.add(delta.getElement());
        } else if (delta.getKind() == 4) {
            int flags = delta.getFlags();
            if (delta.getElement() instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)delta.getElement();
                if (this.scope.contains(cu) && (flags & 0x40009) != 0) {
                    removedElements.add(cu);
                    changedCompilationUnits.add(cu);
                }
            } else if ((flags & 0x480) != 0) {
                removedElements.add(delta.getElement());
            } else {
                IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                    this.collectAffected(changedCompilationUnits, removedElements, childDelta);
                    ++n2;
                }
            }
        }
    }

    public void queryRemoved(ISearchQuery query) {
        if (((Object)((Object)this.searchResult)).equals(query.getSearchResult())) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            NewSearchUI.removeQueryListener((IQueryListener)this);
        }
    }

    public void queryAdded(ISearchQuery query) {
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }

    private final class UpdateJob
    extends Job {
        private final ICompilationUnit cu;

        public UpdateJob(ICompilationUnit cu) {
            super("Update JAutodoc Search");
            this.cu = cu;
            this.setSystem(true);
            this.setRule((ISchedulingRule)cu.getResource());
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                TaskSearchEngine engine = new TaskSearchEngine(this.cu, TaskSearchResultUpdater.this.searchPattern, TaskSearchResultUpdater.this.searchResult);
                engine.search(monitor);
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }
    }
}

