/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.search.TaskSearchContentProvider;
import net.sf.jautodoc.search.TaskSearchDetailViewer;
import net.sf.jautodoc.search.TaskSearchGroupAction;
import net.sf.jautodoc.search.TaskSearchMatch;
import net.sf.jautodoc.search.TaskSearchPostfixLabelProvider;
import net.sf.jautodoc.search.TaskSearchResult;
import net.sf.jautodoc.search.TaskSearchSortAction;
import net.sf.jautodoc.search.TaskSearchSortingLabelProvider;
import net.sf.jautodoc.search.TaskSearchTableContentProvider;
import net.sf.jautodoc.search.TaskSearchTreeContentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dnd.EditorInputTransferDragAdapter;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.jdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.jdt.internal.ui.search.JavaSearchEditorOpener;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;

public class TaskSearchResultPage
extends AbstractTextSearchViewPage
implements ISearchResultPage,
ISelectionChangedListener {
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private static final String KEY_LIMIT = "net.sf.jautodoc.search.resultpage.limit";
    private static final String KEY_SORTING = "net.sf.jautodoc.search.resultpage.sorting";
    private static final String KEY_GROUPING = "net.sf.jautodoc.search.resultpage.grouping";
    private static final String KEY_SPLITTER_WEIGHT1 = "net.sf.jautodoc.search.resultpage.weight1";
    private static final String KEY_SPLITTER_WEIGHT2 = "net.sf.jautodoc.search.resultpage.weight2";
    private static final String GROUP_GROUPING = "net.sf.jautodoc.search.resultpage.grouping";
    private static final String GROUP_FILTERING = "net.sf.jautodoc.search.resultpage.filtering";
    private SashForm viewSplitter;
    private int[] splitterWeights = new int[]{3, 1};
    private TaskSearchDetailViewer detailViewer;
    private TaskSearchSortAction sortByNameAction;
    private TaskSearchSortAction sortByParentName;
    private TaskSearchSortAction sortByPathAction;
    private TaskSearchGroupAction groupFileAction;
    private TaskSearchGroupAction groupPackageAction;
    private TaskSearchGroupAction groupProjectAction;
    private int currentGrouping;
    private int currentSortOrder;
    private TaskSearchContentProvider contentProvider;
    private TaskSearchSortingLabelProvider sortingLabelProvider;
    private JavaSearchEditorOpener editorOpener = new JavaSearchEditorOpener();

    public TaskSearchResultPage() {
        this.initSortActions();
        this.initGroupingActions();
        this.setElementLimit(1000);
    }

    public IJavaElement[] getFilteredJavaElements() {
        Object[] elements;
        ArrayList<IJavaElement> javaElements = new ArrayList<IJavaElement>();
        TaskSearchResult taskSearchResult = (TaskSearchResult)this.getInput();
        Object[] objectArray = elements = taskSearchResult.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IJavaElement && taskSearchResult.getFilteredFindingCount(element) > 0) {
                javaElements.add((IJavaElement)element);
            }
            ++n2;
        }
        return javaElements.toArray(new IJavaElement[javaElements.size()]);
    }

    protected TableViewer createTableViewer(Composite parent) {
        this.disposeCurrentView();
        this.viewSplitter = new SashForm(parent, 256);
        TableViewer tableViewer = super.createTableViewer((Composite)this.viewSplitter);
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.createDetailViewer((Composite)this.viewSplitter);
        this.viewSplitter.setWeights(this.splitterWeights);
        return tableViewer;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.disposeCurrentView();
        this.viewSplitter = new SashForm(parent, 256);
        TreeViewer treeViewer = super.createTreeViewer((Composite)this.viewSplitter);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.createDetailViewer((Composite)this.viewSplitter);
        this.viewSplitter.setWeights(this.splitterWeights);
        return treeViewer;
    }

    private void createDetailViewer(Composite parent) {
        this.detailViewer = new TaskSearchDetailViewer(parent, this);
    }

    public void gotoNextMatch() {
        super.gotoNextMatch();
        if (this.getViewer() instanceof TableViewer) {
            this.handleSelectionChanged(this.getViewer().getSelection());
        }
    }

    public void gotoPreviousMatch() {
        super.gotoPreviousMatch();
        if (this.getViewer() instanceof TableViewer) {
            this.handleSelectionChanged(this.getViewer().getSelection());
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSelectionProvider() != this.getViewer()) {
            return;
        }
        this.handleSelectionChanged(e.getSelection());
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.insertBefore("group.properties", (IContributionItem)new Separator(GROUP_FILTERING));
        menuManager.appendToGroup("group.properties", (IAction)new Action("Preferences..."){

            public void run() {
                String pageId = "org.eclipse.search.preferences.SearchPreferencePage";
                PreferencesUtil.createPreferenceDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)pageId, null, null).open();
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.currentSortOrder);
        memento.putInteger("net.sf.jautodoc.search.resultpage.grouping", this.currentGrouping);
        int limit = this.getElementLimit();
        memento.putInteger(KEY_LIMIT, limit);
        memento.putInteger(KEY_SPLITTER_WEIGHT1, this.viewSplitter.getWeights()[0]);
        memento.putInteger(KEY_SPLITTER_WEIGHT2, this.viewSplitter.getWeights()[1]);
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        if (memento == null) {
            this.setElementLimit(1000);
            this.currentGrouping = 3;
            this.currentSortOrder = 1;
        } else {
            this.setElementLimit(this.getInt(memento, KEY_LIMIT, 1000));
            this.currentGrouping = this.getInt(memento, "net.sf.jautodoc.search.resultpage.grouping", 3);
            this.currentSortOrder = this.getInt(memento, KEY_SORTING, 1);
            this.splitterWeights[0] = this.getInt(memento, KEY_SPLITTER_WEIGHT1, this.splitterWeights[0]);
            this.splitterWeights[1] = this.getInt(memento, KEY_SPLITTER_WEIGHT2, this.splitterWeights[1]);
        }
    }

    public int getDisplayedFindingsCount(Object element) {
        TaskSearchResult searchResult = (TaskSearchResult)this.getInput();
        if (searchResult.getActiveMatchFilters() == null) {
            return searchResult.getFindingCount(element);
        }
        return searchResult.getFilteredFindingCount(element);
    }

    public void setSortOrder(int order) {
        if (this.sortingLabelProvider != null) {
            this.currentSortOrder = order;
            this.sortingLabelProvider.setOrder(order);
            this.getViewer().refresh();
        }
    }

    public void setGrouping(int grouping) {
        this.currentGrouping = grouping;
        TaskSearchTreeContentProvider cp = (TaskSearchTreeContentProvider)this.getViewer().getContentProvider();
        cp.setLevel(grouping);
        this.updateGroupingActions();
        this.getViewPart().updateLabel();
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        this.sortingLabelProvider = new TaskSearchSortingLabelProvider(this);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider((JavaUILabelProvider)this.sortingLabelProvider, false));
        this.contentProvider = new TaskSearchTableContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)this.sortingLabelProvider));
        this.setSortOrder(this.currentSortOrder);
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        TaskSearchPostfixLabelProvider postfixLabelProvider = new TaskSearchPostfixLabelProvider(this);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider((JavaUILabelProvider)postfixLabelProvider, false));
        this.contentProvider = new TaskSearchTreeContentProvider(this, this.currentGrouping);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)postfixLabelProvider));
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void elementsChanged(Object[] objects) {
        TaskSearchResult taskSearchResult = (TaskSearchResult)this.getInput();
        if (taskSearchResult != null) {
            taskSearchResult.applyFilterState(objects);
        }
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
        this.handleSelectionChanged(this.getViewer().getSelection());
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() == 2) {
            this.addGroupActions(tbm);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if ((firstElement instanceof ICompilationUnit || firstElement instanceof IClassFile || firstElement instanceof IMember) && this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                this.editorOpener.openElement(firstElement);
            }
            catch (CoreException e) {
                JAutodocPlugin.getDefault().handleException(this.getSite().getShell(), (Throwable)e);
            }
            return;
        }
        super.handleOpen(event);
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IEditorPart editor = this.editorOpener.openMatch(match);
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        Object element = match.getElement();
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else if (editor != null && element instanceof IFile) {
            IFile file = (IFile)element;
            this.showWithMarker(editor, file, offset, length);
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", offset);
            attributes.put("charEnd", offset + length);
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException("Could not create marker", (Throwable)e);
        }
    }

    private void addGroupActions(IToolBarManager mgr) {
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)new Separator("net.sf.jautodoc.search.resultpage.grouping"));
        mgr.appendToGroup("net.sf.jautodoc.search.resultpage.grouping", (IAction)this.groupProjectAction);
        mgr.appendToGroup("net.sf.jautodoc.search.resultpage.grouping", (IAction)this.groupPackageAction);
        mgr.appendToGroup("net.sf.jautodoc.search.resultpage.grouping", (IAction)this.groupFileAction);
        this.updateGroupingActions();
    }

    private void initGroupingActions() {
        this.groupProjectAction = new TaskSearchGroupAction("Project", "Group by Project", this, 4);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.groupProjectAction, (String)"prj_mode.gif");
        this.groupPackageAction = new TaskSearchGroupAction("Package", "Group by Package", this, 3);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.groupPackageAction, (String)"package_mode.gif");
        this.groupFileAction = new TaskSearchGroupAction("File", "Group by File", this, 2);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.groupFileAction, (String)"file_mode.gif");
    }

    private void updateGroupingActions() {
        this.groupProjectAction.setChecked(this.currentGrouping == 4);
        this.groupPackageAction.setChecked(this.currentGrouping == 3);
        this.groupFileAction.setChecked(this.currentGrouping == 2);
    }

    private void initSortActions() {
        this.sortByPathAction = new TaskSearchSortAction("Path", this, 3);
        this.sortByNameAction = new TaskSearchSortAction("Name", this, 1);
        this.sortByParentName = new TaskSearchSortAction("Parent Name", this, 2);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() == 1) {
            MenuManager sortMenu = new MenuManager("Sort By");
            sortMenu.add((IAction)this.sortByNameAction);
            sortMenu.add((IAction)this.sortByPathAction);
            sortMenu.add((IAction)this.sortByParentName);
            this.sortByNameAction.setChecked(this.currentSortOrder == this.sortByNameAction.getSortOrder());
            this.sortByPathAction.setChecked(this.currentSortOrder == this.sortByPathAction.getSortOrder());
            this.sortByParentName.setChecked(this.currentSortOrder == this.sortByParentName.getSortOrder());
            mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
        }
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), ResourceTransfer.getInstance()};
        JdtViewerDragAdapter dragAdapter = new JdtViewerDragAdapter(viewer);
        dragAdapter.addDragSourceListener((TransferDragSourceListener)new SelectionTransferDragAdapter((ISelectionProvider)viewer));
        dragAdapter.addDragSourceListener((TransferDragSourceListener)new EditorInputTransferDragAdapter((ISelectionProvider)viewer));
        dragAdapter.addDragSourceListener((TransferDragSourceListener)new ResourceTransferDragAdapter((ISelectionProvider)viewer));
        viewer.addDragSupport(5, transfers, (DragSourceListener)dragAdapter);
    }

    private void handleSelectionChanged(ISelection selection) {
        IStructuredSelection sselection = (IStructuredSelection)selection;
        if (sselection.size() == 1) {
            TaskSearchResult searchResult = (TaskSearchResult)this.getInput();
            Object element = sselection.getFirstElement();
            Match[] matches = searchResult.getMatches(element);
            ArrayList<TaskSearchMatch.Finding> findings = new ArrayList<TaskSearchMatch.Finding>();
            Match[] matchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                TaskSearchMatch taskSearchMatch = (TaskSearchMatch)match;
                findings.addAll(Arrays.asList(taskSearchMatch.getFilteredFindings()));
                ++n2;
            }
            this.detailViewer.setInput(findings);
        } else {
            this.detailViewer.clearViewer();
        }
    }

    private void disposeCurrentView() {
        if (this.detailViewer != null) {
            this.detailViewer.getControl().dispose();
            this.detailViewer = null;
        }
        if (this.viewSplitter != null) {
            this.viewSplitter.dispose();
            this.viewSplitter = null;
        }
    }

    private int getInt(IMemento memento, String key, int defaultValue) {
        Integer value = memento.getInteger(key);
        return value == null ? defaultValue : value;
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider labelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ICompilationUnit && e2 instanceof IMember) {
                ICompilationUnit cu1 = (ICompilationUnit)e1;
                ICompilationUnit cu2 = ((IMember)e2).getCompilationUnit();
                int rc = this.compare(viewer, cu1, cu2);
                if (rc != 0) {
                    return rc;
                }
                return -1;
            }
            if (e1 instanceof IMember && e2 instanceof ICompilationUnit) {
                ICompilationUnit cu2;
                ICompilationUnit cu1 = ((IMember)e1).getCompilationUnit();
                int rc = this.compare(viewer, cu1, cu2 = (ICompilationUnit)e2);
                if (rc != 0) {
                    return rc;
                }
                return 1;
            }
            if (e1 instanceof IMember && e2 instanceof IMember) {
                IMember m1 = (IMember)e1;
                IMember m2 = (IMember)e2;
                int rc = this.compare(viewer, m1.getCompilationUnit(), m2.getCompilationUnit());
                if (rc != 0) {
                    return rc;
                }
                return this.getOffset(m1) - this.getOffset(m2);
            }
            String name1 = this.noNull(this.labelProvider.getText(e1));
            String name2 = this.noNull(this.labelProvider.getText(e2));
            return this.getComparator().compare(name1, name2);
        }

        private String noNull(String string) {
            return string == null ? "" : string;
        }

        private int getOffset(IMember member) {
            try {
                return member.getNameRange().getOffset();
            }
            catch (JavaModelException javaModelException) {
                return -1;
            }
        }
    }
}

