/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.ArrayList;
import net.sf.jautodoc.preferences.IMemberFilter;
import org.eclipse.jface.dialogs.IDialogSettings;

public class TaskSearchPattern
implements IMemberFilter {
    private boolean missingJavadoc;
    private boolean missingParamTag;
    private boolean missingReturnTag;
    private boolean missingThrowsTag;
    private boolean missingPeriods;
    private boolean generatedJavadoc;
    private boolean todoForGenerated;
    private boolean missingHeader;
    private boolean outdatedHeader;
    private boolean includePublic;
    private boolean includeProtected;
    private boolean includePackage;
    private boolean includePrivate;
    private boolean includeTypes;
    private boolean includeFields;
    private boolean includeMethods;
    private boolean getterSetterOnly;
    private boolean excludeGetterSetter;
    private boolean searchMissingTags;
    private String missingTagString;
    private MissingTag[] missingTags;

    public void store(IDialogSettings settings) {
        settings.put("missingJavadoc", this.missingJavadoc);
        settings.put("missingParamTag", this.missingParamTag);
        settings.put("missingReturnTag", this.missingReturnTag);
        settings.put("missingThrowsTag", this.missingThrowsTag);
        settings.put("missingPeriods", this.missingPeriods);
        settings.put("generatedJavadoc", this.generatedJavadoc);
        settings.put("todoForGenerated", this.todoForGenerated);
        settings.put("missingHeader", this.missingHeader);
        settings.put("outdatedHeader", this.outdatedHeader);
        settings.put("includePublic", this.includePublic);
        settings.put("includeProtected", this.includeProtected);
        settings.put("includePackage", this.includePackage);
        settings.put("includePrivate", this.includePrivate);
        settings.put("includeTypes", this.includeTypes);
        settings.put("includeFields", this.includeFields);
        settings.put("includeMethods", this.includeMethods);
        settings.put("getterSetterOnly", this.getterSetterOnly);
        settings.put("excludeGetterSetter", this.excludeGetterSetter);
        settings.put("searchMissingTags", this.searchMissingTags);
        settings.put("missingTagString", this.missingTagString);
    }

    public static TaskSearchPattern create(IDialogSettings settings) {
        TaskSearchPattern pattern = new TaskSearchPattern();
        pattern.missingJavadoc = TaskSearchPattern.getBoolean(settings, "missingJavadoc", true);
        pattern.missingParamTag = TaskSearchPattern.getBoolean(settings, "missingParamTag", true);
        pattern.missingReturnTag = TaskSearchPattern.getBoolean(settings, "missingReturnTag", true);
        pattern.missingThrowsTag = TaskSearchPattern.getBoolean(settings, "missingThrowsTag", true);
        pattern.missingPeriods = TaskSearchPattern.getBoolean(settings, "missingPeriods", false);
        pattern.generatedJavadoc = TaskSearchPattern.getBoolean(settings, "generatedJavadoc", false);
        pattern.todoForGenerated = TaskSearchPattern.getBoolean(settings, "todoForGenerated", false);
        pattern.missingHeader = TaskSearchPattern.getBoolean(settings, "missingHeader", false);
        pattern.outdatedHeader = TaskSearchPattern.getBoolean(settings, "outdatedHeader", false);
        pattern.includePublic = TaskSearchPattern.getBoolean(settings, "includePublic", true);
        pattern.includeProtected = TaskSearchPattern.getBoolean(settings, "includeProtected", true);
        pattern.includePackage = TaskSearchPattern.getBoolean(settings, "includePackage", false);
        pattern.includePrivate = TaskSearchPattern.getBoolean(settings, "includePrivate", false);
        pattern.includeTypes = TaskSearchPattern.getBoolean(settings, "includeTypes", true);
        pattern.includeFields = TaskSearchPattern.getBoolean(settings, "includeFields", true);
        pattern.includeMethods = TaskSearchPattern.getBoolean(settings, "includeMethods", true);
        pattern.getterSetterOnly = TaskSearchPattern.getBoolean(settings, "getterSetterOnly", false);
        pattern.excludeGetterSetter = TaskSearchPattern.getBoolean(settings, "excludeGetterSetter", false);
        pattern.searchMissingTags = TaskSearchPattern.getBoolean(settings, "searchMissingTags", false);
        pattern.missingTagString = TaskSearchPattern.getString(settings, "missingTagString", "author,deprecated+");
        return pattern;
    }

    public boolean isMissingJavadoc() {
        return this.missingJavadoc;
    }

    public void setMissingJavadoc(boolean missingJavadoc) {
        this.missingJavadoc = missingJavadoc;
    }

    public boolean isMissingParamTag() {
        return this.missingParamTag;
    }

    public void setMissingParamTag(boolean missingParamTag) {
        this.missingParamTag = missingParamTag;
    }

    public boolean isMissingReturnTag() {
        return this.missingReturnTag;
    }

    public void setMissingReturnTag(boolean missingReturnTag) {
        this.missingReturnTag = missingReturnTag;
    }

    public boolean isMissingThrowsTag() {
        return this.missingThrowsTag;
    }

    public void setMissingThrowsTag(boolean missingThrowsTag) {
        this.missingThrowsTag = missingThrowsTag;
    }

    public boolean isMissingPeriods() {
        return this.missingPeriods;
    }

    public void setMissingPeriods(boolean missingPeriods) {
        this.missingPeriods = missingPeriods;
    }

    public boolean isGeneratedJavadoc() {
        return this.generatedJavadoc;
    }

    public void setGeneratedJavadoc(boolean generatedJavadoc) {
        this.generatedJavadoc = generatedJavadoc;
    }

    public boolean isTodoForGenerated() {
        return this.todoForGenerated;
    }

    public void setTodoForGenerated(boolean todoForGenerated) {
        this.todoForGenerated = todoForGenerated;
    }

    public boolean isMissingHeader() {
        return this.missingHeader;
    }

    public void setMissingHeader(boolean missingHeader) {
        this.missingHeader = missingHeader;
    }

    public boolean isOutdatedHeader() {
        return this.outdatedHeader;
    }

    public void setOutdatedHeader(boolean outdatedHeader) {
        this.outdatedHeader = outdatedHeader;
    }

    @Override
    public boolean isIncludePublic() {
        return this.includePublic;
    }

    public void setVisibilityPublic(boolean visibilityPublic) {
        this.includePublic = visibilityPublic;
    }

    @Override
    public boolean isIncludeProtected() {
        return this.includeProtected;
    }

    public void setVisibilityProtected(boolean visibilityProtected) {
        this.includeProtected = visibilityProtected;
    }

    @Override
    public boolean isIncludePackage() {
        return this.includePackage;
    }

    public void setVisibilityPackage(boolean visibilityPackage) {
        this.includePackage = visibilityPackage;
    }

    @Override
    public boolean isIncludePrivate() {
        return this.includePrivate;
    }

    public void setVisibilityPrivate(boolean visibilityPrivate) {
        this.includePrivate = visibilityPrivate;
    }

    @Override
    public boolean isIncludeTypes() {
        return this.includeTypes;
    }

    public void setFilterTypes(boolean filterTypes) {
        this.includeTypes = filterTypes;
    }

    @Override
    public boolean isIncludeFields() {
        return this.includeFields;
    }

    public void setFilterFields(boolean filterFields) {
        this.includeFields = filterFields;
    }

    @Override
    public boolean isIncludeMethods() {
        return this.includeMethods;
    }

    public void setFilterMethods(boolean filterMethods) {
        this.includeMethods = filterMethods;
    }

    @Override
    public boolean isGetterSetterOnly() {
        return this.getterSetterOnly;
    }

    public void setFilterGetSetOnly(boolean filterGetSetOnly) {
        this.getterSetterOnly = filterGetSetOnly;
    }

    @Override
    public boolean isExcludeGetterSetter() {
        return this.excludeGetterSetter;
    }

    public void setFilterExcludeGetSet(boolean filterExcludeGetSet) {
        this.excludeGetterSetter = filterExcludeGetSet;
    }

    public boolean isSearchMissingTags() {
        return this.searchMissingTags;
    }

    public void setSearchMissingTags(boolean searchMissingTags) {
        this.searchMissingTags = searchMissingTags;
    }

    public String getMissingTagString() {
        return this.missingTagString;
    }

    public void setMissingTagString(String missingTagString) {
        this.missingTags = null;
        this.missingTagString = missingTagString;
    }

    public MissingTag[] getMissingTags() {
        if (this.missingTags == null) {
            String[] values;
            ArrayList<MissingTag> missingTagList = new ArrayList<MissingTag>();
            String[] stringArray = values = this.missingTagString.split(",");
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value.trim().length() > 0) {
                    missingTagList.add(MissingTag.fromString(value.trim()));
                }
                ++n2;
            }
            this.missingTags = missingTagList.toArray(new MissingTag[missingTagList.size()]);
        }
        return this.missingTags;
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        if (this.isMissingJavadoc()) {
            buffer.append("Missing Javadoc, ");
        }
        if (this.isMissingParamTag()) {
            buffer.append("@param, ");
        }
        if (this.isMissingReturnTag()) {
            buffer.append("@return, ");
        }
        if (this.isMissingThrowsTag()) {
            buffer.append("@throws, ");
        }
        if (this.isGeneratedJavadoc()) {
            buffer.append("Generated Javadoc, ");
        }
        if (this.isTodoForGenerated()) {
            buffer.append("ToDo's, ");
        }
        if (this.isMissingPeriods()) {
            buffer.append("Missing periods, ");
        }
        if (this.isMissingHeader()) {
            buffer.append("Missing header, ");
        }
        if (this.isOutdatedHeader()) {
            buffer.append("Outdated header, ");
        }
        if (this.isSearchMissingTags() && this.getMissingTagString().trim().length() > 0) {
            buffer.append("Missing @tags (" + this.getMissingTagString() + "), ");
        }
        return buffer.length() > 0 ? buffer.substring(0, buffer.length() - 2) : "";
    }

    private static String getString(IDialogSettings settings, String key, String defaultValue) {
        String value = settings.get(key);
        return value == null ? defaultValue : value;
    }

    private static boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
        String value = settings.get(key);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    public static class MissingTag {
        private final String name;
        private final Option option;

        private MissingTag(String name, Option option) {
            this.name = name;
            this.option = option;
        }

        public static MissingTag fromString(String string) {
            String name;
            Option option = Option.ALL;
            String string2 = name = string.startsWith("@") ? string.substring(1) : string;
            if (name.endsWith(Option.ONLY_MISSING.sign)) {
                name = name.substring(0, name.length() - 1);
                option = Option.ONLY_MISSING;
            } else if (name.endsWith(Option.ONLY_EMPTY.sign)) {
                name = name.substring(0, name.length() - 1);
                option = Option.ONLY_EMPTY;
            }
            return new MissingTag(name, option);
        }

        public String getName() {
            return this.name;
        }

        public boolean isOnlyMissing() {
            return this.option == Option.ONLY_MISSING;
        }

        public boolean isOnlyEmpty() {
            return this.option == Option.ONLY_EMPTY;
        }

        public String toString() {
            return String.valueOf(this.name) + this.option.sign;
        }

        public static enum Option {
            ALL(""),
            ONLY_MISSING("-"),
            ONLY_EMPTY("+");

            private final String sign;

            private Option(String sign) {
                this.sign = sign;
            }
        }
    }
}

