/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.HashSet;
import java.util.Set;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.search.TaskSearchMatch;
import net.sf.jautodoc.search.TaskSearchPattern;
import net.sf.jautodoc.search.TaskSearchResult;
import net.sf.jautodoc.source.AbstractSourceProcessor;
import net.sf.jautodoc.source.JavadocInfo;
import net.sf.jautodoc.source.JavadocTag;
import net.sf.jautodoc.utils.SourceUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.search.ui.text.Match;

public class TaskSearchEngine
extends AbstractSourceProcessor {
    private final TaskSearchResult searchResult;
    private final TaskSearchPattern searchPattern;

    public TaskSearchEngine(ICompilationUnit compUnit, TaskSearchPattern searchPattern, TaskSearchResult searchResult) {
        super(compUnit);
        this.searchResult = searchResult;
        this.searchPattern = searchPattern;
    }

    public void search(IProgressMonitor monitor) throws Exception {
        this.doProcessing(this.searchPattern, monitor);
    }

    @Override
    protected void startProcessing() throws Exception {
        this.searchResult.removeMatches(this.searchResult.getMatches(this.compUnit));
    }

    @Override
    protected void processFileHeader() throws Exception {
        String newHeader;
        int length;
        if (!this.searchPattern.isMissingHeader() && !this.searchPattern.isOutdatedHeader()) {
            return;
        }
        ISourceReference element = SourceUtils.getPackageOrImportReference(this.compUnit);
        if (element == null) {
            return;
        }
        ISourceRange range = element.getSourceRange();
        ISourceRange commentRange = SourceUtils.findCommentSourceRange(this.document, 0, range.getOffset() + range.getLength(), this.commentScanner, !this.config.isMultiCommentHeader());
        if (commentRange.getLength() == 0) {
            if (this.searchPattern.isMissingHeader()) {
                this.addMatch((IJavaElement)this.compUnit, 0, 0, TaskSearchMatch.FindingId.MISSING_HEADER, "Missing file header");
            }
            return;
        }
        if (!this.searchPattern.isOutdatedHeader()) {
            return;
        }
        int offset = commentRange.getOffset();
        String existingHeader = this.document.get(offset, length = commentRange.getLength());
        if (!SourceUtils.isSameComment(existingHeader, newHeader = JAutodocPlugin.getContext().getTemplateManager().evaluateTemplate((IJavaElement)this.compUnit, this.config.getHeaderText(), "File Header", this.config.getProperties()))) {
            this.addMatch((IJavaElement)this.compUnit, offset, length, TaskSearchMatch.FindingId.OUTDATED_HEADER, "Outdated file header");
        }
    }

    @Override
    protected void processTodoForAutodoc(IMember[] members) throws Exception {
        int length;
        if (!this.searchPattern.isTodoForGenerated()) {
            return;
        }
        IType type = SourceUtils.getFirstType(this.compUnit);
        if (type == null) {
            return;
        }
        ISourceRange range = type.getSourceRange();
        int offset = range.getOffset();
        String source = this.document.get(offset, length = range.getLength());
        if (source.startsWith(Constants.TODO_FOR_AUTODOC)) {
            this.addMatch((IJavaElement)this.compUnit, offset, Constants.TODO_FOR_AUTODOC.length(), TaskSearchMatch.FindingId.TODO_FOR_AUTODOC, "ToDo for generated Javadoc");
        }
    }

    @Override
    protected void processMember(IMember member) throws Exception {
        this.searchResult.removeMatches(this.searchResult.getMatches(member));
        if (!this.needsJavadocCheck(member)) {
            return;
        }
        ISourceRange docRange = SourceUtils.findJavadocSourceRange(member, this.commentScanner);
        String existingJavadoc = this.document.get(docRange.getOffset(), docRange.getLength());
        JavadocInfo jdi = new JavadocInfo();
        jdi.parseJavadoc(existingJavadoc);
        if (this.searchPattern.isMissingJavadoc() && !jdi.hasComment()) {
            this.addMatch(member, TaskSearchMatch.FindingId.MISSING_JAVADOC, "Missing Javadoc comment");
        }
        if (jdi.isEmpty()) {
            return;
        }
        if (this.searchPattern.isMissingPeriods() && jdi.hasComment() && !jdi.containsPeriod()) {
            this.addMatch(member, TaskSearchMatch.FindingId.MISSING_PERIOD, "Missing period on first sentence");
        }
        if (this.searchPattern.isGeneratedJavadoc()) {
            this.processGeneratedJavadoc(member, existingJavadoc);
        }
        if (this.searchPattern.isSearchMissingTags()) {
            this.processSearchMissingTags(member, jdi);
        }
        if (member instanceof IType) {
            this.processTypeJavadoc((IType)member, jdi);
        }
        if (member instanceof IMethod) {
            this.processMethodJavadoc((IMethod)member, jdi);
        }
    }

    @Override
    protected void stopProcessing() throws Exception {
    }

    @Override
    protected String getTaskName() {
        return "JAutodoc Search";
    }

    private void processTypeJavadoc(IType type, JavadocInfo jdi) throws JavaModelException {
        if (this.searchPattern.isMissingParamTag()) {
            this.processParameterTags(type, jdi);
        }
    }

    private void processMethodJavadoc(IMethod method, JavadocInfo jdi) throws JavaModelException {
        if (this.searchPattern.isMissingParamTag()) {
            this.processParameterTags(method, jdi);
        }
        if (this.searchPattern.isMissingReturnTag()) {
            this.processReturnTag(method, jdi);
        }
        if (this.searchPattern.isMissingThrowsTag()) {
            this.processThrowsTags(method, jdi);
        }
    }

    private void processGeneratedJavadoc(IMember member, String existingJavadoc) throws Exception {
        String generatedJavadoc = "";
        if (member instanceof IType) {
            JavadocInfo emptyJdi = new JavadocInfo();
            JavadocInfo generatedJdi = this.javadocCreator.applyTemplate(member, emptyJdi);
            generatedJavadoc = this.javadocCreator.createJavadoc((IType)member, "", "\n", generatedJdi);
        } else if (member instanceof IField) {
            JavadocInfo emptyJdi = new JavadocInfo();
            JavadocInfo generatedJdi = this.javadocCreator.applyTemplate(member, emptyJdi);
            generatedJavadoc = this.javadocCreator.createJavadoc((IField)member, "", "\n", generatedJdi);
        } else if (member instanceof IMethod) {
            generatedJavadoc = this.processGeneratedMethodJavadoc((IMethod)member);
        }
        if (!this.isEmpty(generatedJavadoc) && SourceUtils.isSameComment(existingJavadoc, generatedJavadoc)) {
            this.addMatch(member, TaskSearchMatch.FindingId.GENERATED_JAVADOC, "Generated Javadoc");
        }
    }

    private String processGeneratedMethodJavadoc(IMethod method) throws Exception {
        JavadocInfo emptyJdi;
        String generatedJavadoc = "";
        if (this.config.isGetterSetterFromField()) {
            emptyJdi = new JavadocInfo();
            generatedJavadoc = this.javadocCreator.createMethodJavadocFromField(method, "", "\n", emptyJdi, this.document, this.commentScanner);
        }
        if (this.isEmpty(generatedJavadoc)) {
            emptyJdi = new JavadocInfo();
            JavadocInfo generatedJdi = this.javadocCreator.applyTemplate((IMember)method, emptyJdi);
            generatedJavadoc = this.javadocCreator.createJavadoc(method, "", "\n", generatedJdi);
        }
        return generatedJavadoc;
    }

    private void processParameterTags(IType type, JavadocInfo jdi) throws JavaModelException {
        Set<String> parameters = this.processMissingParameterTags(type, jdi);
        this.processInvalidParameterTags((IMember)type, parameters, jdi);
    }

    private void processParameterTags(IMethod method, JavadocInfo jdi) throws JavaModelException {
        Set<String> parameters = this.processMissingParameterTags(method, jdi);
        this.processInvalidParameterTags((IMember)method, parameters, jdi);
    }

    private Set<String> processMissingParameterTags(IType type, JavadocInfo jdi) throws JavaModelException {
        return this.processMissingParameterTags((IMember)type, SourceUtils.getParameterNames(type), jdi);
    }

    private Set<String> processMissingParameterTags(IMethod method, JavadocInfo jdi) throws JavaModelException {
        return this.processMissingParameterTags((IMember)method, SourceUtils.getParameterNames(method), jdi);
    }

    private Set<String> processMissingParameterTags(IMember member, String[] parameterNames, JavadocInfo jdi) throws JavaModelException {
        HashSet<String> validParameters = new HashSet<String>();
        String[] stringArray = parameterNames;
        int n = parameterNames.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            JavadocTag paramTag = jdi.getParamDoc().get(parameter);
            if (paramTag == null || paramTag.getComments().isEmpty()) {
                this.addMatch(member, TaskSearchMatch.FindingId.MISSING_PARAM, "Missing @param tag for '" + parameter + "'");
            }
            validParameters.add(parameter);
            ++n2;
        }
        return validParameters;
    }

    private void processInvalidParameterTags(IMember member, Set<String> validParameters, JavadocInfo jdi) throws JavaModelException {
        for (String parameter : jdi.getParamDoc().keySet()) {
            if (validParameters.contains(parameter)) continue;
            this.addMatch(member, TaskSearchMatch.FindingId.INVALID_PARAM, "Invalid @param tag: " + parameter);
        }
    }

    private void processReturnTag(IMethod method, JavadocInfo jdi) throws JavaModelException {
        if (jdi.getReturnDoc().isEmpty() && !"void".equals(Signature.getSignatureSimpleName((String)method.getReturnType()))) {
            this.addMatch((IMember)method, TaskSearchMatch.FindingId.MISSING_RETURN, "Missing @return tag");
        }
    }

    private void processThrowsTags(IMethod method, JavadocInfo jdi) throws JavaModelException {
        Set<String> validExceptionTypes = this.processMissingThrowsTags(method, jdi);
        this.processInvalidThrowsTags(method, validExceptionTypes, jdi);
    }

    private Set<String> processMissingThrowsTags(IMethod method, JavadocInfo jdi) throws JavaModelException {
        HashSet<String> validExceptionTypes = new HashSet<String>();
        String[] stringArray = method.getExceptionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String exceptionTypeSignature = stringArray[n2];
            String exceptionType = Signature.getSignatureSimpleName((String)exceptionTypeSignature);
            JavadocTag throwsTag = jdi.getThrowsDoc().get(exceptionType);
            if (throwsTag == null || throwsTag.getComments().isEmpty()) {
                this.addMatch((IMember)method, TaskSearchMatch.FindingId.MISSING_THROWS, "Missing @throws tag for '" + exceptionType + "'");
            }
            validExceptionTypes.add(exceptionType);
            ++n2;
        }
        return validExceptionTypes;
    }

    private void processInvalidThrowsTags(IMethod method, Set<String> validExceptionTypes, JavadocInfo jdi) throws JavaModelException {
        for (String exceptionType : jdi.getThrowsDoc().keySet()) {
            if (validExceptionTypes.contains(exceptionType)) continue;
            this.addMatch((IMember)method, TaskSearchMatch.FindingId.INVALID_THROWS, "Invalid @throws tag: " + exceptionType);
        }
    }

    private void processSearchMissingTags(IMember member, JavadocInfo jdi) throws JavaModelException {
        TaskSearchPattern.MissingTag[] missingTagArray = this.searchPattern.getMissingTags();
        int n = missingTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskSearchPattern.MissingTag missingTag = missingTagArray[n2];
            if (!missingTag.isOnlyEmpty() && !this.hasTag(missingTag.getName(), jdi)) {
                this.addMatch(member, TaskSearchMatch.FindingId.MISSING_TAG, "Missing tag: " + missingTag.getName());
            } else if (!missingTag.isOnlyMissing()) {
                for (JavadocTag javadocTag : jdi.getOtherDoc()) {
                    if (!javadocTag.getTypeName().equals(missingTag.getName()) || javadocTag.getComments().size() != 0) continue;
                    this.addMatch(member, TaskSearchMatch.FindingId.MISSING_TAG, "Missing text on tag: " + missingTag.getName());
                }
            }
            ++n2;
        }
    }

    private boolean hasTag(String tagTypeName, JavadocInfo jdi) {
        boolean exists = false;
        for (JavadocTag currentTag : jdi.getOtherDoc()) {
            if (!currentTag.getTypeName().equals(tagTypeName)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private void addMatch(IMember member, TaskSearchMatch.FindingId id, String message) throws JavaModelException {
        ISourceRange sr = member.getNameRange();
        this.addMatch((IJavaElement)member, sr.getOffset(), sr.getLength(), id, message);
    }

    private void addMatch(IJavaElement element, int offset, int length, TaskSearchMatch.FindingId id, String message) {
        Match[] matches;
        boolean matchExists = false;
        Match[] matchArray = matches = this.searchResult.getMatches(element);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            if (match.getOffset() == offset && match.getLength() == length) {
                TaskSearchMatch taskSearchMatch = (TaskSearchMatch)match;
                taskSearchMatch.addFinding(id, message);
                matchExists = true;
                break;
            }
            ++n2;
        }
        if (!matchExists) {
            this.searchResult.addMatch(new TaskSearchMatch(element, offset, length, id, message));
        }
    }

    private boolean needsJavadocCheck(IMember member) throws JavaModelException {
        if (member instanceof IType) {
            return SourceUtils.isMatchingType((IType)member, this.searchPattern) && (this.searchPattern.isMissingJavadoc() || this.searchPattern.isMissingPeriods() || this.searchPattern.isGeneratedJavadoc() || this.searchPattern.isSearchMissingTags() && this.searchPattern.getMissingTags().length > 0);
        }
        if (member instanceof IField) {
            return SourceUtils.isMatchingField((IField)member, this.searchPattern) && (this.searchPattern.isMissingJavadoc() || this.searchPattern.isMissingPeriods() || this.searchPattern.isGeneratedJavadoc() || this.searchPattern.isSearchMissingTags() && this.searchPattern.getMissingTags().length > 0);
        }
        if (member instanceof IMethod) {
            return SourceUtils.isMatchingMethod((IMethod)member, this.searchPattern) && (this.searchPattern.isMissingJavadoc() || this.searchPattern.isMissingPeriods() || this.searchPattern.isMissingParamTag() || this.searchPattern.isMissingReturnTag() || this.searchPattern.isMissingThrowsTag() || this.searchPattern.isGeneratedJavadoc() || this.searchPattern.isSearchMissingTags() && this.searchPattern.getMissingTags().length > 0) && !SourceUtils.isOverridingMethod((IMethod)member);
        }
        return false;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }
}

