/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preview;

import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preview.UndoCompilationUnitChange;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.UndoEdit;

public class CompilationUnitChange
extends TextFileChange {
    private final ICompilationUnit compUnit;
    private ChangeDescriptor descriptor;

    public CompilationUnitChange(String name, ICompilationUnit compUnit) {
        super(name, CompilationUnitChange.getFile(compUnit));
        Assert.isNotNull((Object)compUnit);
        this.compUnit = compUnit;
        this.setTextType("java");
    }

    private static IFile getFile(ICompilationUnit compUnit) {
        return (IFile)compUnit.getResource();
    }

    public Object getModifiedElement() {
        return this.compUnit;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compUnit;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.compUnit.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return super.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        boolean isModified = this.isDocumentModified();
        super.releaseDocument(document, pm);
        try {
            this.compUnit.discardWorkingCopy();
        }
        finally {
            if (isModified && !this.isDocumentAcquired()) {
                if (this.compUnit.isWorkingCopy()) {
                    this.compUnit.reconcile(0, false, null, null);
                } else {
                    this.compUnit.makeConsistent(pm);
                }
            }
        }
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        try {
            return new UndoCompilationUnitChange(this.getName(), this.compUnit, edit, stampToRestore, this.getSaveMode());
        }
        catch (CoreException e) {
            JAutodocPlugin.getDefault().handleException((Exception)((Object)e));
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (ICompilationUnit.class.equals((Object)adapter)) {
            return this.compUnit;
        }
        return super.getAdapter(adapter);
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ChangeDescriptor getDescriptor() {
        return this.descriptor;
    }
}

