/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jautodoc.IApplicationContext;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.ResourceManager;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.preferences.templates.EditTemplatePanel;
import net.sf.jautodoc.templates.ITemplateManager;
import net.sf.jautodoc.templates.LogEntry;
import net.sf.jautodoc.templates.LogListener;
import net.sf.jautodoc.templates.TemplateEngineLogger;
import net.sf.jautodoc.templates.TemplateEntry;
import net.sf.jautodoc.templates.ValidationException;
import net.sf.jautodoc.templates.contentassist.ITemplateContentAssistant;
import net.sf.jautodoc.templates.contentassist.TemplateAssistProcessor;
import net.sf.jautodoc.templates.replacements.ITemplateReplacementsListener;
import net.sf.jautodoc.templates.replacements.ITemplateReplacementsProvider;
import net.sf.jautodoc.templates.replacements.TemplateReplacementsChangeEvent;
import net.sf.jautodoc.templates.rules.IRulesStrategy;
import net.sf.jautodoc.templates.rules.TemplateCodeScanner;
import net.sf.jautodoc.templates.viewer.TemplateViewerConfiguration;
import net.sf.jautodoc.utils.StringUtils;
import net.sf.jautodoc.utils.Utils;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditTemplateDialog
extends TitleAreaDialog
implements ITemplateReplacementsProvider,
LogListener {
    private EditTemplatePanel view;
    private TemplateEntry entry;
    private String templateName;
    private Pattern pattern;
    private Matcher matcher;
    private Matcher parentMatcher;
    private Map<String, String> properties;
    private Set<ITemplateReplacementsListener> resultListener = new HashSet<ITemplateReplacementsListener>();
    private ITemplateManager templateManager;
    private LogEntry logEntry;

    public EditTemplateDialog(Shell parent, TemplateEntry entry, Map<String, String> properties) {
        super(parent);
        this.entry = entry;
        this.properties = properties;
        this.templateManager = JAutodocPlugin.getContext().getTemplateManager();
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.setHelpAvailable(false);
        TemplateEngineLogger.addLogListener(this);
    }

    protected Control createDialogArea(Composite parent) {
        this.view = new EditTemplatePanel(parent, 0);
        this.configureTemplateViewer();
        this.initData();
        this.initListener();
        this.setTitle("Javadoc Template");
        this.setMessage(this.createTitleMessage());
        this.setTitleImage(ResourceManager.getImage("javadoc_template.gif"));
        return this.view;
    }

    protected void okPressed() {
        if (this.validate(false) != null) {
            this.commitData();
            super.okPressed();
        }
    }

    private void configureTemplateViewer() {
        IApplicationContext ctx = JAutodocPlugin.getContext();
        ITextHover editTextHover = ctx.getTemplateTextHover(this.properties);
        IRulesStrategy[] editRuleStrategies = ctx.getTemplateRuleStrategies();
        IAutoEditStrategy[] autoEditStrategies = ctx.getTemplateAutoEditStrategies();
        ITemplateContentAssistant[] assistants = ctx.getTemplateContentAssistants(this.properties);
        TemplateViewerConfiguration configuration = new TemplateViewerConfiguration((ITokenScanner)new TemplateCodeScanner(editRuleStrategies), editTextHover, autoEditStrategies, new TemplateAssistProcessor(assistants));
        this.view.templateViewer.configure(configuration);
        ITextHover previewTextHover = ctx.getTemplateTextHover(this.properties);
        IRulesStrategy[] previewRuleStrategies = ctx.getTemplatePreviewRuleStrategies(this);
        configuration = new TemplateViewerConfiguration((ITokenScanner)new TemplateCodeScanner(previewRuleStrategies), previewTextHover);
        this.view.previewViewer.configure(configuration);
    }

    private void initData() {
        this.view.groupGeneral.setText(String.valueOf(this.entry.getDescription()) + " Template");
        this.view.textName.setText(StringUtils.getLastElement(StringUtils.checkNull(this.entry.getName()), '.'));
        this.view.textRegex.setText(StringUtils.checkNull(this.entry.getRegex()));
        this.view.textExample.setText(StringUtils.checkNull(this.entry.getExample()));
        this.view.radioElementName.setSelection(!this.entry.isUseSignature());
        this.view.radioSignature.setSelection(this.entry.isUseSignature());
        if (this.entry.isDefaultTemplate()) {
            this.view.textName.setEditable(false);
            this.view.textRegex.setEditable(false);
        }
        Document document = null;
        String text = StringUtils.checkNull(this.entry.getText());
        document = text.length() == 0 ? (this.entry.isParameter() ? new Document(Constants.EMPTY_PARAMDOC) : (this.entry.isException() ? new Document(Constants.EMPTY_THROWSDOC) : new Document(Constants.EMPTY_JAVADOC))) : new Document(text);
        this.view.templateViewer.setDocument((IDocument)document);
        this.view.textAreaPreviewGroups.setText("");
        this.view.previewViewer.setDocument((IDocument)new Document(""));
        this.view.tabFolder.setSelection(0);
        TemplateEntry parent = this.entry.getParent();
        if (parent != null) {
            this.view.groupParent.setText("Parent " + parent.getDescription() + " Template");
            this.view.textParentName.setText(StringUtils.getLastElement(parent.getName(), '.'));
            this.view.textParentRegex.setText(parent.getRegex());
            this.view.textParentExample.setText(parent.getExample());
        } else {
            this.view.textParentName.setText("");
            this.view.textParentRegex.setText("");
            this.view.textParentExample.setText("");
        }
    }

    private void initListener() {
        this.view.buttonPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.showPreview();
            }
        });
        this.view.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((EditTemplateDialog)EditTemplateDialog.this).view.tabFolder.getSelectionIndex() == 1) {
                    EditTemplateDialog.this.showPreview();
                }
            }
        });
        VerifyListener verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.getSource() == ((EditTemplateDialog)EditTemplateDialog.this).view.textName && e.character == '.') {
                    EditTemplateDialog.this.setInfo("Please don't use dots for the name.");
                    e.doit = false;
                    return;
                }
                EditTemplateDialog.this.setOK();
            }
        };
        this.view.textName.addVerifyListener(verifyListener);
        this.view.textRegex.addVerifyListener(verifyListener);
        this.view.textExample.addVerifyListener(verifyListener);
        this.view.templateViewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                EditTemplateDialog.this.verifyTemplateViewerKeyPressed(event);
            }
        });
        this.view.previewViewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if (!e.doit) {
                    return;
                }
                if (e.stateMask == SWT.MOD1 && e.character == '\u0014') {
                    ((EditTemplateDialog)EditTemplateDialog.this).view.tabFolder.setSelection(0);
                    ((EditTemplateDialog)EditTemplateDialog.this).view.templateViewer.getControl().forceFocus();
                    e.doit = false;
                    return;
                }
                if (e.keyCode != SWT.MOD1) {
                    EditTemplateDialog.this.setInfo("Please change to the Template tab for editing.");
                }
            }
        });
        this.view.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TemplateEngineLogger.removeLogListener(EditTemplateDialog.this);
            }
        });
        this.addShortcutListener();
    }

    private void addShortcutListener() {
        ShortcutListener listener = new ShortcutListener();
        this.view.textName.addKeyListener((KeyListener)listener);
        this.view.textRegex.addKeyListener((KeyListener)listener);
        this.view.textExample.addKeyListener((KeyListener)listener);
        this.view.templateViewer.prependVerifyKeyListener(listener);
        this.view.previewViewer.prependVerifyKeyListener(listener);
    }

    private void verifyTemplateViewerKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        this.setOK();
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this.view.templateViewer.doOperation(13);
                event.doit = false;
                break;
            }
            case '\u001a': {
                this.view.templateViewer.doOperation(1);
                event.doit = false;
                break;
            }
            case '\u0019': {
                this.view.templateViewer.doOperation(2);
                event.doit = false;
            }
        }
    }

    private void commitData() {
        this.entry.setName(this.templateName);
        this.entry.setRegex(this.view.textRegex.getText().trim());
        this.entry.setExample(this.view.textExample.getText().trim());
        this.entry.setText(this.view.templateViewer.getTextWidget().getText().trim());
        this.entry.setUseSignature(this.view.radioSignature.getSelection());
        this.templateManager.putTemplate(this.entry);
    }

    private String createTitleMessage() {
        String title = this.entry.getName() == null ? "Add" : "Edit";
        title = String.valueOf(title) + " " + this.entry.getDescription();
        title = String.valueOf(title) + " Template";
        return title;
    }

    private void showPreview() {
        String templateText = this.validate(true);
        if (templateText == null) {
            return;
        }
        this.fireTemplateResultChangeEvent();
        this.setPreviewGroupsText(this.matcher, this.parentMatcher);
        this.view.previewViewer.setDocument((IDocument)new Document(templateText));
        if (this.view.tabFolder.getSelectionIndex() != 1) {
            this.view.tabFolder.setSelection(1);
            this.view.previewViewer.getControl().forceFocus();
        }
    }

    private String evaluateTemplate(String templateText) {
        String text = null;
        try {
            this.logEntry = null;
            text = this.templateManager.evaluateTemplate(this.matcher, this.parentMatcher, templateText, this.entry, this.properties);
            if (this.logEntry != null) {
                if (this.logEntry.getSeverity() != 4) {
                    this.setInfo(this.logEntry.getMessage());
                } else {
                    this.setError(this.logEntry.getMessage());
                }
                int offset = Utils.getDocumentOffset(this.view.templateViewer.getDocument(), this.logEntry.getLine(), this.logEntry.getColumn());
                if (offset >= 0) {
                    this.view.templateViewer.getTextWidget().setSelection(offset);
                    this.view.templateViewer.getTextWidget().forceFocus();
                }
                text = null;
            }
        }
        catch (Exception e) {
            this.setError(e.getMessage());
        }
        return text;
    }

    private void setOK() {
        this.setMessage(this.createTitleMessage());
        this.setErrorMessage(null);
    }

    private void setInfo(String message) {
        this.setMessage(message, 2);
    }

    private void setError(String message) {
        this.setErrorMessage(message);
    }

    private String validate(boolean preview) {
        if (!((preview || this.validateText(this.view.textName, "Please insert a name for the template.", true)) && this.validateText(this.view.textRegex, "Please insert a valid regular expression.", true) && this.validateText(this.view.textExample, "Please insert an example that matches the regular expression.", true) && this.validateText(this.view.templateViewer.getTextWidget(), "Please insert a text for the template.", true))) {
            return null;
        }
        if (!this.validatePattern() || !this.validateTemplate() || !preview && !this.validateName()) {
            return null;
        }
        this.matcher = this.pattern.matcher(this.view.textExample.getText());
        Matcher matcher = this.parentMatcher = this.entry.getParent() != null ? this.getParentMatcher() : null;
        if (!this.matcher.matches()) {
            this.setError("The example doesn't match the regular expression.");
            this.view.textExample.forceFocus();
            return null;
        }
        String evaluatedText = this.evaluateTemplate(this.view.templateViewer.getTextWidget().getText());
        if (evaluatedText == null) {
            this.view.tabFolder.setSelection(0);
            this.view.templateViewer.getTextWidget().forceFocus();
            return null;
        }
        return this.validateComment(evaluatedText) ? evaluatedText : null;
    }

    private boolean validateComment(String evaluatedText) {
        IScanner commentScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        commentScanner.setSource(evaluatedText.toCharArray());
        try {
            int token = commentScanner.getNextToken();
            if (Utils.isJavadocComment(token) && (token = commentScanner.getNextToken()) == 158) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        this.setError("Please insert a valid Javadoc comment.");
        return false;
    }

    private boolean validateText(Text text, String message, boolean error) {
        return this.validateText((Control)text, text.getText(), message, error);
    }

    private boolean validateText(StyledText text, String message, boolean error) {
        return this.validateText((Control)text, text.getText(), message, error);
    }

    private boolean validateText(Control control, String text, String message, boolean error) {
        if (text.trim().length() == 0) {
            if (!error) {
                this.setInfo(message);
            } else {
                this.setError(message);
            }
            control.forceFocus();
            return false;
        }
        this.setOK();
        return true;
    }

    private boolean validatePattern() {
        this.pattern = this.compilePattern(this.view.textRegex.getText(), false);
        return this.pattern != null;
    }

    private boolean validateName() {
        this.templateName = this.entry.getParent() == null ? "" : String.valueOf(this.entry.getParent().getName()) + ".";
        this.templateName = String.valueOf(this.templateName) + this.entry.getDescription() + "." + this.view.textName.getText().trim();
        if ((this.entry.getName() == null || !this.entry.getName().equals(this.templateName)) && this.templateManager.existsTemplate(this.templateName)) {
            this.setError("A template with this name already exists.");
            this.view.textName.forceFocus();
            return false;
        }
        this.setOK();
        return true;
    }

    private boolean validateTemplate() {
        String message = "";
        String templateText = this.view.templateViewer.getTextWidget().getText();
        try {
            this.templateManager.validateTemplate(templateText);
            return true;
        }
        catch (ValidationException ve) {
            message = ve.getMessage();
            int offset = Utils.getDocumentOffset(this.view.templateViewer.getDocument(), ve.getLine(), ve.getColumn());
            if (offset >= 0) {
                this.view.templateViewer.getTextWidget().setSelection(offset);
                this.view.templateViewer.getTextWidget().forceFocus();
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        this.setError("Invalid template: " + message);
        this.view.tabFolder.setSelection(0);
        this.view.templateViewer.getTextWidget().forceFocus();
        return false;
    }

    private Matcher getParentMatcher() {
        Pattern pattern;
        Matcher matcher = null;
        String example = this.view.textParentExample.getText().trim();
        if (example.length() > 0 && (pattern = this.compilePattern(this.entry.getParent().getRegex(), true)) != null) {
            matcher = pattern.matcher(this.view.textParentExample.getText());
        }
        return matcher;
    }

    private Pattern compilePattern(String regex, boolean silent) {
        Pattern pattern;
        block3: {
            pattern = null;
            try {
                pattern = Pattern.compile(regex);
                if (!silent) {
                    this.setOK();
                }
            }
            catch (Exception e) {
                if (silent) break block3;
                int index = e.getMessage().indexOf(Constants.LINE_SEPARATOR);
                String message = index < 0 ? e.getMessage() : e.getMessage().substring(0, index);
                this.setError("Invalid regular expression: " + message);
            }
        }
        return pattern;
    }

    private void setPreviewGroupsText(Matcher matcher, Matcher parentMatcher) {
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(Constants.TEMPLATES_DLG_HEADING_GROUPS) + Constants.LINE_SEPARATOR);
        TextAttribute ta = ResourceManager.getTextAttribute("heading");
        ranges.add(new StyleRange(0, buffer.length(), ta.getForeground(), ta.getBackground(), ta.getStyle()));
        this.createPreviewGroupsText(matcher, buffer, ranges);
        if (parentMatcher != null) {
            int startIndex = buffer.length();
            buffer.append(String.valueOf(Constants.LINE_SEPARATOR) + Constants.TEMPLATES_DLG_HEADING_PARENTGROUPS + Constants.LINE_SEPARATOR);
            ranges.add(new StyleRange(startIndex, buffer.length() - startIndex, ta.getForeground(), ta.getBackground(), ta.getStyle()));
            this.createPreviewGroupsText(parentMatcher, buffer, ranges);
        }
        this.view.textAreaPreviewGroups.setText(buffer.toString());
        this.view.textAreaPreviewGroups.setStyleRanges(ranges.toArray(new StyleRange[ranges.size()]));
    }

    private void createPreviewGroupsText(Matcher matcher, StringBuffer buffer, List<StyleRange> ranges) {
        int startIndex = buffer.length();
        if (!matcher.matches()) {
            buffer.append(String.valueOf(Constants.TEMPLATES_DLG_NOMATCH) + Constants.LINE_SEPARATOR);
            TextAttribute ta = ResourceManager.getTextAttribute("nomatch");
            ranges.add(new StyleRange(startIndex, buffer.length() - startIndex, ta.getForeground(), ta.getBackground(), ta.getStyle()));
            return;
        }
        TextAttribute taNormal = ResourceManager.getTextAttribute("normal");
        TextAttribute taGroup = ResourceManager.getTextAttribute("group");
        int i = 0;
        while (i <= matcher.groupCount()) {
            buffer.append(i + ": ");
            ranges.add(new StyleRange(startIndex, buffer.length() - startIndex, taNormal.getForeground(), taNormal.getBackground(), taNormal.getStyle()));
            startIndex = buffer.length();
            buffer.append(String.valueOf(matcher.group(i)) + Constants.LINE_SEPARATOR);
            ranges.add(new StyleRange(startIndex, buffer.length() - startIndex, taGroup.getForeground(), taGroup.getBackground(), taGroup.getStyle()));
            startIndex = buffer.length();
            ++i;
        }
    }

    @Override
    public Collection<String> getReplacements() {
        String group;
        if (this.matcher == null || !this.matcher.matches()) {
            return new TreeMap().values();
        }
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        int i = 0;
        while (i <= this.matcher.groupCount()) {
            String string = group = this.matcher.group(i) != null ? this.matcher.group(i).trim() : "";
            if (group.length() > 0) {
                this.putReplacementEntry(map, group);
                this.putReplacementEntry(map, StringUtils.split(group));
            }
            ++i;
        }
        if (this.parentMatcher == null || !this.parentMatcher.matches()) {
            return map.values();
        }
        i = 0;
        while (i <= this.parentMatcher.groupCount()) {
            group = this.parentMatcher.group(i).trim();
            if (group.length() > 0) {
                this.putReplacementEntry(map, group);
                this.putReplacementEntry(map, StringUtils.split(group));
            }
            ++i;
        }
        return map.values();
    }

    @Override
    public void addTemplateReplacementsListener(ITemplateReplacementsListener listener) {
        this.resultListener.add(listener);
    }

    private void putReplacementEntry(Map<Integer, String> map, String string) {
        map.put(-1 * string.length(), string);
    }

    private void fireTemplateResultChangeEvent() {
        Iterator<ITemplateReplacementsListener> iter = this.resultListener.iterator();
        while (iter.hasNext()) {
            iter.next().templateReplacementsChange(new TemplateReplacementsChangeEvent(this.getReplacements()));
        }
    }

    @Override
    public void messageLogged(LogEntry logEntry) {
        this.logEntry = logEntry;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(this.getClass().getName()) + "_dialogBounds";
        IDialogSettings settings = JAutodocPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    private class ShortcutListener
    implements KeyListener,
    VerifyKeyListener {
        private ShortcutListener() {
        }

        public void keyPressed(KeyEvent e) {
            this.handleKeyEvent(e);
        }

        public void keyReleased(KeyEvent e) {
        }

        public void verifyKey(VerifyEvent e) {
            this.handleKeyEvent((KeyEvent)e);
        }

        private void handleKeyEvent(KeyEvent e) {
            if (e.stateMask != SWT.MOD1) {
                return;
            }
            if (e.character == '\u0013') {
                EditTemplateDialog.this.showPreview();
                e.doit = false;
            } else if (e.character == '\u0010') {
                EditTemplateDialog.this.showPreview();
                e.doit = false;
            }
        }
    }
}

