/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.templates;

import java.util.ArrayList;
import java.util.Map;
import net.sf.jautodoc.preferences.ITableEntry;
import net.sf.jautodoc.preferences.TableContentProvider;
import net.sf.jautodoc.preferences.TableLabelProvider;
import net.sf.jautodoc.preferences.templates.EditPropertiesPanel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EditPropertiesDialog
extends StatusDialog {
    private static final int STATE_VIEW = 0;
    private static final int STATE_ADD = 1;
    private static final int STATE_EDIT = 2;
    private static final String[] tableColumnHeaders = new String[]{"Name", "Value"};
    private static final ColumnLayoutData[] tableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(40), new ColumnWeightData(60)};
    private Map<String, String> properties;
    private EditPropertiesPanel view;
    private int state = 0;
    private MyStatus status = new MyStatus();

    public EditPropertiesDialog(Shell parent, Map<String, String> properties) {
        super(parent);
        this.properties = properties;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.view = new EditPropertiesPanel(parent, 0);
        this.configureTableViewer();
        this.initData();
        this.initListener();
        this.updateStates();
        return this.view;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Edit Properties");
    }

    protected void okPressed() {
        if (this.state != 0) {
            if (this.view.buttonApply.isEnabled()) {
                this.doApply();
            } else if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)"Discard changes", (String)"Current editing is not applied. Discard changes?")) {
                return;
            }
        }
        this.saveProperties();
        super.okPressed();
    }

    private void configureTableViewer() {
        this.view.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.view.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.view.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditPropertiesDialog.this.showSelected();
                EditPropertiesDialog.this.updateStates();
            }
        });
        this.view.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((EditPropertiesDialog)EditPropertiesDialog.this).view.buttonEdit.isEnabled()) {
                    EditPropertiesDialog.this.doEdit();
                }
            }
        });
        this.view.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (((EditPropertiesDialog)EditPropertiesDialog.this).view.buttonRemove.isEnabled() && event.keyCode == 127 && event.stateMask == 0) {
                    EditPropertiesDialog.this.doRemove();
                } else if (((EditPropertiesDialog)EditPropertiesDialog.this).view.buttonAdd.isEnabled() && event.keyCode == 0x1000009 && event.stateMask == 0) {
                    EditPropertiesDialog.this.doAdd();
                }
            }
        });
        Table table = this.view.tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int i = 0;
        while (i < tableColumnHeaders.length) {
            tableLayout.addColumnData(tableColumnLayouts[i]);
            TableColumn column = new TableColumn(table, 0, i);
            column.setResizable(EditPropertiesDialog.tableColumnLayouts[i].resizable);
            column.setText(tableColumnHeaders[i]);
            ++i;
        }
    }

    private void initListener() {
        this.view.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditPropertiesDialog.this.doAdd();
            }
        });
        this.view.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditPropertiesDialog.this.doEdit();
            }
        });
        this.view.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditPropertiesDialog.this.doRemove();
            }
        });
        this.view.buttonApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditPropertiesDialog.this.doApply();
            }
        });
        this.view.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditPropertiesDialog.this.doCancel();
            }
        });
        this.view.textName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.character == '.') {
                    EditPropertiesDialog.this.setWarning("No dots allowed.");
                    e.doit = false;
                } else {
                    EditPropertiesDialog.this.setOK();
                }
            }
        });
        this.view.textName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                EditPropertiesDialog.this.validateApply();
            }
        });
        this.view.textValue.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                EditPropertiesDialog.this.validateApply();
                EditPropertiesDialog.this.setOK();
            }
        });
    }

    private void initData() {
        ArrayList<Property> list = new ArrayList<Property>();
        for (String name : this.properties.keySet()) {
            list.add(new Property(name, this.properties.get(name)));
        }
        this.view.tableViewer.setInput((Object)list.toArray(new Property[list.size()]));
        this.updateStates();
    }

    private void setOK() {
        this.status.setSeverity(0);
        this.status.setMessage("");
        this.updateStatus((IStatus)this.status);
    }

    private void setWarning(String message) {
        this.status.setSeverity(2);
        this.status.setMessage(message);
        this.updateStatus((IStatus)this.status);
    }

    private void validateApply() {
        this.view.buttonApply.setEnabled(this.state != 0 && this.view.textName.getText().trim().length() > 0 && this.view.textValue.getText().trim().length() > 0);
    }

    private void doAdd() {
        this.view.textName.setText("");
        this.view.textValue.setText("");
        this.state = 1;
        this.updateStates();
    }

    private void doEdit() {
        this.state = 2;
        this.updateStates();
    }

    private void doRemove() {
        ((TableContentProvider)this.view.tableViewer.getContentProvider()).remove((IStructuredSelection)this.view.tableViewer.getSelection());
        this.updateStates();
    }

    private void doApply() {
        String name = this.view.textName.getText().trim();
        String value = this.view.textValue.getText().trim();
        boolean ok = false;
        if (this.state == 1) {
            Property property = new Property(name, value);
            if (this.checkOverwrite(property)) {
                ((TableContentProvider)this.view.tableViewer.getContentProvider()).add(property);
                ok = true;
            }
        } else if (this.state == 2) {
            Property property = this.getSelectedProperty();
            Property newProperty = new Property(name, value);
            if (property.equals(new Property(name, value)) || this.checkOverwrite(newProperty)) {
                property.setName(name);
                property.setValue(value);
                this.view.tableViewer.refresh();
                ok = true;
            }
        }
        if (ok) {
            this.state = 0;
            this.updateStates();
        } else {
            this.view.textName.forceFocus();
        }
    }

    private void doCancel() {
        this.state = 0;
        this.showSelected();
        this.updateStates();
    }

    private void showSelected() {
        Property property = this.getSelectedProperty();
        if (property != null) {
            this.view.textName.setText(property.getName());
            this.view.textValue.setText(property.getValue());
        } else {
            this.view.textName.setText("");
            this.view.textValue.setText("");
        }
    }

    private void saveProperties() {
        Object[] obj = ((TableContentProvider)this.view.tableViewer.getContentProvider()).getElements(null);
        this.properties.clear();
        int i = 0;
        while (i < obj.length) {
            Property property = (Property)obj[i];
            this.properties.put(property.getName(), property.getValue());
            ++i;
        }
    }

    private boolean checkOverwrite(Property newProperty) {
        TableContentProvider cp = (TableContentProvider)this.view.tableViewer.getContentProvider();
        Object[] properties = cp.getElements(null);
        int i = 0;
        while (i < properties.length) {
            Property property = (Property)properties[i];
            if (property.equals(newProperty)) {
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)"Overwrite exists", (String)"Property already exists. Replace?")) {
                    return false;
                }
                cp.remove(property);
                break;
            }
            ++i;
        }
        return true;
    }

    private void updateStates() {
        IStructuredSelection selection = (IStructuredSelection)this.view.tableViewer.getSelection();
        if (this.state == 0) {
            this.view.tableViewer.getControl().setEnabled(true);
            this.view.buttonAdd.setEnabled(true);
            this.view.buttonEdit.setEnabled(selection.size() == 1);
            this.view.buttonRemove.setEnabled(selection.size() > 0);
            this.view.buttonApply.setEnabled(false);
            this.view.buttonCancel.setEnabled(false);
            this.view.textName.setEnabled(false);
            this.view.textValue.setEnabled(false);
            this.view.tableViewer.getControl().forceFocus();
        } else {
            this.view.tableViewer.getControl().setEnabled(false);
            this.view.buttonAdd.setEnabled(false);
            this.view.buttonEdit.setEnabled(false);
            this.view.buttonRemove.setEnabled(false);
            this.view.buttonApply.setEnabled(true);
            this.view.buttonCancel.setEnabled(true);
            this.view.textName.setEnabled(true);
            this.view.textValue.setEnabled(true);
            this.view.textName.forceFocus();
            this.validateApply();
        }
    }

    private Property getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.view.tableViewer.getSelection();
        if (selection.size() == 0) {
            return null;
        }
        return (Property)selection.getFirstElement();
    }

    private static class MyStatus
    extends Status {
        public MyStatus() {
            super(0, "net.sf.jautodoc", 0, "", null);
        }

        public void setMessage(String message) {
            super.setMessage(message);
        }

        public void setSeverity(int severity) {
            super.setSeverity(severity);
        }
    }

    private static class Property
    implements ITableEntry,
    Comparable<Property> {
        private String name;
        private String value;

        public Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public String getColumnText(int columnIndex) {
            if (columnIndex == 0) {
                return this.name;
            }
            if (columnIndex == 1) {
                return this.value;
            }
            return null;
        }

        @Override
        public int compareTo(Property other) {
            return this.getName().compareTo(other.getName());
        }

        public boolean equals(Object other) {
            if (!(other instanceof Property)) {
                return false;
            }
            return this.getName().equals(((Property)other).getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return "Name: " + this.getName() + ", Value: " + this.getValue();
        }
    }
}

