/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.templates;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import net.sf.jautodoc.IApplicationContext;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.ResourceManager;
import net.sf.jautodoc.preferences.templates.EditPropertiesDialog;
import net.sf.jautodoc.templates.ITemplateManager;
import net.sf.jautodoc.templates.LogEntry;
import net.sf.jautodoc.templates.LogListener;
import net.sf.jautodoc.templates.TemplateEngineLogger;
import net.sf.jautodoc.templates.ValidationException;
import net.sf.jautodoc.templates.contentassist.ITemplateContentAssistant;
import net.sf.jautodoc.templates.contentassist.TemplateAssistProcessor;
import net.sf.jautodoc.templates.rules.IRulesStrategy;
import net.sf.jautodoc.templates.rules.TemplateCodeScanner;
import net.sf.jautodoc.templates.viewer.TemplateViewer;
import net.sf.jautodoc.templates.viewer.TemplateViewerConfiguration;
import net.sf.jautodoc.utils.Utils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractEditTextDialog
extends TitleAreaDialog
implements LogListener {
    private static final int IMPORT_ID = 257;
    private static final int EXPORT_ID = 258;
    private static final int PROPERTIES_ID = 259;
    protected Map<String, String> properties;
    private String text;
    private TemplateViewer templateViewer;
    private ITemplateManager templateManager;
    private LogEntry logEntry;

    protected AbstractEditTextDialog(Shell parentShell, String text, Map<String, String> properties) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.setHelpAvailable(false);
        TemplateEngineLogger.addLogListener(this);
        this.templateManager = JAutodocPlugin.getContext().getTemplateManager();
        this.text = text == null ? "" : text;
        this.properties = properties;
    }

    public String getText() {
        return this.text;
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.heightHint = 250;
        gridData.widthHint = 550;
        base.setLayoutData((Object)gridData);
        this.templateViewer = new TemplateViewer(base, 2816);
        this.templateViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.configureTemplateViewer();
        this.templateViewer.setDocument((IDocument)new Document(this.text));
        this.setInitialCursorPosition();
        this.initListener();
        this.setTitle(this.getTitle());
        this.setMessage(this.getHint());
        this.setTitleImage(ResourceManager.getImage("javadoc_template.gif"));
        return base;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 257, "Import...", false);
        this.createButton(parent, 258, "Export...", false);
        this.createButton(parent, 259, "Properties...", false);
        ++((GridLayout)parent.getLayout()).numColumns;
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData());
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 257) {
            this.importText();
            return;
        }
        if (buttonId == 258) {
            this.exportText();
            return;
        }
        if (buttonId == 259) {
            this.showPropertiesDialog();
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        String templateText = this.templateViewer.getDocument().get().trim();
        if (this.validate(templateText)) {
            this.text = templateText;
            super.okPressed();
        }
    }

    private void configureTemplateViewer() {
        IApplicationContext ctx = JAutodocPlugin.getContext();
        ITextHover editTextHover = ctx.getTemplateTextHover(this.properties);
        IRulesStrategy[] editRuleStrategies = ctx.getTemplateRuleStrategies();
        IAutoEditStrategy[] autoEditStrategies = ctx.getTemplateAutoEditStrategies();
        ITemplateContentAssistant[] assistants = this.getTemplateContentAssistants();
        TemplateViewerConfiguration configuration = new TemplateViewerConfiguration((ITokenScanner)new TemplateCodeScanner(editRuleStrategies), editTextHover, autoEditStrategies, new TemplateAssistProcessor(assistants));
        this.templateViewer.configure(configuration);
    }

    private void initListener() {
        this.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TemplateEngineLogger.removeLogListener(AbstractEditTextDialog.this);
            }
        });
        this.templateViewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                AbstractEditTextDialog.this.verifyTemplateViewerKeyPressed(event);
            }
        });
    }

    private void verifyTemplateViewerKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        this.setOK();
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this.templateViewer.doOperation(13);
                event.doit = false;
                break;
            }
            case '\u001a': {
                this.templateViewer.doOperation(1);
                event.doit = false;
                break;
            }
            case '\u0019': {
                this.templateViewer.doOperation(2);
                event.doit = false;
                break;
            }
            case '\u0013': {
                this.okPressed();
                event.doit = false;
            }
        }
    }

    private boolean validate(String templateText) {
        if ("".equals(templateText)) {
            return true;
        }
        if (!this.validateTemplate(templateText)) {
            return false;
        }
        String evaluatedText = this.evaluateTemplate(templateText);
        if (evaluatedText == null) {
            return false;
        }
        return this.validateEvaluatedText(evaluatedText);
    }

    private boolean validateTemplate(String templateText) {
        String message = "";
        try {
            this.templateManager.validateTemplate(templateText);
            return true;
        }
        catch (ValidationException ve) {
            message = ve.getMessage();
            int offset = Utils.getDocumentOffset(this.templateViewer.getDocument(), ve.getLine(), ve.getColumn());
            if (offset >= 0) {
                this.templateViewer.getTextWidget().setSelection(offset);
                this.templateViewer.getTextWidget().forceFocus();
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        this.setError("Invalid template: " + message);
        return false;
    }

    private String evaluateTemplate(String templateText) {
        this.logEntry = null;
        String evaluatedText = null;
        try {
            evaluatedText = this.templateManager.evaluateTemplate(null, templateText, "Template Text", this.properties);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            return null;
        }
        if (this.logEntry == null) {
            return evaluatedText;
        }
        if (this.logEntry.getSeverity() != 4) {
            this.setInfo(this.logEntry.getMessage());
        } else {
            this.setError(this.logEntry.getMessage());
        }
        int offset = Utils.getDocumentOffset(this.templateViewer.getDocument(), this.logEntry.getLine(), this.logEntry.getColumn());
        if (offset >= 0) {
            this.templateViewer.getTextWidget().setSelection(offset);
            this.templateViewer.getTextWidget().forceFocus();
        }
        return null;
    }

    protected void setOK() {
        this.setMessage(this.getHint());
        this.setErrorMessage(null);
    }

    protected void setInfo(String message) {
        this.setMessage(message, 2);
    }

    protected void setError(String message) {
        this.setErrorMessage(message);
    }

    protected void setInitialCursorPosition() {
        try {
            IDocument document = this.templateViewer.getDocument();
            int xlineOffset = this.getLineOffset() + 1;
            int numLines = document.getNumberOfLines();
            if (numLines < xlineOffset) {
                return;
            }
            int line = numLines - xlineOffset;
            int lineOffset = document.getLineOffset(line);
            int lineLenght = document.getLineLength(line);
            String delim = document.getLineDelimiter(line);
            if (delim == null) {
                this.templateViewer.getTextWidget().setSelection(lineOffset + lineLenght);
            } else {
                this.templateViewer.getTextWidget().setSelection(lineOffset + lineLenght - delim.length());
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void importText() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("Import");
        fileDialog.setFilterExtensions(this.getFilterExtensions());
        String selectedFile = fileDialog.open();
        if (selectedFile == null) {
            return;
        }
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(selectedFile));
                String delim = TextUtilities.getDefaultLineDelimiter((IDocument)this.templateViewer.getDocument());
                StringBuffer buffer = new StringBuffer();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    buffer.append(String.valueOf(line) + delim);
                }
                this.templateViewer.setDocument((IDocument)new Document(buffer.toString()));
                this.setInitialCursorPosition();
                this.setOK();
            }
            catch (IOException e) {
                this.setError("Could not read file: " + e.getMessage());
                Utils.close(reader);
                return;
            }
        }
        catch (Throwable throwable) {
            Utils.close(reader);
            throw throwable;
        }
        Utils.close(reader);
    }

    private void exportText() {
        block7: {
            FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
            fileDialog.setText("Export");
            fileDialog.setFileName(this.getExportFileName());
            fileDialog.setFilterExtensions(this.getFilterExtensions());
            String selectedFile = fileDialog.open();
            if (selectedFile == null) {
                return;
            }
            File file = new File(selectedFile);
            if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)"File exists", (String)("File '" + file.getName() + "' already exists. Replace?"))) {
                return;
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file);
                    writer.write(this.templateViewer.getDocument().get());
                }
                catch (IOException e) {
                    this.setError("Could not write file: " + e.getMessage());
                    Utils.close(writer);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Utils.close(writer);
                throw throwable;
            }
            Utils.close(writer);
        }
    }

    private void showPropertiesDialog() {
        EditPropertiesDialog dialog = new EditPropertiesDialog(this.getShell(), this.properties);
        dialog.open();
    }

    @Override
    public void messageLogged(LogEntry logEntry) {
        this.logEntry = logEntry;
    }

    protected abstract ITemplateContentAssistant[] getTemplateContentAssistants();

    protected abstract boolean validateEvaluatedText(String var1);

    protected abstract String getTitle();

    protected abstract String getHint();

    protected abstract String getExportFileName();

    protected abstract String[] getFilterExtensions();

    protected abstract int getLineOffset();
}

