/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.ResourceManager;
import net.sf.jautodoc.preferences.PreferenceType;
import net.sf.jautodoc.utils.SimpleTreeContentProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportExportDialog
extends TitleAreaDialog
implements Listener {
    private static final String DESTINATIONS = "DESTINATIONS";
    private static final String PREFERENCETYPES = "PREFERENCETYPES";
    private static final String OVERWRITEEXISTING = "OVERWRITEEXISTING";
    private Text descriptionText;
    private CheckboxTreeViewer treeViewer;
    private Button destinationBrowseButton;
    private Button overwriteExistingFilesCheckbox;
    private Combo destinationNameField;
    private String currentMessage;
    private final Type type;
    private final List<PreferenceType> preferenceTypes;
    private String selectedFileName;
    private List<PreferenceType> selectedPreferenceTypes;

    public ImportExportDialog(Shell parentShell, Type type, List<PreferenceType> preferenceTypes) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.type = type;
        this.preferenceTypes = preferenceTypes;
    }

    public String getSelectedFileName() {
        return this.selectedFileName;
    }

    public List<PreferenceType> getSelectedPreferenceTypes() {
        return this.selectedPreferenceTypes;
    }

    protected void okPressed() {
        this.selectedFileName = this.getDestinationValue();
        this.selectedPreferenceTypes = new ArrayList<PreferenceType>();
        Object[] objectArray = this.treeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.selectedPreferenceTypes.add((PreferenceType)((Object)element));
            ++n2;
        }
        this.saveWidgetValues();
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.type.getTitle());
    }

    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        this.setPageComplete(this.validateDestinationGroup() && this.validateOptionsGroup());
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.type.getTitle());
        this.setMessage(this.type.getMessage());
        this.setTitleImage(ResourceManager.getImage(this.type.getImageFileName()));
        this.initializeDialogUnits((Control)parent);
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 250;
        base.setLayoutData((Object)gridData);
        Group group = new Group(base, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.treeViewer = new CheckboxTreeViewer((Composite)group, 2820);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(768));
        this.treeViewer.setContentProvider((IContentProvider)new SimpleTreeContentProvider(this.preferenceTypes));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer.setInput((Object)PreferenceType.values());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportExportDialog.this.updateDescription();
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportExportDialog.this.updatePageCompletion();
            }
        });
        Label description = new Label((Composite)group, 0);
        description.setText("Description:");
        description.setLayoutData((Object)new GridData(768));
        this.descriptionText = new Text((Composite)group, 2632);
        GridData descriptionData = new GridData(1808);
        descriptionData.heightHint = this.convertHeightInCharsToPixels(3);
        this.descriptionText.setLayoutData((Object)descriptionData);
        this.addSelectionButtons((Composite)group);
        this.createDestinationGroup(base);
        this.createOptionsGroup(base);
        this.restoreWidgetValues();
        return base;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        buttonComposite.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        final Button selectAllButton = this.createButton(buttonComposite, 18, "&Select All", false);
        Button deselectAllButton = this.createButton(buttonComposite, 19, "&Deselect All", false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportDialog.this.treeViewer.setAllChecked(e.widget == selectAllButton);
                ImportExportDialog.this.updatePageCompletion();
            }
        };
        selectAllButton.addSelectionListener((SelectionListener)listener);
        deselectAllButton.addSelectionListener((SelectionListener)listener);
    }

    private void createDestinationGroup(Composite parent) {
        Composite destinationSelectionGroup = new Composite(parent, 0);
        destinationSelectionGroup.setLayout((Layout)new GridLayout(3, false));
        destinationSelectionGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label dest = new Label(destinationSelectionGroup, 0);
        dest.setText(this.type.getFileDescription());
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText("B&rowse...");
        this.setButtonLayoutData(this.destinationBrowseButton);
        this.destinationBrowseButton.addListener(13, (Listener)this);
    }

    private void createOptionsGroup(Composite parent) {
        if (this.type == Type.EXPORT) {
            Composite optionsGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            optionsGroup.setLayout((Layout)layout);
            optionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.overwriteExistingFilesCheckbox = new Button(optionsGroup, 32);
            this.overwriteExistingFilesCheckbox.setText("&Overwrite existing files without warning");
        }
    }

    private void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getShell(), this.type.getFileDialogStyle());
        dialog.setText(this.type.getFileDialogTitle());
        if (this.type == Type.EXPORT && this.getDestinationValue().isEmpty()) {
            dialog.setFileName("jautodoc_preferences.xml");
        } else {
            dialog.setFileName(this.getDestinationValue());
        }
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dialog.setOverwrite(this.type == Type.EXPORT && !this.overwriteExistingFilesCheckbox.getSelection());
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.setDestinationValue(selectedFileName);
        }
    }

    private void updateDescription() {
        Object element;
        String desc = "";
        ISelection selection = this.treeViewer.getSelection();
        if (!selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof PreferenceType) {
            desc = ((PreferenceType)((Object)element)).getDescription();
        }
        this.descriptionText.setText(desc);
    }

    private void updatePageCompletion() {
        this.setPageComplete(this.determinePageCompletion());
    }

    private boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateDestinationGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.currentMessage);
        }
        return complete;
    }

    private boolean validateDestinationGroup() {
        File file = new File(this.getDestinationValue());
        if (!this.isValidFile(file)) {
            this.currentMessage = this.type.getInvalidDestinationMessage();
            return false;
        }
        return true;
    }

    private boolean isValidFile(File file) {
        if (this.type == Type.IMPORT) {
            return file.exists() && !file.isDirectory();
        }
        return file.getPath().length() > 0 && !file.isDirectory();
    }

    private boolean validateOptionsGroup() {
        boolean isValid = true;
        Object[] checkedElements = this.treeViewer.getCheckedElements();
        if (checkedElements == null || checkedElements.length == 0) {
            this.currentMessage = "No specific preferences are selected.";
            isValid = false;
        }
        return isValid;
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettingsSection();
        Object[] elements = this.treeViewer.getCheckedElements();
        String[] preferenceIds = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            PreferenceType element = (PreferenceType)((Object)elements[i]);
            preferenceIds[i] = element.name();
            ++i;
        }
        settings.put(PREFERENCETYPES, preferenceIds);
        String destination = this.getDestinationValue();
        if (!destination.isEmpty()) {
            ArrayList<String> destinations = new ArrayList<String>(Arrays.asList(this.destinationNameField.getItems()));
            destinations.remove(destination);
            destinations.add(0, destination);
            if (destinations.size() > 5) {
                destinations.remove(5);
            }
            settings.put(DESTINATIONS, destinations.toArray(new String[destinations.size()]));
        }
        if (this.overwriteExistingFilesCheckbox != null) {
            settings.put(OVERWRITEEXISTING, this.overwriteExistingFilesCheckbox.getSelection());
        }
    }

    private void restoreWidgetValues() {
        int i;
        IDialogSettings settings = this.getDialogSettingsSection();
        String[] preferenceIds = settings.getArray(PREFERENCETYPES);
        if (preferenceIds != null && preferenceIds.length > 0) {
            PreferenceType[] preferenceTypes = PreferenceType.values();
            i = 0;
            while (i < preferenceTypes.length) {
                int j = 0;
                while (j < preferenceIds.length) {
                    if (preferenceTypes[i].name().equals(preferenceIds[j])) {
                        this.treeViewer.setChecked((Object)preferenceTypes[i], true);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.treeViewer.setAllChecked(true);
        }
        String[] destinations = settings.getArray(DESTINATIONS);
        if (destinations != null && destinations.length > 0) {
            i = 0;
            while (i < destinations.length) {
                this.destinationNameField.add(destinations[i]);
                ++i;
            }
            this.setDestinationValue(destinations[0]);
        }
        if (this.overwriteExistingFilesCheckbox != null) {
            this.overwriteExistingFilesCheckbox.setSelection(settings.getBoolean(OVERWRITEEXISTING));
        }
    }

    private IDialogSettings getDialogSettingsSection() {
        return JAutodocPlugin.getDefault().getDialogSettingsSection("ImportExportDialog-" + this.type.name());
    }

    private void setPageComplete(boolean complete) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(complete);
        }
    }

    private String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    private void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    public void handleEvent(Event e) {
        if (e.widget == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    private static final class TreeLabelProvider
    extends LabelProvider {
        private TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return ResourceManager.getImage(((PreferenceType)((Object)element)).getImageFileName());
        }

        public String getText(Object element) {
            return ((PreferenceType)((Object)element)).getTitle();
        }
    }

    public static enum Type {
        IMPORT("Import JAutodoc Preferences", "Import preferences from the local file system.", "importpref_wiz.png", "From preference file:", "Import preferences from File", "Preference file does not exist or is a directory.", 4096),
        EXPORT("Export JAutodoc Preferences", "Export preferences to the local file system.", "exportpref_wiz.png", "To preference file:", "Export preferences to File", "Preference file not set or is not a normal file.", 8192);

        private final String title;
        private final String message;
        private final String imageFileName;
        private final String fileDescription;
        private final String fileDialogTitle;
        private final String invalidDestinationMessage;
        private final int fileDialogStyle;

        private Type(String title, String message, String imageFileName, String fileDescription, String fileDialogTitle, String invalidDestinationMessage, int fileDialogStyle) {
            this.title = title;
            this.message = message;
            this.imageFileName = imageFileName;
            this.fileDescription = fileDescription;
            this.fileDialogTitle = fileDialogTitle;
            this.fileDialogStyle = fileDialogStyle;
            this.invalidDestinationMessage = invalidDestinationMessage;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMessage() {
            return this.message;
        }

        public String getImageFileName() {
            return this.imageFileName;
        }

        public String getFileDescription() {
            return this.fileDescription;
        }

        public String getFileDialogTitle() {
            return this.fileDialogTitle;
        }

        public int getFileDialogStyle() {
            return this.fileDialogStyle;
        }

        public String getInvalidDestinationMessage() {
            return this.invalidDestinationMessage;
        }
    }
}

