/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.utils.NewFileOperation;
import net.sf.jautodoc.utils.UIHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class AddPackageJavadocOAD
implements IObjectActionDelegate {
    private IWorkbenchPage workbenchPage;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPage = targetPart.getSite().getPage();
    }

    public void run(IAction action) {
        IPackageFragment[] packages = this.getPackages();
        if (packages == null || packages.length == 0) {
            return;
        }
        String[] fileNames = this.getPackageDocFileNames(packages);
        IFile[] files = this.getPackageDocFiles(packages, fileNames);
        String[] contents = this.getInitialContents(packages, files);
        NewFileOperation op = new NewFileOperation(files, contents);
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)op);
            this.selectRevealAndOpen(files);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            JAutodocPlugin.getDefault().handleException(this.getShell(), e.getTargetException());
        }
        catch (PartInitException e) {
            JAutodocPlugin.getDefault().handleException(this.getShell(), (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private IPackageFragment[] getPackages() {
        IStructuredSelection selection = (IStructuredSelection)this.workbenchPage.getSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof IPackageFragment)) {
            return null;
        }
        HashSet<IPackageFragment> packages = new HashSet<IPackageFragment>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            packages.add((IPackageFragment)iter.next());
        }
        return packages.toArray(new IPackageFragment[packages.size()]);
    }

    private String[] getPackageDocFileNames(IPackageFragment[] packages) {
        String[] fileNames = new String[packages.length];
        int i = 0;
        while (i < packages.length) {
            IProject project = packages[i].getJavaProject().getProject();
            Configuration config = ConfigurationManager.getConfiguration(project);
            fileNames[i] = config.isUsePackageInfo() ? "package-info.java" : "package.html";
            ++i;
        }
        return fileNames;
    }

    private IFile[] getPackageDocFiles(IPackageFragment[] packages, String[] fileNames) {
        IFile[] files = new IFile[packages.length];
        int i = 0;
        while (i < packages.length) {
            IPath pkgDocPath = packages[i].getResource().getFullPath().append(fileNames[i]);
            files[i] = this.createFileHandle(pkgDocPath);
            ++i;
        }
        return files;
    }

    private String[] getInitialContents(IPackageFragment[] packages, IFile[] files) {
        String[] contents = new String[files.length];
        int i = 0;
        while (i < files.length) {
            contents[i] = this.getTemplateText(files[i].getProject(), packages[i]);
            ++i;
        }
        return contents;
    }

    private String getTemplateText(IProject project, IPackageFragment pkg) {
        String template;
        Configuration config = ConfigurationManager.getConfiguration(project);
        String string = template = config.isUsePackageInfo() ? config.getPackageInfoText() : config.getPackageDocText();
        if (template == null || template.trim().length() == 0) {
            return null;
        }
        String text = template;
        try {
            text = JAutodocPlugin.getContext().getTemplateManager().evaluateTemplate((IJavaElement)pkg, template, "Package Javadoc", config.getProperties());
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException((IJavaElement)pkg, (Throwable)e);
        }
        return text;
    }

    private void selectRevealAndOpen(IFile[] files) throws PartInitException {
        int i = 0;
        while (i < files.length) {
            UIHelper.selectAndReveal((IResource)files[i], this.workbenchPage.getWorkbenchWindow());
            UIHelper.openInEditor(files[i]);
            ++i;
        }
    }

    private Shell getShell() {
        return this.workbenchPage.getWorkbenchWindow().getShell();
    }

    private IFile createFileHandle(IPath filePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }
}

