/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.search.TaskSearchResultPage;
import net.sf.jautodoc.utils.SourceUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractOAD
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    protected IWorkbenchPage workbenchPage;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
        this.workbenchPage = targetPart.getSite().getPage();
    }

    public void run(IAction action) {
        IStructuredSelection selection = (IStructuredSelection)this.workbenchPage.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Map<ICompilationUnit, List<IMember>> cus = new HashMap<ICompilationUnit, List<IMember>>();
        if (selection.getFirstElement() instanceof ICompilationUnit) {
            this.getCompilationUnits(selection.toArray(), cus);
            cus = this.filterBySearchResult(cus);
        } else if (selection.getFirstElement() instanceof IMember) {
            IMember[] members = this.convert(selection.toArray(), new IMember[selection.size()]);
            this.getCompilationUnitsForMembers(members, cus);
        } else if (selection.getFirstElement() instanceof IPackageFragment) {
            IPackageFragment[] packages = this.convert(selection.toArray(), new IPackageFragment[selection.size()]);
            if (ConfigurationManager.getCurrentConfiguration().isIncludeSubPackages()) {
                HashSet<IPackageFragment> pkgFragments = new HashSet<IPackageFragment>();
                IPackageFragment[] iPackageFragmentArray = packages;
                int n = packages.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment pkgFragment = iPackageFragmentArray[n2];
                    if (!pkgFragments.contains(pkgFragment)) {
                        pkgFragments.add(pkgFragment);
                        this.getSubpackages(pkgFragment, pkgFragments);
                    }
                    ++n2;
                }
                packages = pkgFragments.toArray(new IPackageFragment[pkgFragments.size()]);
            }
            this.getCompilationUnitsForPackages(packages, cus);
            cus = this.filterBySearchResult(cus);
        } else if (selection.getFirstElement() instanceof IJavaProject) {
            Object[] projects = selection.toArray();
            this.getCompilationUnitsForProjects(projects, cus);
            cus = this.filterBySearchResult(cus);
        }
        if (cus.isEmpty()) {
            return;
        }
        ITask task = this.getTask(cus);
        try {
            new ProgressMonitorDialog(this.workbenchPage.getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)task);
            task.checkSuccess();
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(this.workbenchPage.getWorkbenchWindow().getShell(), task.getCompilationUnit(), e);
        }
    }

    private Map<ICompilationUnit, List<IMember>> filterBySearchResult(Map<ICompilationUnit, List<IMember>> cus) {
        if (!(this.targetPart instanceof ISearchResultViewPart) || !(((ISearchResultViewPart)this.targetPart).getActivePage() instanceof TaskSearchResultPage)) {
            return cus;
        }
        ISearchResultViewPart resultViewPart = (ISearchResultViewPart)this.targetPart;
        TaskSearchResultPage resultView = (TaskSearchResultPage)resultViewPart.getActivePage();
        IJavaElement[] elements = resultView.getFilteredJavaElements();
        HashMap<ICompilationUnit, List<IMember>> result = new HashMap<ICompilationUnit, List<IMember>>();
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member;
            ICompilationUnit cu;
            IJavaElement element = iJavaElementArray[n2];
            if (element instanceof ICompilationUnit) {
                if (cus.containsKey(element) && result.get(element) == null) {
                    result.put((ICompilationUnit)element, new ArrayList());
                }
            } else if (element instanceof IMember && cus.containsKey(cu = (member = (IMember)element).getCompilationUnit())) {
                ArrayList<IMember> members = (ArrayList<IMember>)result.get(cu);
                if (members == null) {
                    members = new ArrayList<IMember>();
                    result.put(cu, members);
                }
                members.add(member);
            }
            ++n2;
        }
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected abstract ITask getTask(Map<ICompilationUnit, List<IMember>> var1);

    private void getCompilationUnitsForMembers(IMember[] members, Map<ICompilationUnit, List<IMember>> compUnits) {
        int i = 0;
        while (i < members.length) {
            ICompilationUnit cu = members[i].getCompilationUnit();
            if (this.isValid(cu)) {
                List<IMember> ms = compUnits.get(cu);
                if (ms == null) {
                    ms = new ArrayList<IMember>();
                    compUnits.put(cu, ms);
                }
                ms.add(members[i]);
            }
            ++i;
        }
    }

    private void getCompilationUnitsForPackages(IPackageFragment[] packages, Map<ICompilationUnit, List<IMember>> compUnits) {
        int i = 0;
        while (i < packages.length) {
            block5: {
                ICompilationUnit[] cus = null;
                try {
                    cus = packages[i].getCompilationUnits();
                }
                catch (JavaModelException javaModelException) {
                    break block5;
                }
                int j = 0;
                while (j < cus.length) {
                    ICompilationUnit cu = cus[j];
                    if (this.isValid(cu) && !(cu instanceof ClassFileWorkingCopy)) {
                        compUnits.put(cu, null);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void getCompilationUnitsForProjects(Object[] projects, Map<ICompilationUnit, List<IMember>> compUnits) {
        ArrayList<IPackageFragment> packageList = new ArrayList<IPackageFragment>();
        int i = 0;
        while (i < projects.length) {
            block9: {
                IPackageFragmentRoot[] packageRoots = null;
                try {
                    packageRoots = ((IJavaProject)projects[i]).getPackageFragmentRoots();
                }
                catch (JavaModelException javaModelException) {
                    break block9;
                }
                int j = 0;
                while (j < packageRoots.length) {
                    block10: {
                        if (!packageRoots[j].isArchive()) {
                            IJavaElement[] children = null;
                            try {
                                children = packageRoots[j].getChildren();
                            }
                            catch (JavaModelException javaModelException) {
                                break block10;
                            }
                            int k = 0;
                            while (k < children.length) {
                                if (children[k] instanceof IPackageFragment) {
                                    packageList.add((IPackageFragment)children[k]);
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.getCompilationUnitsForPackages(packageList.toArray(new IPackageFragment[packageList.size()]), compUnits);
    }

    private <T> T[] convert(Object[] source, T[] target) {
        int i = 0;
        while (i < source.length) {
            target[i] = source[i];
            ++i;
        }
        return target;
    }

    private void getCompilationUnits(Object[] objects, Map<ICompilationUnit, List<IMember>> compUnits) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ICompilationUnit && this.isValid((ICompilationUnit)o)) {
                compUnits.put((ICompilationUnit)o, null);
            }
            ++n2;
        }
    }

    private void getSubpackages(IPackageFragment pkgFragment, Set<IPackageFragment> subpackages) {
        try {
            SourceUtils.getSubpackages(pkgFragment, subpackages);
        }
        catch (JavaModelException e) {
            JAutodocPlugin.getDefault().handleException((IJavaElement)pkgFragment, (Throwable)e);
        }
    }

    private boolean isValid(ICompilationUnit cu) {
        return cu != null && cu.findPrimaryType() != null;
    }

    protected static interface ITask
    extends IRunnableWithProgress {
        public ICompilationUnit getCompilationUnit();

        public void checkSuccess() throws Exception;
    }
}

