/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.yakindu.sct.ui.editor.DiagramActivator;
import org.yakindu.sct.ui.editor.StatechartImages;
import org.yakindu.sct.ui.editor.factories.FactoryUtils;
import org.yakindu.sct.ui.editor.wizards.CreationWizardPage;
import org.yakindu.sct.ui.perspectives.PerspectiveUtil;

public class CreationWizard
extends Wizard
implements INewWizard {
    public static final String ID = "org.yakindu.sct.ui.editor.StatechartDiagramWizard";
    protected IStructuredSelection selection = new StructuredSelection();
    protected CreationWizardPage modelFilePage;
    protected Resource diagram;
    private boolean openOnCreate = true;
    protected PreferencesHint preferencesHint = DiagramActivator.DIAGRAM_PREFERENCES_HINT;
    private IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("New YAKINDU Statechart");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.modelFilePage = new CreationWizardPage("DiagramModelFile", this.getSelection(), "sct");
        this.modelFilePage.setTitle("YAKINDU SCT Diagram");
        this.modelFilePage.setDescription("Create a new YAKINDU SCT Diagram File");
        this.modelFilePage.setImageDescriptor(StatechartImages.LOGO.imageDescriptor());
        this.addPage((IWizardPage)this.modelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                CreationWizard.this.diagram = CreationWizard.this.createDiagram(CreationWizard.this.modelFilePage.getURI(), CreationWizard.this.modelFilePage.getURI(), monitor);
                if (CreationWizard.this.isOpenOnCreate() && CreationWizard.this.diagram != null) {
                    try {
                        CreationWizard.this.openDiagram(CreationWizard.this.diagram);
                        PerspectiveUtil.switchToModelingPerspective((IWorkbenchWindow)CreationWizard.this.workbench.getActiveWorkbenchWindow());
                    }
                    catch (PartInitException e) {
                        DiagramActivator.getDefault().getLog().log((IStatus)new Status(2, "org.yakindu.sct.ui.editor", "Editor can't be opened", (Throwable)e));
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (Exception exception) {
            return false;
        }
        return this.diagram != null;
    }

    protected boolean openDiagram(Resource diagram) throws PartInitException {
        String path = diagram.getURI().toPlatformString(true);
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (workspaceResource instanceof IFile) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor((IEditorInput)new FileEditorInput((IFile)workspaceResource), this.getEditorID()) != null;
        }
        return false;
    }

    protected String getEditorID() {
        return "org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor";
    }

    protected Resource createDiagram(URI diagramURI, URI modelURI, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        progressMonitor.beginTask("Creating diagram file ...", 3);
        final Resource resource = editingDomain.getResourceSet().createResource(modelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Creating diagram file ...", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                FactoryUtils.createStatechartModel(resource, CreationWizard.this.preferencesHint);
                try {
                    resource.save(CreationWizard.this.getSaveOptions());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            command.execute(progressMonitor, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.setCharset(WorkspaceSynchronizer.getFile((Resource)resource));
        editingDomain.dispose();
        return resource;
    }

    protected Map<String, String> getSaveOptions() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    protected void setCharset(IFile file) {
        if (file == null) {
            return;
        }
        try {
            file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean isOpenOnCreate() {
        return this.openOnCreate;
    }

    public void setOpenOnCreate(boolean openOnCreate) {
        this.openOnCreate = openOnCreate;
    }

    protected void setPreferenceHint(PreferencesHint hint) {
        this.preferencesHint = hint;
    }
}

