/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.providers;

import de.itemis.gmf.runtime.commons.decorators.AbstractMarkerBasedDecorationProvider;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.yakindu.sct.model.sgraph.FinalState;
import org.yakindu.sct.model.sgraph.Pseudostate;
import org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor;
import org.yakindu.sct.ui.editor.validation.IMarkerType;

public class StatechartValidationDecorationProvider
extends AbstractMarkerBasedDecorationProvider
implements IDecoratorProvider,
IMarkerType {
    private static final String KEY = "org.yakindu.sct.ui.editor.validation";

    protected boolean shouldInstall(IEditorPart part) {
        return part instanceof StatechartDiagramEditor;
    }

    protected String getDecoratorKey() {
        return KEY;
    }

    protected AbstractMarkerBasedDecorationProvider.StatusDecorator createStatusDecorator(IDecoratorTarget decoratorTarget) {
        return new ValidationDecorator(decoratorTarget);
    }

    public static class ValidationDecorator
    extends AbstractMarkerBasedDecorationProvider.StatusDecorator {
        public ValidationDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
        }

        protected void createDecorators(View view, List<IMarker> markers) {
            String elementId = ViewUtil.getIdStr((View)view);
            if (elementId == null) {
                return;
            }
            int severity = 0;
            IMarker foundMarker = null;
            Label toolTip = null;
            int i = 0;
            while (i < markers.size()) {
                IMarker marker = markers.get(i);
                String attribute = marker.getAttribute("elementId", "");
                if (attribute.equals(elementId)) {
                    int nextSeverity = marker.getAttribute("severity", 0);
                    Image nextImage = this.getImage(nextSeverity);
                    if (foundMarker == null) {
                        foundMarker = marker;
                        toolTip = new Label(marker.getAttribute("message", ""), nextImage);
                    } else {
                        if (toolTip.getChildren().isEmpty()) {
                            Label comositeLabel = new Label();
                            FlowLayout fl = new FlowLayout(false);
                            fl.setMinorSpacing(0);
                            comositeLabel.setLayoutManager((LayoutManager)fl);
                            comositeLabel.add((IFigure)toolTip);
                            toolTip = comositeLabel;
                        }
                        toolTip.add((IFigure)new Label(marker.getAttribute("message", ""), nextImage));
                    }
                    severity = nextSeverity > severity ? nextSeverity : severity;
                }
                ++i;
            }
            if (foundMarker == null) {
                return;
            }
            if (view instanceof Edge) {
                this.setDecoration(this.getDecoratorTarget().addConnectionDecoration(this.getImage(severity), 50, true));
                this.getDecoration().setToolTip(toolTip);
            } else {
                int margin = view.getElement() instanceof Pseudostate || view.getElement() instanceof FinalState ? 0 : -1;
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration(this.getImage(severity), IDecoratorTarget.Direction.NORTH_EAST, margin, true));
                this.getDecoration().setToolTip(toolTip);
            }
        }

        protected String getMarkerType() {
            return "org.yakindu.sct.ui.editor.diagnostic";
        }

        private Image getImage(int severity) {
            String imageName = "IMG_OBJS_ERROR_TSK";
            switch (severity) {
                case 2: {
                    imageName = "IMG_OBJS_ERROR_TSK";
                    break;
                }
                case 1: {
                    imageName = "IMG_OBJS_WARN_TSK";
                    break;
                }
                default: {
                    imageName = "IMG_OBJS_INFO_TSK";
                }
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
        }
    }
}

