/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.propertysheets;

import com.google.inject.Injector;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.yakindu.base.base.BasePackage;
import org.yakindu.sct.model.sgraph.SGraphPackage;
import org.yakindu.sct.ui.editor.extensions.ExpressionLanguageProviderExtensions;
import org.yakindu.sct.ui.editor.propertysheets.AbstractTwoColumnEditorPropertySection;
import org.yakindu.sct.ui.editor.propertysheets.OrderElementControl;

public class StatechartPropertySection
extends AbstractTwoColumnEditorPropertySection
implements OrderElementControl.ISourceObjectCallback {
    private Control textControl;
    private Text txtName;
    private OrderElementControl orderElementControl;
    private Text documentation;

    @Override
    protected Layout createLeftColumnLayout() {
        return new GridLayout(2, false);
    }

    @Override
    protected void createLeftColumnControls(Composite leftColumn) {
        this.createNameControl(leftColumn);
        this.createSpecificationControl(leftColumn);
    }

    @Override
    protected void createRightColumnControls(Composite rightColumn) {
        this.createDocumentationControl(rightColumn);
        this.createRegionsControl(rightColumn);
    }

    protected void createNameControl(Composite parent) {
        Label lblName = this.getToolkit().createLabel(parent, "Statechart Name: ");
        this.txtName = this.getToolkit().createText(parent, "");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)lblName);
        new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtName);
    }

    protected void createRegionsControl(Composite rightColumn) {
        Label label = this.getToolkit().createLabel(rightColumn, "Region Priority:");
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.orderElementControl = new OrderElementControl(rightColumn, (EStructuralFeature)SGraphPackage.Literals.COMPOSITE_ELEMENT__REGIONS, this);
        GridDataFactory.fillDefaults().span(2, 0).grab(true, false).applyTo((Control)this.orderElementControl);
    }

    protected void createDocumentationControl(Composite rightColumn) {
        Label lblDocumentation = this.getToolkit().createLabel(rightColumn, "Documentation: ");
        this.documentation = this.getToolkit().createText(rightColumn, "", 2);
        GridDataFactory.fillDefaults().applyTo((Control)lblDocumentation);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.documentation);
    }

    protected void createSpecificationControl(Composite parent) {
        Injector injector = this.getInjector(ExpressionLanguageProviderExtensions.SemanticTarget.StatechartSpecification);
        if (injector != null) {
            this.textControl = new StyledText(parent, 2626);
            ((StyledText)this.textControl).setAlwaysShowScrollBars(false);
            this.enableXtext(this.textControl, injector);
            this.createHelpWidget(parent, this.textControl, "org.yakindu.sct.ui.editor.sc_properties_statechart_expression");
        } else {
            this.textControl = this.getToolkit().createText(parent, "", 2);
        }
        GridDataFactory.fillDefaults().grab(true, true).hint(parent.getSize()).applyTo(this.textControl);
    }

    @Override
    public void bindModel(EMFDataBindingContext context) {
        this.bindNameControl(context);
        this.bindSpecificationControl(context);
        this.bindDocumentationControl(context);
        this.orderElementControl.refreshInput();
    }

    private void bindDocumentationControl(EMFDataBindingContext context) {
        IEMFEditValueProperty property = EMFEditProperties.value((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.eObject), (EStructuralFeature)BasePackage.Literals.DOCUMENTED_ELEMENT__DOCUMENTATION);
        ISWTObservableValue observe = WidgetProperties.text((int[])new int[]{16, 14}).observe((Widget)this.documentation);
        context.bindValue((IObservableValue)observe, property.observe((Object)this.eObject));
    }

    protected void bindSpecificationControl(EMFDataBindingContext context) {
        IEMFEditValueProperty modelProperty = EMFEditProperties.value((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.eObject), (EStructuralFeature)SGraphPackage.Literals.SPECIFICATION_ELEMENT__SPECIFICATION);
        ISWTObservableValue uiProperty = WidgetProperties.text((int)16).observe((Widget)this.textControl);
        context.bindValue((IObservableValue)uiProperty, modelProperty.observe((Object)this.eObject), null, new UpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (StatechartPropertySection.this.getCompletionProposalAdapter() != null && !StatechartPropertySection.this.getCompletionProposalAdapter().isProposalPopupOpen()) {
                    return super.doSet(observableValue, value);
                }
                return Status.OK_STATUS;
            }
        });
    }

    protected void bindNameControl(EMFDataBindingContext context) {
        IEMFEditValueProperty property = EMFEditProperties.value((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.eObject), (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        ISWTObservableValue observe = WidgetProperties.text((int[])new int[]{16, 14}).observe((Widget)this.txtName);
        context.bindValue((IObservableValue)observe, property.observe((Object)this.eObject));
    }

    @Override
    public EObject getEObject() {
        return super.getEObject();
    }

    @Override
    public void dispose() {
        if (this.orderElementControl != null) {
            this.orderElementControl.dispose();
        }
        super.dispose();
    }
}

