/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.propertysheets;

import de.itemis.gmf.runtime.commons.util.EditPartUtils;
import de.itemis.xtext.utils.jface.viewers.util.ActiveEditorTracker;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.emf.commands.core.commands.RepositionEObjectCommand;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.yakindu.sct.model.sgraph.provider.SGraphItemProviderAdapterFactory;

public class OrderElementControl
extends Composite {
    private FormToolkit toolkit;
    private Button btnUp;
    private Button btnDown;
    private TableViewer viewer;
    private ButtonSelectionListener upButtonListener;
    private ButtonSelectionListener downButtonListener;
    private EditPartSelectionListener editPartSelectionListener;
    private EnableButtonListener enableButtonListener;
    private EStructuralFeature toManyFeature;
    private ISourceObjectCallback callback;

    public OrderElementControl(Composite parent, EStructuralFeature toManyFeature, ISourceObjectCallback callback) {
        super(parent, 0);
        this.toManyFeature = toManyFeature;
        this.callback = callback;
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.upButtonListener = new ButtonSelectionListener(-1);
        this.downButtonListener = new ButtonSelectionListener(1);
        this.editPartSelectionListener = new EditPartSelectionListener();
        this.enableButtonListener = new EnableButtonListener();
        this.setBackground(ColorConstants.white);
        this.init();
    }

    private void init() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TableViewer((Composite)this, 2052);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new SGraphItemProviderAdapterFactory()));
        Composite buttonComposite = this.getToolkit().createComposite((Composite)this);
        buttonComposite.setLayout((Layout)new FillLayout(512));
        this.btnUp = this.getToolkit().createButton(buttonComposite, "up", 8);
        this.btnDown = this.getToolkit().createButton(buttonComposite, "down", 8);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.enableButtonListener);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.editPartSelectionListener);
        this.btnUp.addSelectionListener((SelectionListener)this.upButtonListener);
        this.btnDown.addSelectionListener((SelectionListener)this.downButtonListener);
        GridDataFactory.fillDefaults().applyTo(this.viewer.getControl());
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.viewer.getControl());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this);
    }

    public TableViewer getListViewer() {
        return this.viewer;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    protected EObject getSelectedObject() {
        return (EObject)((StructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    private EList<EObject> getListInput() {
        return (EList)this.callback.getEObject().eGet(this.toManyFeature);
    }

    public void refreshInput() {
        ISelection selection = this.viewer.getSelection();
        this.viewer.setInput(this.getListInput());
        this.viewer.setSelection(selection);
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.editPartSelectionListener);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.enableButtonListener);
        if (!this.btnUp.isDisposed()) {
            this.btnUp.removeSelectionListener((SelectionListener)this.upButtonListener);
            this.btnUp.dispose();
        }
        if (!this.btnDown.isDisposed()) {
            this.btnDown.removeSelectionListener((SelectionListener)this.downButtonListener);
            this.btnDown.dispose();
        }
        super.dispose();
    }

    private final class ButtonSelectionListener
    extends SelectionAdapter {
        private final int displacement;

        public ButtonSelectionListener(int displacement) {
            this.displacement = displacement;
        }

        public void widgetSelected(SelectionEvent e) {
            RepositionEObjectCommand command = new RepositionEObjectCommand(TransactionUtil.getEditingDomain((EObject)OrderElementControl.this.callback.getEObject()), "Reorder Elements", OrderElementControl.this.getListInput(), OrderElementControl.this.getSelectedObject(), this.displacement);
            try {
                OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e1) {
                e1.printStackTrace();
            }
            OrderElementControl.this.refreshInput();
        }
    }

    private final class EditPartSelectionListener
    implements ISelectionChangedListener {
        private EditPartSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IGraphicalEditPart editPart;
            IEditorPart lastActiveEditor = ActiveEditorTracker.getLastActiveEditor();
            EObject selectedObject = OrderElementControl.this.getSelectedObject();
            if (lastActiveEditor instanceof DiagramDocumentEditor && selectedObject != null && (editPart = EditPartUtils.findEditPartForSemanticElement((EditPart)((DiagramDocumentEditor)lastActiveEditor).getDiagramGraphicalViewer().getRootEditPart(), (EObject)selectedObject)) != null) {
                ((DiagramDocumentEditor)lastActiveEditor).getDiagramGraphicalViewer().select((EditPart)editPart);
                ((DiagramDocumentEditor)lastActiveEditor).getDiagramGraphicalViewer().reveal((EditPart)editPart);
            }
        }
    }

    private final class EnableButtonListener
    implements ISelectionChangedListener {
        private EnableButtonListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            EList listInput = OrderElementControl.this.getListInput();
            int indexOf = listInput.indexOf((Object)OrderElementControl.this.getSelectedObject());
            if (indexOf == -1 || listInput.size() <= 1) {
                OrderElementControl.this.btnUp.setEnabled(false);
                OrderElementControl.this.btnDown.setEnabled(false);
            } else if (indexOf == 0) {
                OrderElementControl.this.btnUp.setEnabled(false);
                OrderElementControl.this.btnDown.setEnabled(true);
            } else if (indexOf == listInput.size() - 1) {
                OrderElementControl.this.btnUp.setEnabled(true);
                OrderElementControl.this.btnDown.setEnabled(false);
            } else {
                OrderElementControl.this.btnUp.setEnabled(true);
                OrderElementControl.this.btnDown.setEnabled(true);
            }
        }
    }

    public static interface ISourceObjectCallback {
        public EObject getEObject();
    }
}

