/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.propertysheets;

import com.google.inject.Injector;
import de.itemis.xtext.utils.jface.fieldassist.CompletionProposalAdapter;
import de.itemis.xtext.utils.jface.viewers.ContextElementAdapter;
import de.itemis.xtext.utils.jface.viewers.FilteringMenuManager;
import de.itemis.xtext.utils.jface.viewers.StyledTextXtextAdapter;
import de.itemis.xtext.utils.jface.viewers.util.ActiveEditorTracker;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractModelerPropertySection;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.yakindu.sct.ui.editor.extensions.ExpressionLanguageProviderExtensions;
import org.yakindu.sct.ui.editor.extensions.IExpressionLanguageProvider;
import org.yakindu.sct.ui.editor.propertysheets.ValidatingEMFDatabindingContext;

public abstract class AbstractEditorPropertySection
extends AbstractModelerPropertySection
implements ContextElementAdapter.IContextElementProvider {
    private FormToolkit toolkit;
    private EMFDataBindingContext bindingContext;
    private Form form;
    private CompletionProposalAdapter completionProposalAdapter;
    public static final String CONTEXTMENUID = "de.itemis.xtext.utils.jface.viewers.StyledTextXtextAdapterContextMenu";

    public abstract void createControls(Composite var1);

    public abstract void bindModel(EMFDataBindingContext var1);

    public void refresh() {
        super.refresh();
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        this.bindingContext = new ValidatingEMFDatabindingContext(this, this.form.getShell());
        this.bindModel(this.bindingContext);
    }

    public void dispose() {
        super.dispose();
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    public final void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.setBorderStyle(2048);
        super.createControls(parent, aTabbedPropertySheetPage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.form = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.form);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.form);
        this.form.getBody().setLayout(this.createBodyLayout());
        this.createControls(this.form.getBody());
    }

    protected Layout createBodyLayout() {
        return new GridLayout(1, false);
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    protected void enableXtext(Control styledText, Injector injector) {
        StyledTextXtextAdapter xtextAdapter = new StyledTextXtextAdapter(injector);
        xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().add((Object)new ContextElementAdapter((ContextElementAdapter.IContextElementProvider)this));
        xtextAdapter.adapt((StyledText)styledText);
        this.initContextMenu(styledText);
        this.completionProposalAdapter = new CompletionProposalAdapter(styledText, xtextAdapter.getContentAssistant(), KeyStroke.getInstance((int)262144, (int)32), null);
    }

    protected void initContextMenu(Control control) {
        FilteringMenuManager menuManager = new FilteringMenuManager();
        Menu contextMenu = menuManager.createContextMenu(control);
        control.setMenu(contextMenu);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPartSite site = window.getActivePage().getActiveEditor().getSite();
        site.registerContextMenu(CONTEXTMENUID, (MenuManager)menuManager, site.getSelectionProvider());
    }

    public CompletionProposalAdapter getCompletionProposalAdapter() {
        return this.completionProposalAdapter;
    }

    protected Injector getInjector(ExpressionLanguageProviderExtensions.SemanticTarget semanticTarget) {
        IEditorPart editor = ActiveEditorTracker.getLastActiveEditor();
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            String extension = ((IFileEditorInput)editorInput).getFile().getFileExtension();
            IExpressionLanguageProvider registeredProvider = ExpressionLanguageProviderExtensions.getRegisteredProvider(semanticTarget, extension);
            return registeredProvider.getInjector();
        }
        return null;
    }

    public EObject getContextObject() {
        return this.getEObject();
    }

    protected void createHelpWidget(Composite parent, final Control control, String helpId) {
        ImageHyperlink helpWidget = this.toolkit.createImageHyperlink(parent, 0x1000000);
        Image defaultImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        helpWidget.setImage(defaultImage);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)helpWidget);
        helpWidget.setToolTipText(JFaceResources.getString((String)"help"));
        helpWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                control.setFocus();
                PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)helpWidget);
        helpWidget.setEnabled(true);
        this.setHelpContext(control, helpId);
    }

    protected void setHelpContext(Control control, String helpId) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp(control, helpId);
    }
}

