/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.factories;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.RGB;
import org.yakindu.sct.model.sgraph.Entry;
import org.yakindu.sct.model.sgraph.EntryKind;
import org.yakindu.sct.model.sgraph.Region;
import org.yakindu.sct.model.sgraph.SGraphFactory;
import org.yakindu.sct.model.sgraph.State;
import org.yakindu.sct.model.sgraph.Statechart;
import org.yakindu.sct.model.sgraph.Transition;
import org.yakindu.sct.model.sgraph.Vertex;
import org.yakindu.sct.ui.editor.DiagramActivator;

public final class FactoryUtils {
    private static final int INITIAL_REGION_WIDTH = 400;
    private static final int INITIAL_REGION_HEIGHT = 400;
    private static final String INITIAL_REGION_NAME = "main region";
    private static final int INITIAL_TEXT_COMPARTMENT_X = 10;
    private static final int INITIAL_TEXT_COMPARTMENT_Y = 10;
    private static final int INITIAL_TEXT_COMPARTMENT_HEIGHT = 400;
    private static final int INITIAL_TEXT_COMPARTMENT_WIDTH = 200;
    private static final int SPACING = 10;

    private FactoryUtils() {
    }

    public static Node createLabel(View owner, String hint) {
        DecorationNode nameLabel = NotationFactory.eINSTANCE.createDecorationNode();
        nameLabel.setType(hint);
        ShapeStyle style = NotationFactory.eINSTANCE.createShapeStyle();
        style.setFontColor(FigureUtilities.RGBToInteger((RGB)ColorConstants.black.getRGB()).intValue());
        nameLabel.getStyles().add((Object)style);
        ViewUtil.insertChildView((View)owner, (View)nameLabel, (int)-1, (boolean)true);
        nameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        return nameLabel;
    }

    public static void createStatechartModel(Resource resource) {
        FactoryUtils.createStatechartModel(resource, DiagramActivator.DIAGRAM_PREFERENCES_HINT);
    }

    public static void createStatechartModel(Resource resource, PreferencesHint preferencesHint) {
        Statechart statechart = SGraphFactory.eINSTANCE.createStatechart();
        String lastSegment = resource.getURI().lastSegment();
        String statechartName = lastSegment.substring(0, lastSegment.indexOf(46));
        statechart.setName(statechartName);
        Diagram diagram = ViewService.createDiagram((EObject)statechart, (String)"org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor", (PreferencesHint)preferencesHint);
        diagram.setElement((EObject)statechart);
        resource.getContents().add((Object)statechart);
        resource.getContents().add((Object)diagram);
        Region region = SGraphFactory.eINSTANCE.createRegion();
        region.setName(INITIAL_REGION_NAME);
        statechart.getRegions().add((Object)region);
        Node regionView = ViewService.createNode((View)diagram, (EObject)region, (String)"Region", (PreferencesHint)preferencesHint);
        FactoryUtils.setRegionViewLayoutConstraint(regionView);
        Entry initialState = SGraphFactory.eINSTANCE.createEntry();
        initialState.setKind(EntryKind.INITIAL);
        region.getVertices().add((Object)initialState);
        Node initialStateView = ViewService.createNode((View)FactoryUtils.getRegionCompartmentView((View)regionView), (EObject)initialState, (String)"Entry", (PreferencesHint)preferencesHint);
        FactoryUtils.setInitialStateViewLayoutConstraint(initialStateView);
        State state = SGraphFactory.eINSTANCE.createState();
        region.getVertices().add((Object)state);
        Node stateNode = ViewService.createNode((View)FactoryUtils.getRegionCompartmentView((View)regionView), (EObject)state, (String)"State", (PreferencesHint)preferencesHint);
        FactoryUtils.setStateViewLayoutConstraint(stateNode);
        Transition transition = SGraphFactory.eINSTANCE.createTransition();
        transition.setSource((Vertex)initialState);
        transition.setTarget((Vertex)state);
        initialState.getOutgoingTransitions().add((Object)transition);
        ViewService.createEdge((View)initialStateView, (View)stateNode, (EObject)transition, (String)"Transition", (PreferencesHint)preferencesHint);
        Node textCompartment = ViewService.createNode((View)diagram, (EObject)statechart, (String)"StatechartText", (PreferencesHint)preferencesHint);
        FactoryUtils.setTextCompartmentLayoutConstraint(textCompartment);
    }

    private static void setStateViewLayoutConstraint(Node stateNode) {
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        bounds.setX(40);
        bounds.setY(80);
        stateNode.setLayoutConstraint((LayoutConstraint)bounds);
    }

    private static void setInitialStateViewLayoutConstraint(Node initialStateView) {
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        bounds.setX(70);
        bounds.setY(20);
        initialStateView.setLayoutConstraint((LayoutConstraint)bounds);
    }

    private static View getRegionCompartmentView(View regionView) {
        return (View)regionView.getChildren().get(1);
    }

    private static void setTextCompartmentLayoutConstraint(Node textCompartment) {
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        bounds.setX(10);
        bounds.setY(10);
        bounds.setHeight(400);
        bounds.setWidth(200);
        textCompartment.setLayoutConstraint((LayoutConstraint)bounds);
    }

    private static void setRegionViewLayoutConstraint(Node regionView) {
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        bounds.setX(220);
        bounds.setY(10);
        bounds.setHeight(400);
        bounds.setWidth(400);
        regionView.setLayoutConstraint((LayoutConstraint)bounds);
    }
}

