/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.extensions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.yakindu.sct.ui.editor.extensions.IExpressionLanguageProvider;

public class ExpressionLanguageProviderExtensions {
    private static final String EXPRESSIONS_EXTENSION = "org.yakindu.sct.ui.editor.expressions";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_RESOURCE_EXTENSION = "resourceExtension";
    private static final String ATTR_SEMANTIC_TARGET = "semanticTarget";
    private static final Map<String, IExpressionLanguageProvider> providerMap = new HashMap<String, IExpressionLanguageProvider>();

    protected ExpressionLanguageProviderExtensions() {
    }

    public static IExpressionLanguageProvider getLanguageProvider(String target, String resourceExtension) {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPRESSIONS_EXTENSION);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                String semanticTarget = configurationElement.getAttribute(ATTR_SEMANTIC_TARGET);
                String registeredExtension = configurationElement.getAttribute(ATTR_RESOURCE_EXTENSION);
                if (target.equals(semanticTarget) && resourceExtension.equals(registeredExtension)) {
                    String key = String.valueOf(target) + configurationElement.getNamespaceIdentifier();
                    if (providerMap.get(key) != null) {
                        return providerMap.get(key);
                    }
                    IExpressionLanguageProvider provider = (IExpressionLanguageProvider)configurationElement.createExecutableExtension(ATTR_CLASS);
                    providerMap.put(key, provider);
                    return provider;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return new IExpressionLanguageProvider.NullLanguageProvider();
    }

    @Deprecated
    public static IExpressionLanguageProvider getRegisteredProvider(SemanticTarget target, String resourceExtension) {
        return ExpressionLanguageProviderExtensions.getLanguageProvider(target.name(), resourceExtension);
    }

    @Deprecated
    public static enum SemanticTarget {
        StatechartSpecification,
        StateSpecification,
        TransitionSpecification;

    }
}

