/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.editor.figures;

import de.itemis.xtext.utils.gmf.figures.HighlightingWrappingLabel;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Color;
import org.yakindu.sct.ui.editor.editor.figures.utils.GraphicsUtil;
import org.yakindu.sct.ui.editor.editor.figures.utils.GridDataFactory;

public class StateFigure
extends RoundedRectangle {
    public static final int BLUR_SHADOW_WIDTH = 5;
    private WrappingLabel nameFigure;
    private Figure textCompartmentPane;
    private Figure figureCompartmentPane;

    public StateFigure(IMapMode mapMode) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.setLayoutManager((LayoutManager)layout);
        this.setCornerDimensions(new Dimension(mapMode.DPtoLP(15), mapMode.DPtoLP(15)));
        this.setOutline(true);
        this.createContents();
    }

    protected void createContents() {
        this.nameFigure = new HighlightingWrappingLabel();
        this.nameFigure.setAlignment(2);
        this.add((IFigure)this.nameFigure, GridDataFactory.fillDefaults().grab(true, false).getData());
        this.textCompartmentPane = new Figure();
        this.textCompartmentPane.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)this.textCompartmentPane, GridDataFactory.fillDefaults().grab(true, true).getData());
        this.figureCompartmentPane = new Figure();
        this.figureCompartmentPane.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)this.figureCompartmentPane, GridDataFactory.fillDefaults().grab(true, true).getData());
    }

    public WrappingLabel getNameFigure() {
        return this.nameFigure;
    }

    public Figure getTextCompartmentPane() {
        return this.textCompartmentPane;
    }

    public Figure getFigureCompartmentPane() {
        return this.figureCompartmentPane;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension result = super.getPreferredSize(wHint, hHint);
        return new Dimension(result.width + 5, result.height + 5);
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(new Rectangle(rect.x, rect.y, rect.width - 5, rect.height - 5));
    }

    public void paintFigure(Graphics graphics) {
        this.drawBlurredShadow(graphics);
        super.paintFigure(graphics);
    }

    protected void fillShape(Graphics graphics) {
        Color c = GraphicsUtil.mixColor(this.getBackgroundColor(), ColorConstants.white, 224);
        GraphicsUtil.fillVerticalGradientRoundedRectangle(graphics, this.getBounds(), this.getCornerDimensions(), this.getBackgroundColor(), c);
        c.dispose();
    }

    private void drawBlurredShadow(Graphics graphics) {
        graphics.pushState();
        int size = MapModeUtil.getMapMode((IFigure)this).DPtoLP(5);
        int step = MapModeUtil.getMapMode((IFigure)this).DPtoLP(-1);
        graphics.setForegroundColor(ColorConstants.gray);
        graphics.setLineWidth(MapModeUtil.getMapMode((IFigure)this).DPtoLP(2));
        graphics.translate(size, size);
        graphics.setClip(graphics.getClip(new Rectangle(this.getBounds())).expand(size, size));
        graphics.setAlpha(20);
        this.outlineShape(graphics);
        graphics.translate(step, step);
        graphics.setAlpha(30);
        this.outlineShape(graphics);
        graphics.translate(step, step);
        graphics.setAlpha(60);
        this.outlineShape(graphics);
        graphics.translate(step, step);
        graphics.setAlpha(100);
        this.outlineShape(graphics);
        graphics.translate(step, step);
        graphics.setAlpha(150);
        this.outlineShape(graphics);
        graphics.popState();
    }
}

