/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.edithelper;

import com.google.common.collect.Lists;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.naming.QualifiedName;
import org.yakindu.sct.model.sgraph.Region;
import org.yakindu.sct.model.sgraph.SGraphFactory;
import org.yakindu.sct.model.sgraph.SGraphPackage;
import org.yakindu.sct.ui.editor.commands.CreateRegionCommand;
import org.yakindu.sct.ui.editor.dialogs.SelectSubmachineDialog;
import org.yakindu.sct.ui.editor.edithelper.VertexEditHelper;
import org.yakindu.sct.ui.editor.editor.StatechartElementTypes;

public class StateEditHelper
extends VertexEditHelper {
    protected ICommand getConfigureCommand(ConfigureRequest req) {
        if (StatechartElementTypes.COMPOSITE_STATE.equals(req.getTypeToConfigure())) {
            return this.createCompositeStateCommand(req);
        }
        if (StatechartElementTypes.ORTHOGONAL_STATE.equals(req.getTypeToConfigure())) {
            return this.createOrthogonalState(req);
        }
        if (StatechartElementTypes.SUBMACHINE_STATE.equals(req.getTypeToConfigure())) {
            return this.createSubmachineStateCommand(req);
        }
        return null;
    }

    protected ICommand getCreateCommand(CreateElementRequest req) {
        if (req.getElementType() == StatechartElementTypes.REGION) {
            return new CreateRegionCommand(req);
        }
        return super.getCreateCommand(req);
    }

    private ICommand createSubmachineStateCommand(ConfigureRequest req) {
        QualifiedName selectedSubmachine;
        SelectSubmachineDialog dialog = new SelectSubmachineDialog(new Shell(), req.getElementToConfigure().eResource());
        dialog.setElements(new Object[]{req.getElementToConfigure()});
        if (dialog.open() == 0 && (selectedSubmachine = dialog.getSelectedSubmachine()) != null) {
            return new SetValueCommand(new SetRequest(req.getElementToConfigure(), (EStructuralFeature)SGraphPackage.Literals.STATE__SUBSTATECHART_ID, (Object)selectedSubmachine.toString()));
        }
        return null;
    }

    private ICommand createOrthogonalState(ConfigureRequest req) {
        Region region = SGraphFactory.eINSTANCE.createRegion();
        region.setName("r1");
        Region region2 = SGraphFactory.eINSTANCE.createRegion();
        region2.setName("r2");
        return new SetValueCommand(new SetRequest(req.getElementToConfigure(), (EStructuralFeature)SGraphPackage.Literals.COMPOSITE_ELEMENT__REGIONS, (Object)Lists.newArrayList((Object[])new Region[]{region, region2})));
    }

    private ICommand createCompositeStateCommand(ConfigureRequest req) {
        Region region = SGraphFactory.eINSTANCE.createRegion();
        region.setName("r1");
        return new SetValueCommand(new SetRequest(req.getElementToConfigure(), (EStructuralFeature)SGraphPackage.Literals.COMPOSITE_ELEMENT__REGIONS, (Object)region));
    }
}

