/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading.preferences;

import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.AbstractGroup;
import org.eclipse.papyrus.infra.services.resourceloading.impl.ProxyManager;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class LoadinStrategyGroup
extends AbstractGroup {
    private static final String LABEL_LOADING_STRATEGY = "Loading strategy :";
    private static final String SELECT_LOADING_STRATEGY = "Select the loading strategy when model is opened";
    private RadioGroupFieldEditor fStrategyRadio;

    public LoadinStrategyGroup(Composite parent, String title, DialogPage dialogPage) {
        super(parent, title, dialogPage);
        this.createContent(parent);
    }

    public void createContent(Composite parent) {
        Group group = new Group(parent, 2);
        group.setLayout((Layout)new GridLayout());
        group.setText(SELECT_LOADING_STRATEGY);
        this.fStrategyRadio = LoadinStrategyGroup.createStrategyRadio(group);
        this.addFieldEditor((FieldEditor)this.fStrategyRadio);
    }

    private static RadioGroupFieldEditor createStrategyRadio(Group group) {
        String[][] values = LoadinStrategyGroup.getValuesFromExtensionPoint();
        RadioGroupFieldEditor radio = new RadioGroupFieldEditor("org.eclipse.papyrus.infra.services.resourceloading.preferences.loadingStrategy", LABEL_LOADING_STRATEGY, 1, values, (Composite)group);
        return radio;
    }

    private static String[][] getValuesFromExtensionPoint() {
        Map allStrategies = ProxyManager.getAllStrategies();
        String[][] result = new String[allStrategies.size()][2];
        int i = 0;
        for (Integer val : allStrategies.keySet()) {
            result[i][0] = (String)allStrategies.get(val);
            result[i][1] = String.valueOf(val);
            ++i;
        }
        return result;
    }
}

