/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.databinding.StereotypeApplicationObservableList;
import org.eclipse.papyrus.uml.tools.databinding.ProfileApplicationObservableList;
import org.eclipse.papyrus.uml.tools.providers.ApplicableStereotypeContentProvider;
import org.eclipse.papyrus.uml.tools.providers.ProfileLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.papyrus.views.properties.modelelement.EMFModelElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class StereotypeApplicationModelElement
extends EMFModelElement {
    private Element umlSource;
    private EditingDomain domain;
    private EditPart sourceElement;
    public static final String STEREOTYPE_APPLICATION = "stereotypeApplication";

    public StereotypeApplicationModelElement(EditPart editPart, EditingDomain domain) {
        this(UMLUtil.resolveUMLElement((Object)editPart), domain);
        this.sourceElement = editPart;
    }

    public StereotypeApplicationModelElement(Element umlSource, EditingDomain domain) {
        super((EObject)umlSource, domain);
        this.umlSource = umlSource;
        this.domain = domain;
    }

    public IObservable doGetObservable(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (propertyPath.equals(STEREOTYPE_APPLICATION)) {
            return new StereotypeApplicationObservableList(this.umlSource, this.domain);
        }
        if (feature == UMLPackage.eINSTANCE.getPackage_ProfileApplication()) {
            return new ProfileApplicationObservableList((Package)this.umlSource, this.domain);
        }
        return null;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.eINSTANCE.getPackage_ProfileApplication() && this.umlSource instanceof Package) {
            return new ProfileLabelProvider((Package)this.umlSource);
        }
        try {
            return ((LabelProviderService)ServiceUtilsForResource.getInstance().getServiceRegistry(this.umlSource.eResource()).getService(LabelProviderService.class)).getLabelProvider();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return new LabelProvider();
        }
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        return new ApplicableStereotypeContentProvider(this.umlSource);
    }

    public boolean isUnique(String propertyPath) {
        return true;
    }

    public boolean isOrdered(String propertyPath) {
        return false;
    }

    public EModelElement getGraphicalElement() {
        if (this.sourceElement == null) {
            return null;
        }
        return (EModelElement)this.sourceElement.getModel();
    }

    public EditPart getEditPart() {
        return this.sourceElement;
    }

    public Element getUMLElement() {
        return this.umlSource;
    }
}

