/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.databinding.StereotypeAppearanceObservableValue;
import org.eclipse.papyrus.views.properties.modelelement.AbstractModelElement;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.uml2.uml.Element;

public class StereotypeAppearanceModelElement
extends AbstractModelElement
implements ModelElement {
    protected Element umlSource;
    protected EditingDomain domain;
    protected EModelElement diagramElement;

    public StereotypeAppearanceModelElement(Element umlSource, EditingDomain domain, EModelElement diagramElement) {
        this.umlSource = umlSource;
        this.domain = domain;
        this.diagramElement = diagramElement;
    }

    public IObservable doGetObservable(String propertyPath) {
        if (propertyPath.equals("stereotypeDisplay") || propertyPath.equals("textAlignment") || propertyPath.equals("displayPlace")) {
            return new StereotypeAppearanceObservableValue(this.diagramElement, this.umlSource, propertyPath, this.domain);
        }
        Activator.log.warn("Unknown property : " + propertyPath);
        return null;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals("stereotypeDisplay")) {
            return new StaticContentProvider((Object[])new String[]{"Text", "Icon", "Text and Icon", "Shape"});
        }
        if (propertyPath.equals("textAlignment")) {
            return new StaticContentProvider((Object[])new String[]{"Horizontal", "Vertical"});
        }
        if (propertyPath.equals("displayPlace")) {
            return new StaticContentProvider((Object[])new String[]{"Compartment", "Comment", "With brace"});
        }
        return EmptyContentProvider.instance;
    }

    public boolean isMandatory(String propertyPath) {
        return true;
    }

    public boolean isEditable(String propertyPath) {
        return !EMFHelper.isReadOnly((EObject)this.diagramElement);
    }
}

