/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialog;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialogFactory;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.semantic.service.SemanticService;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.NavigatorUtils;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBrowserCustomization
extends AbstractHandler {
    protected CommonNavigator getCommonNavigator() {
        IViewPart page;
        IViewPart part = NavigatorUtils.findViewPart("org.eclipse.papyrus.views.modelexplorer.modelexplorer");
        if (part instanceof ModelExplorerPageBookView && (page = ((ModelExplorerPageBookView)part).getActiveView()) instanceof CommonNavigator) {
            return (CommonNavigator)page;
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (Activator.getDefault().getCustomizationManager() != null) {
            ICustomizationManager customizationManager = Activator.getDefault().getCustomizationManager();
            List registeredCustomizations = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(customizationManager.getResourceSet()).getRegisteredCustomizations();
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            IDialogCallbackWithPreCommit<List<Customization>, Boolean, Dialog> dialogCallBack = new IDialogCallbackWithPreCommit<List<Customization>, Boolean, Dialog>(){

                public void committed(List<Customization> result, Boolean precommitResult) {
                }

                public Dialog openPrecommitDialog(List<Customization> result, IDialogCallback<Boolean> precommitCallback) {
                    return null;
                }
            };
            ILoadCustomizationsDialog dialog = ILoadCustomizationsDialogFactory.DEFAULT.createLoadCustomizationDialog(shell, registeredCustomizations, customizationManager.getManagedCustomizations(), (IDialogCallbackWithPreCommit)dialogCallBack);
            if (dialog.open() == 0) {
                customizationManager.getManagedCustomizations().clear();
                customizationManager.getManagedCustomizations().addAll(dialog.getSelectedCustomizations());
                org.eclipse.papyrus.infra.emf.Activator.getDefault().saveCustomizationManagerState();
            }
            if (this.getCommonNavigator() != null) {
                this.getCommonNavigator().getCommonViewer().refresh();
            }
        }
        return null;
    }

    private ModelSet getModelSet() {
        return ModelUtils.getModelSet();
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }

    protected List<EPackage> getMetamodels(ServicesRegistry serviceRegistry) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        IPageManager pageMngr = null;
        try {
            pageMngr = ServiceUtils.getInstance().getIPageManager((Object)serviceRegistry);
            List pages = pageMngr.allPages();
            int i = 0;
            while (i < pages.size()) {
                EPackage ePackage;
                if (pages.get(i) instanceof EObject && !ePackages.contains(ePackage = ((EObject)pages.get(i)).eClass().getEPackage())) {
                    ePackages.add(ePackage);
                }
                ++i;
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        try {
            SemanticService semantic = (SemanticService)serviceRegistry.getService(SemanticService.class);
            EObject[] eObjectArray = semantic.getSemanticRoots();
            int n = eObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage ePackage;
                EObject rootElement = eObjectArray[n2];
                EClass eClass = rootElement.eClass();
                if (eClass != null && !ePackages.contains(ePackage = eClass.getEPackage())) {
                    ePackages.add(eClass.getEPackage());
                }
                ++n2;
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        return ePackages;
    }
}

