/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.CreationCommandRegistry;
import org.eclipse.papyrus.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.commands.MoveOpenableCommand;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDropAdapterAssistant
extends org.eclipse.ui.navigator.CommonDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object dropTarget) {
        EObject targetElement = EMFHelper.getEObject((Object)dropTarget);
        this.execute((EditingDomain)this.getEditingDomain(targetElement), (Command)this.getDrop(dropTarget));
        return null;
    }

    protected List<Command> getDropIntoCommand(TransactionalEditingDomain domain, EObject targetOwner, EObject childElement, EReference eref) {
        ICommand command;
        ArrayList<Command> commandList = new ArrayList<Command>();
        MoveRequest moveRequest = new MoveRequest(targetOwner, childElement);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetOwner);
        if (provider != null && (command = provider.getEditCommand((IEditCommandRequest)moveRequest)) != null) {
            commandList.add((Command)new GMFtoEMFCommandWrapper(command));
        }
        return commandList;
    }

    private static ICreationCommandRegistry getCreationCommandRegistry() {
        return CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.core");
    }

    protected Command getDropViewCommands(TransactionalEditingDomain domain, EObject target, EObject view) {
        Resource targetNotationResource;
        ViewPrototype proto = ViewPrototype.get((EObject)view);
        if (!proto.isOwnerReassignable() || PolicyChecker.getCurrent().getOwningRuleFor(proto, target) == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Command command = proto.getCommandChangeOwner(view, target);
        if (command != null && (targetNotationResource = this.getTargetNotationResource(target)) != null) {
            if (!targetNotationResource.equals(view.eResource())) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(command);
                list.add(new GMFtoEMFCommandWrapper((ICommand)new MoveOpenableCommand(domain, "", view, targetNotationResource)));
                return new CompoundCommand(list);
            }
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Resource getTargetNotationResource(EObject targetOwner) {
        if (targetOwner.eResource() != null && targetOwner.eResource().getResourceSet() instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)targetOwner.eResource().getResourceSet();
            return modelSet.getAssociatedResource(targetOwner, "notation");
        }
        return null;
    }

    protected List<Command> getOrderChangeCommand(TransactionalEditingDomain domain, EObject targetOwner, EObject objectLocation, EObject newElement, boolean before) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        ArrayList<EStructuralFeature> possibleEFeatures = new ArrayList<EStructuralFeature>();
        EList featureList = targetOwner.eClass().getEAllStructuralFeatures();
        if (EcoreUtil.isAncestor((EObject)newElement, (EObject)targetOwner)) {
            return Collections.emptyList();
        }
        for (EStructuralFeature eStructuralFeature : featureList) {
            EReference ref;
            if (!(eStructuralFeature instanceof EReference) || !(ref = (EReference)eStructuralFeature).isContainment() || !this.isSubClass(ref.getEType(), newElement.eClass())) continue;
            possibleEFeatures.add(eStructuralFeature);
        }
        for (EStructuralFeature eStructuralFeature : possibleEFeatures) {
            ICommand command;
            ArrayList<EObject> tmp = new ArrayList<EObject>();
            if (targetOwner.eGet(eStructuralFeature) instanceof Collection) {
                tmp.addAll((Collection)targetOwner.eGet(eStructuralFeature));
                if (!newElement.equals(objectLocation)) {
                    tmp.remove(newElement);
                    int indexObject = tmp.indexOf(objectLocation);
                    if (before && indexObject != -1) {
                        tmp.add(tmp.indexOf(objectLocation), newElement);
                    } else if (!before && indexObject != -1) {
                        tmp.add(tmp.indexOf(objectLocation) + 1, newElement);
                    }
                }
            } else {
                tmp.add(newElement);
            }
            SetRequest setRequest = new SetRequest(targetOwner, eStructuralFeature, tmp);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetOwner);
            if (provider == null || (command = provider.getEditCommand((IEditCommandRequest)setRequest)) == null) continue;
            commandList.add((Command)new GMFtoEMFCommandWrapper(command));
        }
        return commandList;
    }

    protected void execute(EditingDomain domain, Command dropCommand) {
        domain.getCommandStack().execute(dropCommand);
    }

    public CompoundCommand getDrop(Object target) {
        CommonDropAdapter dropAdapter = this.getCommonDropAdapter();
        List<Object> commandList = new ArrayList();
        switch (dropAdapter.getCurrentOperation()) {
            case 2: {
                if (dropAdapter.getCurrentLocation() == 1) {
                    if (!(target instanceof EObjectTreeElement)) break;
                    commandList = this.getOrderChangeCommand(target, true);
                    break;
                }
                if (dropAdapter.getCurrentLocation() == 2) {
                    if (!(target instanceof EObjectTreeElement)) break;
                    commandList = this.getOrderChangeCommand(target, false);
                    break;
                }
                if (dropAdapter.getCurrentLocation() == 3) {
                    if (target instanceof EObjectTreeElement) {
                        commandList = this.getDropIntoCommand(target, null);
                    }
                    if (!(target instanceof EReferenceTreeElement)) break;
                    commandList = this.getDropIntoCommand(((EReferenceTreeElement)target).getParent(), ((EReferenceTreeElement)target).getEReference());
                    break;
                }
                dropAdapter.getCurrentLocation();
            }
        }
        return new CompoundCommand(commandList);
    }

    public boolean isSubClass(EClassifier aclass, EClass possibleSubClasse) {
        if (aclass.equals(possibleSubClasse)) {
            return true;
        }
        EList superTypeList = possibleSubClasse.getEAllSuperTypes();
        return superTypeList.contains((Object)aclass);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        CompoundCommand dropCommand = this.getDrop(target);
        if (dropCommand.canExecute()) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected List<Command> getDropIntoCommand(Object target, EReference eref) {
        ArrayList<Command> result = new ArrayList<Command>();
        EObject targetEObject = null;
        targetEObject = EMFHelper.getEObject((Object)target);
        if (targetEObject == null) {
            return result;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            for (Object object : selectedElements) {
                EObject eObjectchild = EMFHelper.getEObject(object);
                if (ViewPrototype.isViewObject((EObject)eObjectchild) && this.getEditors(targetEObject).contains(eObjectchild)) {
                    result.add(this.getDropViewCommands(this.getEditingDomain(targetEObject), targetEObject, eObjectchild));
                    continue;
                }
                if (eObjectchild == null) continue;
                result.addAll(this.getDropIntoCommand(this.getEditingDomain(targetEObject), targetEObject, eObjectchild, eref));
            }
        }
        return result;
    }

    private List<Object> getEditors(EObject context) {
        try {
            return ServiceUtilsForEObject.getInstance().getIPageMngr((Object)context).allPages();
        }
        catch (ServiceException ex) {
            return Collections.emptyList();
        }
    }

    protected List<Command> getOrderChangeCommand(Object target, boolean before) {
        ArrayList<Command> result = new ArrayList<Command>();
        EObject objectLocation = null;
        EObject objectOwner = null;
        objectLocation = EMFHelper.getEObject((Object)target);
        if (objectLocation == null) {
            return result;
        }
        objectOwner = objectLocation.eContainer();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            for (Object object : selectedElements) {
                EObject eObjectchild = EMFHelper.getEObject(object);
                if (eObjectchild == null || objectOwner == null) continue;
                result.addAll(this.getOrderChangeCommand(this.getEditingDomain(eObjectchild), objectOwner, objectLocation, eObjectchild, before));
            }
        }
        return result;
    }

    protected TransactionalEditingDomain getEditingDomain(EObject context) {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)context);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }
}

