/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.editor;

import org.eclipse.gef.ui.views.palette.PaletteView;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ActivePageTracker;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

class PapyrusPaletteSynchronizer
implements ActivePageTracker.IActiveEditorChangedListener,
IPageChangedListener {
    private final PapyrusMultiDiagramEditor myMultiDiagramEditor;
    private IEditorPart myLastActivePart;

    public PapyrusPaletteSynchronizer(PapyrusMultiDiagramEditor multiEditor) {
        this.myMultiDiagramEditor = multiEditor;
    }

    public void activeEditorChanged(PagePart oldEditor, PagePart newEditor) {
        this.synchronizePaletteView((IPage)newEditor);
    }

    public void pageChanged(IPage newPage) {
        this.synchronizePaletteView(newPage);
    }

    private void synchronizePaletteView(IPage activePage) {
        IEditorPart activePart;
        PaletteView paletteView = this.findPaletteView();
        if (paletteView == null) {
            return;
        }
        IEditorPart iEditorPart = activePart = activePage instanceof IEditorPage ? ((IEditorPage)activePage).getIEditorPart() : null;
        if (activePart == this.myLastActivePart) {
            return;
        }
        if (activePart == null) {
            paletteView.partClosed((IWorkbenchPart)this.myLastActivePart);
        } else {
            paletteView.partClosed((IWorkbenchPart)this.myMultiDiagramEditor);
            paletteView.partActivated((IWorkbenchPart)activePart);
        }
        this.myLastActivePart = activePart;
    }

    public void dispose() {
        if (this.myLastActivePart == null) {
            return;
        }
        PaletteView paletteView = this.findPaletteView();
        if (paletteView == null) {
            return;
        }
        paletteView.partClosed((IWorkbenchPart)this.myLastActivePart);
    }

    private PaletteView findPaletteView() {
        IWorkbenchPage samePage = this.myMultiDiagramEditor.getSite().getPage();
        return (PaletteView)samePage.findView("org.eclipse.gef.ui.palette_view");
    }
}

