/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.utilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementWithURICS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2as.ImportDiagnostic;
import org.eclipse.ocl.examples.xtext.base.cs2as.LibraryDiagnostic;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CS;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2as.EssentialOCLCS2Pivot;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NamedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.pivot2cs.EssentialOCLPivot2CS;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Triple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCSResource
extends LazyLinkingResource
implements BaseCSResource {
    private static final String NO_VIABLE_ALTERNATIVE_AT_INPUT_EOF = "no viable alternative at input '<EOF>'";
    private static final String NO_VIABLE_ALTERNATIVE_FOLLOWING = "no viable alternative following input ";
    private static final Logger logger = Logger.getLogger(EssentialOCLCSResource.class);
    @Nullable
    private ParserContext parserContext = null;

    protected void addLibraryError(List<Resource.Diagnostic> errors, IllegalLibraryException e) {
        String message = e.getMessage();
        for (Resource.Diagnostic diagnostic : errors) {
            Exception exception;
            if (!(diagnostic instanceof LibraryDiagnostic) || !((exception = ((LibraryDiagnostic)diagnostic).getException()) instanceof IllegalLibraryException) || !message.equals(exception.getMessage())) continue;
            return;
        }
        errors.add((Resource.Diagnostic)new LibraryDiagnostic((Exception)((Object)e)));
    }

    protected void addSyntaxErrors() {
        if (this.isValidationDisabled()) {
            return;
        }
        IParseResult parseResult = this.getParseResult();
        if (parseResult == null) {
            return;
        }
        EList errors2 = this.getErrors();
        for (final INode error : parseResult.getSyntaxErrors()) {
            String tokenText;
            int index;
            String message;
            Object diagnostic = null;
            final SyntaxErrorMessage syntaxErrorMessage = error.getSyntaxErrorMessage();
            if (syntaxErrorMessage != null && (message = syntaxErrorMessage.getMessage()) != null && message.contains(NO_VIABLE_ALTERNATIVE_AT_INPUT_EOF) && (index = message.indexOf(NO_VIABLE_ALTERNATIVE_AT_INPUT_EOF)) >= 0 && (tokenText = NodeModelUtils.getTokenText((INode)error)) != null) {
                final String newMessage = String.valueOf(message.substring(0, index)) + NO_VIABLE_ALTERNATIVE_FOLLOWING + "'" + tokenText + "'" + message.substring(index + NO_VIABLE_ALTERNATIVE_AT_INPUT_EOF.length());
                diagnostic = new AbstractDiagnostic(){

                    public String getCode() {
                        return syntaxErrorMessage.getIssueCode();
                    }

                    public int getColumn() {
                        return -1;
                    }

                    public String[] getData() {
                        return syntaxErrorMessage.getIssueData();
                    }

                    public String getMessage() {
                        return newMessage;
                    }

                    protected INode getNode() {
                        return error;
                    }
                };
            }
            if (diagnostic == null) {
                diagnostic = new XtextSyntaxDiagnostic(error);
            }
            errors2.add(diagnostic);
        }
    }

    protected void createAndAddDiagnostic(Triple<EObject, EReference, INode> triple) {
        if (this.isValidationDisabled()) {
            return;
        }
        EObject context = (EObject)triple.getFirst();
        if (context instanceof ElementCS) {
            if (!this.hasError((ElementCS)context)) {
                super.createAndAddDiagnostic(triple);
                this.setHasError((ElementCS)context);
            }
        } else {
            super.createAndAddDiagnostic(triple);
        }
    }

    @NonNull
    public CS2Pivot createCS2Pivot(@NonNull Map<? extends Resource, ? extends ASResource> cs2asResourceMap, @NonNull MetaModelManager metaModelManager) {
        return new EssentialOCLCS2Pivot(cs2asResourceMap, metaModelManager);
    }

    protected Resource.Diagnostic createDiagnostic(Triple<EObject, EReference, INode> triple, DiagnosticMessage message) {
        EObject first = (EObject)triple.getFirst();
        if (first instanceof PathElementWithURICS) {
            return new ImportDiagnostic((INode)triple.getThird(), message.getMessage(), message.getIssueCode(), message.getIssueData());
        }
        return new XtextLinkingDiagnostic((INode)triple.getThird(), message.getMessage(), message.getIssueCode(), message.getIssueData()){

            public int getColumn() {
                return -1;
            }
        };
    }

    @NonNull
    public Pivot2CS createPivot2CS(@NonNull Map<? extends Resource, ? extends ASResource> cs2asResourceMap, @NonNull MetaModelManager metaModelManager) {
        return new EssentialOCLPivot2CS(cs2asResourceMap, metaModelManager);
    }

    @NonNull
    public MetaModelManager createMetaModelManager() {
        MetaModelManagerResourceSetAdapter resourceSetAdapter;
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null && (resourceSetAdapter = MetaModelManagerResourceSetAdapter.findAdapter((ResourceSet)resourceSet)) != null) {
            return resourceSetAdapter.getMetaModelManager();
        }
        return new MetaModelManager();
    }

    protected void doLinking() {
        EList errors = this.getErrors();
        if (errors.size() > 0) {
            int i = errors.size();
            while (--i >= 0) {
                Resource.Diagnostic error = (Resource.Diagnostic)errors.get(i);
                if (!(error instanceof LibraryDiagnostic)) continue;
                errors.remove(i);
            }
        }
        super.doLinking();
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        super.doLoad(inputStream, options);
    }

    @Nullable
    public final CS2PivotResourceAdapter findCS2ASAdapter() {
        return (CS2PivotResourceAdapter)PivotUtil.getAdapter(CS2PivotResourceAdapter.class, (Notifier)this);
    }

    @NonNull
    public String getASContentType() {
        return "org.eclipse.ocl.examples.oclas.essentialocl";
    }

    @NonNull
    public final CS2PivotResourceAdapter getCS2ASAdapter(@Nullable MetaModelManager metaModelManager) {
        CS2PivotResourceAdapter adapter = (CS2PivotResourceAdapter)PivotUtil.getAdapter(CS2PivotResourceAdapter.class, (Notifier)this);
        if (adapter == null) {
            if (metaModelManager == null) {
                ClassLoader classLoader;
                metaModelManager = PivotUtil.findMetaModelManager((Resource)this);
                if (metaModelManager == null) {
                    metaModelManager = this.createMetaModelManager();
                    ResourceSet csResourceSet = this.getResourceSet();
                    if (csResourceSet != null) {
                        MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)csResourceSet, (MetaModelManager)metaModelManager);
                    }
                }
                if ((classLoader = ((Object)((Object)this)).getClass().getClassLoader()) != null) {
                    metaModelManager.addClassLoader(classLoader);
                }
            }
            Resource.Factory.Registry resourceFactoryRegistry = metaModelManager.getASResourceSet().getResourceFactoryRegistry();
            this.initializeResourceFactory(resourceFactoryRegistry);
            adapter = new CS2PivotResourceAdapter((BaseCSResource)this, metaModelManager);
            this.eAdapters().add((Object)adapter);
        }
        return adapter;
    }

    @NonNull
    public String getEditorName() {
        return "Essential OCL";
    }

    @Nullable
    public final ParserContext getParserContext() {
        return this.parserContext;
    }

    @NonNull
    public final ASResource getASResource(@Nullable MetaModelManager metaModelManager) {
        CS2PivotResourceAdapter adapter = this.getCS2ASAdapter(metaModelManager);
        ASResource asResource = adapter.getASResource((BaseCSResource)this);
        if (asResource == null) {
            throw new IllegalStateException("No Pivot Resource created");
        }
        return asResource;
    }

    @NonNull
    public URI getASURI(@NonNull URI csURI) {
        return csURI.appendFileExtension("oclas");
    }

    protected boolean hasError(ElementCS csElement) {
        while (csElement instanceof PathElementCS || csElement instanceof PathNameCS) {
            csElement = csElement.getLogicalParent();
        }
        while (csElement instanceof ExpCS) {
            if (((ExpCS)csElement).isHasError()) {
                return true;
            }
            if (!((csElement = csElement.getLogicalParent()) instanceof NavigationOperatorCS) && !(csElement instanceof NamedExpCS)) break;
        }
        return false;
    }

    protected void initializeResourceFactory(@NonNull Resource.Factory.Registry resourceFactoryRegistry) {
    }

    public void reparse(String newContent) throws IOException {
        try {
            super.reparse(newContent);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Failed to reparse", (Throwable)e);
        }
    }

    @NonNull
    public final URI resolve(@NonNull URI uri) {
        URI csURI = this.getURI();
        if (csURI.isRelative()) {
            File csRelative = new File(csURI.toFileString());
            File csAbsolute = csRelative.getAbsoluteFile();
            csURI = URI.createFileURI((String)csAbsolute.toString());
        }
        URI resolvedURI = uri.resolve(csURI);
        assert (resolvedURI != null);
        return resolvedURI;
    }

    public void resolveLazyCrossReferences(CancelIndicator mon) {
        EList errors = this.getErrors();
        assert (errors != null);
        if (ElementUtil.hasSyntaxError((List)errors)) {
            return;
        }
        MetaModelManager metaModelManager = PivotUtil.findMetaModelManager((Resource)this);
        if (metaModelManager != null) {
            try {
                metaModelManager.getOclAnyType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclElementType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclVoidType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclInvalidType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getMetaclassType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getBooleanType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getRealType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getIntegerType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getUnlimitedNaturalType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getStringType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getCollectionType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getBagType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getSequenceType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getSetType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOrderedSetType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getEnumerationType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclTupleType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclLambdaType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
        }
        super.resolveLazyCrossReferences(mon);
    }

    protected void setHasError(ElementCS csElement) {
        while (csElement instanceof PathElementCS || csElement instanceof PathNameCS) {
            csElement = csElement.getLogicalParent();
        }
        while (csElement instanceof ExpCS) {
            ((ExpCS)csElement).setHasError(true);
            csElement = csElement.getLogicalParent();
            if (!(csElement instanceof NavigationOperatorCS)) break;
        }
    }

    public final void setParserContext(@Nullable ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public void updateFrom(@NonNull ASResource asResource, @NonNull MetaModelManager metaModelManager) {
        HashMap<EssentialOCLCSResource, ASResource> cs2PivotResourceMap = new HashMap<EssentialOCLCSResource, ASResource>();
        cs2PivotResourceMap.put(this, asResource);
        Pivot2CS pivot2cs = this.createPivot2CS(cs2PivotResourceMap, metaModelManager);
        pivot2cs.update();
    }
}

