/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainMetaclass;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.AbstractOperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigationRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationFilter
extends AbstractOperationFilter {
    @NonNull
    protected final List<NavigatingArgCS> csArguments;
    protected final int iterators;
    protected final int accumulators;
    protected final int expressions;

    public OperationFilter(@Nullable Type sourceType, @NonNull InvocationExpCS csNavigatingExp) {
        super(sourceType);
        int accumulators = 0;
        int iterators = 0;
        int expressions = 0;
        EList<NavigatingArgCS> csArguments = csNavigatingExp.getArgument();
        this.csArguments = csArguments;
        for (NavigatingArgCS csNavigatingArg : csArguments) {
            if (csNavigatingArg.getRole() == NavigationRole.ITERATOR) {
                ++iterators;
                continue;
            }
            if (csNavigatingArg.getRole() == NavigationRole.ACCUMULATOR) {
                ++accumulators;
                continue;
            }
            if (csNavigatingArg.getRole() != NavigationRole.EXPRESSION) continue;
            ++expressions;
        }
        this.iterators = iterators;
        this.accumulators = accumulators;
        this.expressions = expressions;
    }

    @Override
    public int compareMatches(@NonNull MetaModelManager metaModelManager, @NonNull Object match1, @Nullable Map<TemplateParameter, ParameterableElement> referenceBindings, @NonNull Object match2, @Nullable Map<TemplateParameter, ParameterableElement> candidateBindings) {
        Operation reference = (Operation)match1;
        Operation candidate = (Operation)match2;
        Type referenceType = PivotUtil.getType((Type)PivotUtil.getOwningType((Feature)reference));
        Type candidateType = PivotUtil.getType((Type)PivotUtil.getOwningType((Feature)candidate));
        Type specializedReferenceType = metaModelManager.getSpecializedType(referenceType, referenceBindings);
        Type specializedCandidateType = metaModelManager.getSpecializedType(candidateType, candidateBindings);
        if (reference instanceof Iteration && candidate instanceof Iteration) {
            int iteratorCountDelta = ((Iteration)candidate).getOwnedIterator().size() - ((Iteration)reference).getOwnedIterator().size();
            if (iteratorCountDelta != 0) {
                return iteratorCountDelta;
            }
            if (referenceType != candidateType) {
                if (metaModelManager.conformsTo(specializedReferenceType, specializedCandidateType, null)) {
                    return 1;
                }
                if (metaModelManager.conformsTo(specializedCandidateType, specializedReferenceType, null)) {
                    return -1;
                }
            }
        }
        int referenceConversions = 0;
        int candidateConversions = 0;
        Type comparedSourceType = this.sourceType;
        if (comparedSourceType instanceof DomainMetaclass) {
            comparedSourceType = ((DomainMetaclass)comparedSourceType).getInstanceType();
        }
        if (comparedSourceType != specializedReferenceType) {
            ++referenceConversions;
        }
        if (comparedSourceType != specializedCandidateType) {
            ++candidateConversions;
        }
        List candidateParameters = candidate.getOwnedParameter();
        List referenceParameters = reference.getOwnedParameter();
        int i = 0;
        while (i < candidateParameters.size()) {
            NavigatingArgCS csArgument = this.csArguments.get(i);
            OCLExpression pivotArgument = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csArgument);
            if (pivotArgument == null) {
                return 0;
            }
            Type argumentType = pivotArgument.getType();
            Parameter referenceParameter = (Parameter)referenceParameters.get(i);
            Parameter candidateParameter = (Parameter)candidateParameters.get(i);
            if (referenceParameter == null || candidateParameter == null) {
                referenceConversions = Integer.MIN_VALUE;
                candidateConversions = Integer.MIN_VALUE;
            } else {
                referenceType = PivotUtil.getType((Type)((Type)DomainUtil.nonNullModel((Object)referenceParameter.getType())));
                candidateType = PivotUtil.getType((Type)((Type)DomainUtil.nonNullModel((Object)candidateParameter.getType())));
                specializedReferenceType = metaModelManager.getSpecializedType(referenceType, referenceBindings);
                specializedCandidateType = metaModelManager.getSpecializedType(candidateType, candidateBindings);
                if (argumentType != specializedReferenceType) {
                    ++referenceConversions;
                }
                if (argumentType != specializedCandidateType) {
                    ++candidateConversions;
                }
            }
            ++i;
        }
        if (candidateConversions != referenceConversions) {
            return candidateConversions - referenceConversions;
        }
        int verdict = metaModelManager.compareOperationMatches(reference, referenceBindings, candidate, candidateBindings);
        return verdict;
    }

    @Nullable
    protected OCLExpression getExpressionArgument(int index) {
        int expIndex = 0;
        for (NavigatingArgCS csNavigatingArg : this.csArguments) {
            if (csNavigatingArg.getRole() != NavigationRole.EXPRESSION) continue;
            if (expIndex == index) {
                return (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csNavigatingArg);
            }
            ++expIndex;
        }
        return null;
    }

    @Nullable
    protected Map<TemplateParameter, ParameterableElement> getIterationBindings(@NonNull MetaModelManager metaModelManager, @NonNull Iteration candidateIteration) {
        Type sourceType = this.sourceType;
        if (!(sourceType instanceof CollectionType) && candidateIteration.getOwningType() instanceof CollectionType && sourceType != null) {
            sourceType = metaModelManager.getSetType(sourceType, null, null);
        }
        if (!(sourceType instanceof CollectionType)) {
            return null;
        }
        HashMap<TemplateParameter, ParameterableElement> bindings = new HashMap<TemplateParameter, ParameterableElement>();
        bindings.put((TemplateParameter)candidateIteration.getOwningType().getOwnedTemplateSignature().getOwnedParameter().get(0), (ParameterableElement)((CollectionType)sourceType).getElementType());
        PivotUtil.getAllTemplateParameterSubstitutions(bindings, (TemplateableElement)sourceType);
        TemplateSignature templateSignature = candidateIteration.getOwnedTemplateSignature();
        if (templateSignature != null) {
            List templateParameters = templateSignature.getOwnedParameter();
            int accIndex = 0;
            for (NavigatingArgCS csArgument : this.csArguments) {
                Variable argument;
                if (csArgument.getRole() != NavigationRole.ACCUMULATOR) continue;
                if (accIndex < templateParameters.size() && (argument = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csArgument)) != null) {
                    Type argumentType = argument.getType();
                    TemplateParameter accParameter = (TemplateParameter)templateParameters.get(accIndex);
                    bindings.put(accParameter, (ParameterableElement)argumentType);
                }
                ++accIndex;
            }
        }
        return bindings;
    }

    @Override
    @Nullable
    protected Map<TemplateParameter, ParameterableElement> getOperationBindings(@NonNull MetaModelManager metaModelManager, @NonNull Operation candidateOperation) {
        Type sourceType = this.sourceType;
        HashMap<TemplateParameter, InvalidType> bindings = null;
        Type containingType = candidateOperation.getOwningType();
        if (containingType instanceof CollectionType && sourceType != null) {
            if (!(sourceType instanceof CollectionType)) {
                sourceType = metaModelManager.getSetType(sourceType, null, null);
            }
            Object elementType = sourceType instanceof CollectionType ? ((CollectionType)sourceType).getElementType() : metaModelManager.getOclInvalidType();
            bindings = new HashMap<TemplateParameter, InvalidType>();
            bindings.put((TemplateParameter)containingType.getOwnedTemplateSignature().getOwnedParameter().get(0), (InvalidType)elementType);
        }
        bindings = PivotUtil.getAllTemplateParameterSubstitutions(bindings, (TemplateableElement)sourceType);
        TemplateSignature templateSignature = candidateOperation.getOwnedTemplateSignature();
        if (templateSignature != null) {
            for (TemplateParameter templateParameter : templateSignature.getOwnedParameter()) {
                if (bindings == null) {
                    bindings = new HashMap();
                }
                bindings.put(templateParameter, null);
            }
        }
        return bindings;
    }

    @Override
    protected void installBindings(@NonNull EnvironmentView environmentView, @NonNull Object object, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        List parameters = ((Operation)object).getOwnedParameter();
        int iMax = parameters.size();
        if (iMax > 0) {
            int i = 0;
            while (i < iMax) {
                Type parameterType;
                Parameter parameter = (Parameter)parameters.get(i);
                OCLExpression argument = this.getExpressionArgument(i);
                if (argument != null && (parameterType = parameter.getType()) instanceof LambdaType) {
                    PivotUtil.getAllTemplateParameterSubstitutions(bindings, (Type)argument.getType(), (LambdaType)((LambdaType)parameterType));
                }
                ++i;
            }
        }
        super.installBindings(environmentView, object, bindings);
    }

    public boolean matches(@NonNull EnvironmentView environmentView, @NonNull Object object) {
        MetaModelManager metaModelManager = environmentView.getMetaModelManager();
        if (object instanceof Iteration) {
            Iteration candidateIteration = (Iteration)object;
            int iteratorCount = candidateIteration.getOwnedIterator().size();
            if (this.iterators > 0 && iteratorCount != this.iterators) {
                return false;
            }
            int accumulatorCount = candidateIteration.getOwnedAccumulator().size();
            if (accumulatorCount != this.accumulators) {
                return false;
            }
            Map<TemplateParameter, ParameterableElement> bindings = this.getIterationBindings(metaModelManager, candidateIteration);
            if (bindings != null) {
                this.installBindings(environmentView, object, bindings);
            }
            return true;
        }
        if (object instanceof Operation) {
            if (this.iterators > 0) {
                return false;
            }
            if (this.accumulators > 0) {
                return false;
            }
            Operation candidateOperation = (Operation)object;
            List candidateParameters = candidateOperation.getOwnedParameter();
            if (this.expressions != candidateParameters.size()) {
                return false;
            }
            Map<TemplateParameter, ParameterableElement> bindings = this.getOperationBindings(metaModelManager, candidateOperation);
            int i = 0;
            while (i < this.expressions) {
                Parameter candidateParameter = (Parameter)candidateParameters.get(i);
                if (candidateParameter != null) {
                    NavigatingArgCS csExpression = this.csArguments.get(i);
                    OCLExpression expression = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csExpression);
                    Type candidateType = PivotUtil.getType((TypedElement)candidateParameter);
                    Type expressionType = PivotUtil.getType((TypedElement)expression);
                    if (expressionType == null || candidateType == null) {
                        return false;
                    }
                    if (!metaModelManager.conformsTo(expressionType, candidateType, bindings)) {
                        return false;
                    }
                }
                ++i;
            }
            if (bindings != null) {
                this.installBindings(environmentView, object, bindings);
            }
            return true;
        }
        return false;
    }
}

