/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import com.google.common.collect.Interner;
import com.google.common.collect.Maps;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Map;
import java.util.RandomAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElementAndSyntaxError;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSyntaxError;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNodeWithSyntaxError;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.nodemodel.impl.LeafNodeWithSyntaxError;
import org.eclipse.xtext.nodemodel.impl.RootNode;

public class NodeModelBuilder {
    private EObject forcedGrammarElement;
    private ArrayInterner<EObject> cachedFoldedGrammarElements = new ArrayInterner();
    private boolean compressRoot = true;

    public void addChild(ICompositeNode node, AbstractNode child) {
        this.checkValidNewChild(child);
        CompositeNode composite = (CompositeNode)node;
        AbstractNode firstChild = composite.basicGetFirstChild();
        if (firstChild == null) {
            composite.basicSetFirstChild(child);
            this.initializeFirstChildInvariant(composite, child);
        } else {
            child.basicSetParent(composite);
            AbstractNode nodePreviousSibling = firstChild.basicGetPreviousSibling();
            child.basicSetPreviousSibling(nodePreviousSibling);
            child.basicSetNextSibling(firstChild);
            if (nodePreviousSibling != null) {
                nodePreviousSibling.basicSetNextSibling(child);
            }
            firstChild.basicSetPreviousSibling(child);
        }
    }

    public void associateWithSemanticElement(ICompositeNode node, EObject astElement) {
        CompositeNodeWithSemanticElement casted = (CompositeNodeWithSemanticElement)node;
        astElement.eAdapters().add((Object)casted);
    }

    public ICompositeNode newCompositeNodeAsParentOf(EObject grammarElement, int lookahead, ICompositeNode existing) {
        AbstractNode existingNextSibling;
        CompositeNodeWithSemanticElement newComposite = new CompositeNodeWithSemanticElement();
        AbstractNode castedExisting = (AbstractNode)((Object)existing);
        newComposite.basicSetGrammarElement(grammarElement);
        newComposite.basicSetLookAhead(lookahead);
        CompositeNode existingParent = castedExisting.basicGetParent();
        newComposite.basicSetParent(existingParent);
        if (existingParent.basicGetFirstChild() == castedExisting) {
            existingParent.basicSetFirstChild(newComposite);
        }
        if ((existingNextSibling = castedExisting.basicGetNextSibling()) == castedExisting) {
            newComposite.basicSetNextSibling(newComposite);
            newComposite.basicSetPreviousSibling(newComposite);
        } else {
            newComposite.basicSetNextSibling(existingNextSibling);
            existingNextSibling.basicSetPreviousSibling(newComposite);
            AbstractNode existingPreviousSibling = castedExisting.basicGetPreviousSibling();
            newComposite.basicSetPreviousSibling(existingPreviousSibling);
            existingPreviousSibling.basicSetNextSibling(newComposite);
        }
        newComposite.basicSetFirstChild(castedExisting);
        this.initializeFirstChildInvariant(newComposite, castedExisting);
        return this.compressAndReturnParent(existing);
    }

    protected void initializeFirstChildInvariant(CompositeNode node, AbstractNode child) {
        child.basicSetParent(node);
        child.basicSetNextSibling(child);
        child.basicSetPreviousSibling(child);
    }

    protected void checkValidNewChild(AbstractNode child) {
        if (child == null) {
            throw new IllegalArgumentException("child may not be null");
        }
        if (child.basicGetNextSibling() != null || child.basicGetPreviousSibling() != null) {
            throw new IllegalStateException("child has already a next or prev");
        }
    }

    public ICompositeNode newCompositeNode(EObject grammarElement, int lookahead, ICompositeNode parent) {
        CompositeNodeWithSemanticElement result = new CompositeNodeWithSemanticElement();
        if (this.forcedGrammarElement != null) {
            result.basicSetGrammarElement(this.forcedGrammarElement);
            this.forcedGrammarElement = null;
        } else {
            result.basicSetGrammarElement(grammarElement);
        }
        result.basicSetLookAhead(lookahead);
        this.addChild(parent, result);
        return result;
    }

    public ICompositeNode newRootNode(String input) {
        RootNode result = new RootNode();
        result.basicSetCompleteContent(input);
        return result;
    }

    public ILeafNode newLeafNode(int offset, int length, EObject grammarElement, boolean isHidden, SyntaxErrorMessage errorMessage, ICompositeNode parent) {
        LeafNode result = null;
        if (errorMessage != null) {
            if (isHidden) {
                result = new HiddenLeafNodeWithSyntaxError();
                ((HiddenLeafNodeWithSyntaxError)result).basicSetSyntaxErrorMessage(errorMessage);
            } else {
                result = new LeafNodeWithSyntaxError();
                ((LeafNodeWithSyntaxError)result).basicSetSyntaxErrorMessage(errorMessage);
            }
        } else {
            result = isHidden ? new HiddenLeafNode() : new LeafNode();
        }
        result.basicSetGrammarElement(grammarElement);
        result.basicSetTotalOffset(offset);
        result.basicSetTotalLength(length);
        this.addChild(parent, result);
        return result;
    }

    public ICompositeNode compressAndReturnParent(ICompositeNode compositeNode) {
        CompositeNode firstChild;
        CompositeNode casted = (CompositeNode)compositeNode;
        if (casted.basicGetParent() != null && casted.hasChildren() && casted.basicGetFirstChild() instanceof CompositeNode && !(firstChild = (CompositeNode)casted.basicGetFirstChild()).basicHasSiblings() && !firstChild.hasDirectSemanticElement() && firstChild.getLookAhead() == casted.getLookAhead() && firstChild.getSyntaxErrorMessage() == null) {
            EObject myGrammarElement = casted.getGrammarElement();
            Object childGrammarElement = firstChild.basicGetGrammarElement();
            EObject[] list = null;
            list = childGrammarElement instanceof EObject ? new EObject[]{myGrammarElement, (EObject)childGrammarElement} : this.newEObjectArray(myGrammarElement, (EObject[])childGrammarElement);
            casted.basicSetGrammarElement(this.cachedFoldedGrammarElements.intern((T[])list));
            this.replaceChildren(firstChild, casted);
        }
        CompositeNode result = null;
        if (casted.basicGetSemanticElement() == null && casted instanceof CompositeNodeWithSemanticElement) {
            CompositeNode compressed;
            if (casted.getSyntaxErrorMessage() == null) {
                compressed = new CompositeNode();
                compressed.basicSetGrammarElement(casted.basicGetGrammarElement());
                compressed.basicSetLookAhead(compositeNode.getLookAhead());
                this.replace(casted, compressed);
                result = compressed.basicGetParent();
            } else {
                compressed = new CompositeNodeWithSyntaxError();
                compressed.basicSetGrammarElement(casted.basicGetGrammarElement());
                compressed.basicSetLookAhead(compositeNode.getLookAhead());
                ((CompositeNodeWithSyntaxError)compressed).basicSetSyntaxErrorMessage(casted.getSyntaxErrorMessage());
                this.replace(casted, compressed);
                result = compressed.basicGetParent();
            }
        }
        if (result == null) {
            result = casted.basicGetParent();
        }
        if (this.compressRoot && result instanceof RootNode) {
            if (casted.hasSiblings()) {
                throw new IllegalStateException("Root's child should never have siblings");
            }
            RootNode root = (RootNode)result;
            if (casted.basicGetFirstChild() != null) {
                AbstractNode firstChild2 = casted.basicGetFirstChild();
                if (firstChild2 instanceof ILeafNode && !firstChild2.basicHasNextSibling()) {
                    return result;
                }
                root.basicSetFirstChild(firstChild2);
                firstChild2.basicSetParent(root);
                AbstractNode child = firstChild2;
                while (child.basicHasNextSibling()) {
                    child = child.basicGetNextSibling();
                    child.basicSetParent(root);
                }
                root.basicSetGrammarElement(casted.basicGetGrammarElement());
                root.basicSetSemanticElement(casted.basicGetSemanticElement());
                root.basicSetSyntaxErrorMessage(casted.getSyntaxErrorMessage());
                root.basicSetLookAhead(casted.getLookAhead());
                EObject semanticElement = casted.getSemanticElement();
                if (semanticElement != null) {
                    semanticElement.eAdapters().remove((Object)casted);
                    root.getSemanticElement().eAdapters().add((Object)root);
                }
            }
        }
        return result;
    }

    private EObject[] newEObjectArray(EObject first, EObject[] rest) {
        EObject[] array = new EObject[rest.length + 1];
        array[0] = first;
        System.arraycopy(rest, 0, array, 1, rest.length);
        return array;
    }

    public INode setSyntaxError(INode node, SyntaxErrorMessage errorMessage) {
        if (node instanceof LeafNode) {
            LeafNode oldNode = (LeafNode)node;
            LeafNode newNode = null;
            if (oldNode.isHidden()) {
                HiddenLeafNodeWithSyntaxError newLeaf = new HiddenLeafNodeWithSyntaxError();
                newLeaf.basicSetSyntaxErrorMessage(errorMessage);
                newNode = newLeaf;
            } else {
                LeafNodeWithSyntaxError newLeaf = new LeafNodeWithSyntaxError();
                newLeaf.basicSetSyntaxErrorMessage(errorMessage);
                newNode = newLeaf;
            }
            newNode.basicSetTotalLength(oldNode.getTotalLength());
            newNode.basicSetTotalOffset(oldNode.getTotalOffset());
            newNode.basicSetGrammarElement(oldNode.basicGetGrammarElement());
            this.replace(oldNode, newNode);
            return newNode;
        }
        CompositeNode oldNode = (CompositeNode)node;
        CompositeNode newNode = null;
        if (oldNode.basicGetSemanticElement() != null) {
            CompositeNodeWithSemanticElementAndSyntaxError newComposite = new CompositeNodeWithSemanticElementAndSyntaxError();
            newComposite.basicSetSemanticElement(oldNode.basicGetSemanticElement());
            newComposite.basicSetSyntaxErrorMessage(errorMessage);
            oldNode.basicGetSemanticElement().eAdapters().remove((Object)oldNode);
            newComposite.basicGetSemanticElement().eAdapters().add((Object)newComposite);
            newNode = newComposite;
        } else {
            CompositeNodeWithSyntaxError newComposite = new CompositeNodeWithSyntaxError();
            newComposite.basicSetSyntaxErrorMessage(errorMessage);
            newNode = newComposite;
        }
        newNode.basicSetGrammarElement(oldNode.basicGetGrammarElement());
        newNode.basicSetLookAhead(oldNode.getLookAhead());
        this.replace(oldNode, newNode);
        return newNode;
    }

    protected void replace(AbstractNode oldNode, AbstractNode newNode) {
        this.replaceWithoutChildren(oldNode, newNode);
        this.replaceChildren(oldNode, newNode);
    }

    protected void replaceChildren(AbstractNode oldNode, AbstractNode newNode) {
        if (oldNode instanceof CompositeNode) {
            CompositeNode oldComposite = (CompositeNode)oldNode;
            CompositeNode newComposite = (CompositeNode)newNode;
            AbstractNode child = oldComposite.basicGetFirstChild();
            if (child != null) {
                newComposite.basicSetFirstChild(child);
                while (child.basicGetParent() != newComposite) {
                    child.basicSetParent(newComposite);
                    child = child.basicGetNextSibling();
                }
            }
        }
    }

    public void replaceAndTransferLookAhead(INode oldNode, INode newRootNode) {
        AbstractNode newNode = ((CompositeNode)newRootNode).basicGetFirstChild();
        this.replaceWithoutChildren((AbstractNode)oldNode, newNode);
        if (oldNode instanceof ICompositeNode && newNode instanceof CompositeNode) {
            CompositeNode newCompositeNode = (CompositeNode)newNode;
            newCompositeNode.basicSetLookAhead(((ICompositeNode)oldNode).getLookAhead());
        }
        ICompositeNode root = newNode.getRootNode();
        BidiTreeIterator<AbstractNode> iterator = ((AbstractNode)((Object)root)).basicIterator();
        int offset = 0;
        while (iterator.hasNext()) {
            AbstractNode node = iterator.next();
            if (!(node instanceof LeafNode)) continue;
            ((LeafNode)node).basicSetTotalOffset(offset);
            offset += node.getTotalLength();
        }
    }

    protected void replaceWithoutChildren(AbstractNode oldNode, AbstractNode newNode) {
        AbstractNode nextSibling;
        CompositeNode parent = oldNode.basicGetParent();
        newNode.basicSetParent(parent);
        if (parent.basicGetFirstChild() == oldNode) {
            parent.basicSetFirstChild(newNode);
        }
        if ((nextSibling = oldNode.basicGetNextSibling()) == oldNode) {
            newNode.basicSetNextSibling(newNode);
        } else {
            newNode.basicSetNextSibling(nextSibling);
            nextSibling.basicSetPreviousSibling(newNode);
        }
        AbstractNode previousSibling = oldNode.basicGetPreviousSibling();
        if (previousSibling == oldNode) {
            newNode.basicSetPreviousSibling(newNode);
        } else {
            newNode.basicSetPreviousSibling(previousSibling);
            previousSibling.basicSetNextSibling(newNode);
        }
    }

    public void setCompleteContent(ICompositeNode rootNode, String completeContent) {
        ((RootNode)rootNode).basicSetCompleteContent(completeContent);
    }

    public void setForcedFirstGrammarElement(RuleCall ruleCall) {
        this.forcedGrammarElement = ruleCall;
        this.compressRoot = false;
    }

    protected void setLookAhead(CompositeNode node, int lookAhead) {
        node.basicSetLookAhead(lookAhead);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayInterner<T>
    implements Interner<T[]> {
        private Map<ArrayAsList<T>, T[]> map = Maps.newHashMap();

        private ArrayInterner() {
        }

        public T[] intern(T[] sample) {
            ArrayAsList<T> key = new ArrayAsList<T>(sample);
            T[] canonical = this.map.get(key);
            if (canonical == null) {
                canonical = sample;
                this.map.put(key, canonical);
            }
            return canonical;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ArrayAsList<T>
        extends AbstractList<T>
        implements RandomAccess {
            final T[] array;
            private int hashCode = -1;

            ArrayAsList(T[] array) {
                this.array = array;
            }

            @Override
            public int size() {
                return this.array.length;
            }

            @Override
            public T get(int index) {
                return this.array[index];
            }

            @Override
            public int hashCode() {
                if (this.hashCode == -1) {
                    this.hashCode = Arrays.hashCode(this.array);
                }
                return this.hashCode;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o instanceof ArrayAsList && Arrays.equals(this.array, ((ArrayAsList)o).array);
            }
        }
    }
}

