/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.response;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.data.VMStackFrameData;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.response.VMResponse;

public class VMStackFrameResponse
extends VMResponse {
    private static final long serialVersionUID = -731807514003839012L;
    @Nullable
    public final VMStackFrameData[] frames;
    @Nullable
    public final VMVariableData[] variables;
    public boolean isDeferredExecution;

    public VMStackFrameResponse(@NonNull VMStackFrameData frame) {
        this(new VMStackFrameData[]{frame});
    }

    public VMStackFrameResponse(@NonNull VMStackFrameData[] frames) {
        this.frames = frames;
        this.variables = null;
    }

    public VMStackFrameResponse(@NonNull VMVariableData[] variables) {
        this.variables = variables;
        this.frames = null;
    }

    @Nullable
    public VMStackFrameData getFrame() {
        VMStackFrameData[] frames2 = this.frames;
        return frames2 != null && frames2.length > 0 ? frames2[0] : null;
    }

    public boolean isDeferredExecution() {
        return this.isDeferredExecution;
    }

    @Override
    public String toString() {
        VMVariableData[] variables2;
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(this.getClass().getSimpleName()) + "(" + VMStackFrameResponse.toStatusString(this.status));
        VMStackFrameData[] frames2 = this.frames;
        if (frames2 != null) {
            s.append(", {");
            int i = 0;
            while (i < frames2.length) {
                if (i > 0) {
                    s.append(",");
                }
                s.append("\n\t");
                s.append(frames2[i]);
                ++i;
            }
            s.append("}");
        }
        if ((variables2 = this.variables) != null) {
            s.append(", {");
            int i = 0;
            while (i < variables2.length) {
                if (i > 0) {
                    s.append(",");
                }
                s.append("\n\t");
                s.append(variables2[i]);
                ++i;
            }
            s.append("}");
        }
        s.append(", deferred = " + this.isDeferredExecution);
        return s.toString();
    }
}

