/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;

class SourceModificationListener
implements IResourceChangeListener {
    @NonNull
    protected final VMDebugCore debugCore;
    @NonNull
    protected final IFile fTransfFile;
    @NonNull
    protected final ITerminate fTerminate;

    SourceModificationListener(@NonNull VMDebugCore debugCore, @NonNull IFile transformationFile, @NonNull ITerminate terminateable) {
        this.debugCore = debugCore;
        this.fTransfFile = transformationFile;
        this.fTerminate = terminateable;
    }

    private boolean expired() {
        if (this.fTerminate.isTerminated()) {
            this.fTransfFile.getProject().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            return true;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.expired()) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        final boolean[] modified = new boolean[1];
        if (delta == null) {
            if (event.getResource() instanceof IProject && event.getType() == 2 && event.getResource() == this.fTransfFile.getProject()) {
                modified[0] = true;
            }
        } else {
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource instanceof IFile) {
                            boolean include;
                            IFile file = (IFile)resource;
                            boolean bl = include = (delta.getFlags() & 0x100) != 0;
                            if (include && SourceModificationListener.this.fTransfFile.equals((Object)file)) {
                                modified[0] = true;
                            }
                            return false;
                        }
                        IProject project = resource.getProject();
                        return project == null || project.equals((Object)SourceModificationListener.this.fTransfFile.getProject());
                    }
                });
            }
            catch (CoreException e) {
                this.debugCore.log(e.getStatus());
            }
        }
        if (modified[0]) {
            this.handleSourceModified(this.fTransfFile, this.fTerminate);
        }
    }

    protected void handleSourceModified(IFile sourceFile, ITerminate terminateable) {
    }
}

