/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.IModuleSourceInfo;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;

public class UnitLocation {
    private static final int UNDEF_LINE_NUM = -2;
    private int fLineNum = -2;
    private final int startPosition;
    private final int endPosition;
    private final int fDepth;
    private final Element fElement;
    @NonNull
    private final NamedElement fModule;
    private final NamedElement fOperation;
    @NonNull
    private final IVMEvaluationEnvironment<?> fEvalEnv;
    private IModuleSourceInfo fSrcInfo;

    public UnitLocation(int startPosition, int endPosition, @NonNull IVMEvaluationEnvironment<?> evalEnv, @NonNull Element element) {
        this.fEvalEnv = evalEnv;
        this.fElement = element;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.fDepth = evalEnv.getDepth();
        this.fOperation = evalEnv.getOperation();
        EObject rootContainer = EcoreUtil.getRootContainer(this.fEvalEnv.getDebuggableElement());
        assert (rootContainer instanceof NamedElement);
        this.fModule = (NamedElement)rootContainer;
    }

    public boolean isDeferredExecution() {
        return this.fEvalEnv.isDeferredExecution();
    }

    public URI getURI() {
        return this.getSourceInfo().getSourceURI();
    }

    @NonNull
    public NamedElement getModule() {
        return this.fModule;
    }

    public NamedElement getOperation() {
        return this.fOperation;
    }

    @NonNull
    public IVMEvaluationEnvironment<?> getEvalEnv() {
        return this.fEvalEnv;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public int getLineNum() {
        if (this.fLineNum == -2) {
            int newLine = -1;
            if (this.startPosition >= 0) {
                newLine = this.getSourceInfo().getLineNumberProvider().getLineNumber(this.startPosition);
            }
            this.fLineNum = newLine;
            return this.fLineNum;
        }
        return this.fLineNum;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getStackDepth() {
        return this.fDepth;
    }

    public Element getElement() {
        return this.fElement;
    }

    public boolean isTheSameLine(@NonNull UnitLocation location) {
        return this.fEvalEnv == location.fEvalEnv && this.getLineNum() == location.getLineNum();
    }

    public boolean isTheSameLocation(@NonNull UnitLocation location) {
        return this.fEvalEnv == location.fEvalEnv && this.getLineNum() == location.getLineNum() && this.startPosition == location.startPosition && this.endPosition == location.endPosition;
    }

    public boolean equals(Object another) {
        if (!(another instanceof UnitLocation)) {
            return false;
        }
        UnitLocation location = (UnitLocation)another;
        return this == location || this.startPosition == location.startPosition && this.fDepth == location.fDepth && this.fEvalEnv == location.fEvalEnv && this.fElement.equals(location.fElement);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.startPosition;
        hash = 37 * hash + this.endPosition;
        hash = 37 * hash + this.fDepth;
        hash = 37 * hash + this.fElement.hashCode();
        return hash;
    }

    public String toString() {
        return String.valueOf(this.fModule.getName()) + ":" + this.getLineNum() + ":" + this.startPosition + ":" + (this.endPosition - this.startPosition) + ":" + this.fDepth;
    }

    private IModuleSourceInfo getSourceInfo() {
        if (this.fSrcInfo == null) {
            this.fSrcInfo = ASTBindingHelper.getModuleSourceBinding((Element)this.getModule());
        }
        return this.fSrcInfo;
    }
}

