/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.PreferenceHelper;
import org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelper;
import org.eclipse.emf.ecp.internal.ui.util.ECPHandlerHelper;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;

public final class ECPExportHandlerHelper {
    private static final String UNEXPECTED_ERROR_MESSAGE = "An unexpected error in a ECP plugin occured.";
    private static final String FILE_EXTENSION = "xmi";
    public static final String[] FILTER_NAMES = new String[]{"Model Files (*.xmi)"};
    public static final String[] FILTER_EXTS = new String[]{"*.xmi"};
    private static final String EXPORT_MODEL_PATH = "org.eclipse.emf.emfstore.client.ui.exportModelPath";
    private static final String FILE_DIALOG_HELPER_CLASS = "org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelperImpl";

    private ECPExportHandlerHelper() {
    }

    public static void export(Shell shell, List<EObject> eObjects) {
        if (eObjects.size() > 0) {
            String filePath = ECPExportHandlerHelper.getFilePathByFileDialog(shell, ECPExportHandlerHelper.getNameForModelElement(eObjects.get(0)));
            if (filePath == null) {
                return;
            }
            PreferenceHelper.setPreference(EXPORT_MODEL_PATH, new File(filePath).getParent());
            ECPExportHandlerHelper.runCommand(eObjects, filePath, shell);
        }
    }

    private static String getNameForModelElement(EObject modelElement) {
        ComposedAdapterFactory adapterFactory = null;
        adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        String text = labelProvider.getText((Object)modelElement);
        adapterFactory.dispose();
        labelProvider.dispose();
        return text;
    }

    private static void runCommand(List<EObject> exportModelElements, String filePath, Shell shell) {
        File file = new File(filePath);
        URI uri = URI.createFileURI((String)filePath);
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        progressDialog.open();
        progressDialog.getProgressMonitor().beginTask("Export modelelement...", 100);
        progressDialog.getProgressMonitor().worked(10);
        try {
            ECPExportHandlerHelper.saveEObjectToResource(exportModelElements, uri);
        }
        catch (IOException e) {
            ECPExportHandlerHelper.showExceptionDialog(e.getMessage(), e, shell);
        }
        progressDialog.getProgressMonitor().done();
        progressDialog.close();
        MessageDialog.openInformation(null, (String)"Export", (String)("Exported modelelement to file " + file.getName()));
    }

    private static void showExceptionDialog(String message, Exception cause, Shell shell) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(message);
        String title = "Error";
        if (cause != null) {
            stringBuilder.append(": ");
            stringBuilder.append(cause.getMessage());
            title = cause.getClass().getName();
        }
        String string = stringBuilder.toString();
        MessageDialog.openError((Shell)shell, (String)title, (String)string);
        Activator.log(UNEXPECTED_ERROR_MESSAGE, cause);
    }

    private static String getFilePathByFileDialog(Shell shell, String modelElementName) {
        try {
            Class clazz = ECPHandlerHelper.loadClass("org.eclipse.emf.ecp.ui", FILE_DIALOG_HELPER_CLASS);
            ECPFileDialogHelper fileDialogHelper = (ECPFileDialogHelper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return fileDialogHelper.getPathForExport(shell, modelElementName);
        }
        catch (ClassNotFoundException ex) {
            Activator.log(ex);
        }
        catch (InstantiationException ex) {
            Activator.log(ex);
        }
        catch (IllegalAccessException ex) {
            Activator.log(ex);
        }
        catch (IllegalArgumentException ex) {
            Activator.log(ex);
        }
        catch (InvocationTargetException ex) {
            Activator.log(ex);
        }
        catch (NoSuchMethodException ex) {
            Activator.log(ex);
        }
        catch (SecurityException ex) {
            Activator.log(ex);
        }
        return null;
    }

    private static void saveEObjectToResource(List<? extends EObject> eObjects, URI resourceURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(resourceURI);
        EList contents = resource.getContents();
        for (EObject eObject : eObjects) {
            contents.add((Object)eObject);
        }
        contents.addAll(eObjects);
        resource.save(null);
    }
}

