/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableEditPolicyEx;

public class BarResizeEditPolicy
extends ResizableEditPolicyEx {
    private final int thickness;

    public BarResizeEditPolicy() {
        this.thickness = 8;
    }

    public BarResizeEditPolicy(int thickness) {
        this.thickness = thickness;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure feedback = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        this.checkAndPrepareConstraint(request, (Rectangle)rect);
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        IGraphicalEditPart editPart = (IGraphicalEditPart)this.getHost();
        PrecisionRectangle locationAndSize = new PrecisionRectangle(editPart.getFigure().getBounds());
        editPart.getFigure().translateToAbsolute((Translatable)locationAndSize);
        Rectangle origRequestedBounds = request.getTransformedRectangle((Rectangle)locationAndSize);
        Rectangle modified = origRequestedBounds.getCopy();
        this.checkAndPrepareConstraint(request, modified);
        Dimension newDelta = new Dimension(modified.width - locationAndSize.width, modified.height - locationAndSize.height);
        request.setSizeDelta(newDelta);
        Point moveDelta = request.getMoveDelta();
        request.setMoveDelta(new Point(moveDelta.x - origRequestedBounds.x + modified.x, moveDelta.y - origRequestedBounds.y + modified.y));
        return super.getResizeCommand(request);
    }

    private void checkAndPrepareConstraint(ChangeBoundsRequest request, Rectangle rect) {
        GraphicalEditPart editPart = null;
        for (Object ep : request.getEditParts()) {
            if (editPart != null || !(ep instanceof GraphicalEditPart)) continue;
            editPart = (GraphicalEditPart)ep;
            editPart.getFigure().translateToRelative((Translatable)rect);
        }
        if (rect.width / rect.height < 1) {
            if ((request.getResizeDirection() & 8) != 0) {
                rect.x += rect.width - this.thickness;
            }
            rect.width = this.thickness;
        } else {
            if ((request.getResizeDirection() & 1) != 0) {
                rect.y += rect.height - this.thickness;
            }
            rect.height = this.thickness;
        }
        if (editPart != null) {
            editPart.getFigure().translateToAbsolute((Translatable)rect);
        }
    }
}

