/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.expressions.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.validation.Check;
import org.yakindu.base.expressions.expressions.Expression;
import org.yakindu.base.expressions.inferrer.IExpressionsTypeInferrer;
import org.yakindu.base.expressions.validation.AbstractExpressionsJavaValidator;
import org.yakindu.base.expressions.validation.GenericsPrettyPrinter;
import org.yakindu.base.types.ComplexType;
import org.yakindu.base.types.InferenceIssue;
import org.yakindu.base.types.InferenceResult;
import org.yakindu.base.types.ParameterizedType;
import org.yakindu.base.types.Type;
import org.yakindu.base.types.TypeParameter;
import org.yakindu.base.types.TypedElement;
import org.yakindu.base.types.TypesPackage;

public class ExpressionsJavaValidator
extends AbstractExpressionsJavaValidator {
    public static final String WARNING_IS_RAW_CODE = "WarningRaw";
    public static final String WARNING_IS_RAW_MSG = "%s is a raw type. References to generic type %s should be parameterized";
    public static final String ERROR_NOT_GENERIC_CODE = "TypeNotGeneric";
    public static final String ERROR_NOT_GENERIC_MSG = "The type %s is not generic; it cannot be parameterized with arguments %s";
    public static final String ERROR_ARGUMENTED_SPECIFIER_INCORRECT_ARGUMENT_NR_CODE = "IncorrectNrOfArguments";
    public static final String ERROR_ARGUMENTED_SPECIFIER_INCORRECT_ARGUMENT_NR_MSG = "Incorrect number of arguments for type %s; it cannot be parameterized with arguments %s";
    public static final String ERROR_BOUND_MISSMATCH_CODE = "TypeParameterBoundMissmatch";
    public static final String ERROR_BOUND_MISSMATCH_MSG = "Bound mismatch: The type %s is not a valid substitute for the bounded parameter %s of the type %s";
    public static final String ERROR_DUPLICATE_TYPE_PARAMETER_CODE = "DuplicateTypeParameter";
    public static final String ERROR_DUPLICATE_TYPE_PARAMETER_MSG = "Duplicate Type Parameter %s";
    public static final String ERROR_CYCLE_DETECTED_CODE = "TypeExtendsItself";
    public static final String ERROR_CYCLE_DETECTED_MSG = "Cycle detected: the type %s cannot extend itself";
    @Inject
    private GenericsPrettyPrinter printer;
    @Inject
    private IExpressionsTypeInferrer typeInferrer;

    @Check
    public void checkIsRaw(TypedElement typedElement) {
        Type type = typedElement.getType();
        if (!(type instanceof ParameterizedType)) {
            return;
        }
        EList typeParameter = ((ParameterizedType)type).getParameter();
        if (typedElement.getTypeArguments().size() == 0 && typeParameter.size() > 0) {
            String s1 = typedElement.getType().getName();
            String s2 = String.valueOf(s1) + this.printer.concatTypeParameter((List<TypeParameter>)typeParameter);
            this.warning(String.format(WARNING_IS_RAW_MSG, s1, s2), (EObject)typedElement, (EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE, WARNING_IS_RAW_CODE, new String[0]);
        }
    }

    @Check
    public void checkTypedElementNotGeneric(TypedElement typedElement) {
        if (!(typedElement.getTypeArguments().size() <= 0 || typedElement.getType() instanceof ParameterizedType && ((ParameterizedType)typedElement.getType()).getParameter().size() != 0)) {
            String s1 = typedElement.getType().getName();
            String s2 = this.printer.concatTypeArguments((List<Type>)typedElement.getTypeArguments());
            this.error(String.format(ERROR_NOT_GENERIC_MSG, s1, s2), (EObject)typedElement, (EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE, ERROR_NOT_GENERIC_CODE, new String[0]);
        }
    }

    @Check
    public void checkNofArguments(TypedElement typedElement) {
        if (!(typedElement.getType() instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType type = (ParameterizedType)typedElement.getType();
        EList typeParameter = type.getParameter();
        if (typedElement.getTypeArguments().size() > 0 && typedElement.getTypeArguments().size() != typeParameter.size() && typeParameter.size() > 0) {
            String s1 = String.valueOf(type.getName()) + this.printer.concatTypeParameter((List<TypeParameter>)typeParameter);
            String s2 = this.printer.concatTypeArguments((List<Type>)typedElement.getTypeArguments());
            this.error(String.format(ERROR_ARGUMENTED_SPECIFIER_INCORRECT_ARGUMENT_NR_MSG, s1, s2), (EObject)typedElement, (EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE, ERROR_ARGUMENTED_SPECIFIER_INCORRECT_ARGUMENT_NR_CODE, new String[0]);
        }
    }

    @Check
    public void checkDuplicateTypeParameter(ParameterizedType type) {
        HashSet names = Sets.newHashSet();
        EList typeParameter = type.getParameter();
        for (TypeParameter param : typeParameter) {
            String name = param.getName();
            if (names.contains(name)) {
                this.error(String.format(ERROR_DUPLICATE_TYPE_PARAMETER_MSG, name), (EObject)type, (EStructuralFeature)TypesPackage.Literals.PARAMETERIZED_TYPE__PARAMETER, ERROR_DUPLICATE_TYPE_PARAMETER_CODE, new String[0]);
            }
            names.add(name);
        }
    }

    @Check
    public void checkTypeParameterBounds(TypedElement typedElement) {
        if (!(typedElement.getType() instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType type = (ParameterizedType)typedElement.getType();
        EList typeParameter = type.getParameter();
        if (typedElement.getTypeArguments().size() == 0 || typedElement.getTypeArguments().size() != typeParameter.size()) {
            return;
        }
        int i = 0;
        while (i < typeParameter.size()) {
            TypeParameter parameter = (TypeParameter)typeParameter.get(i);
            if (parameter.getBound() != null) {
                Type argument = (Type)typedElement.getTypeArguments().get(i);
                if (!this.isTypeCompatible(parameter.getBound(), argument)) {
                    this.error(String.format(ERROR_BOUND_MISSMATCH_MSG, argument.getName(), parameter.getBound().getName(), type.getName()), (EObject)typedElement, (EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE_ARGUMENTS, i, ERROR_BOUND_MISSMATCH_CODE, new String[0]);
                }
            }
            ++i;
        }
    }

    @Check
    public void checkTypeNotExtendsItself(ComplexType type) {
        EList superTypes = type.getSuperTypes();
        for (ComplexType superType : superTypes) {
            if (!superType.equals(type)) continue;
            this.error(String.format(ERROR_CYCLE_DETECTED_MSG, type.getName()), (EObject)type, (EStructuralFeature)TypesPackage.Literals.COMPLEX_TYPE__SUPER_TYPES, ERROR_CYCLE_DETECTED_CODE, new String[0]);
        }
    }

    @Check
    public void checkExpressionIsTypeCompatible(Expression expression) {
        try {
            InferenceResult result = this.typeInferrer.inferType(expression);
            this.report(result, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void report(InferenceResult result, EStructuralFeature feature) {
        if (result.getIssues().isEmpty()) {
            return;
        }
        InferenceIssue error = (InferenceIssue)Iterables.getLast((Iterable)result.getIssues());
        this.error(error.getMessage(), feature);
    }

    private boolean isTypeCompatible(Type bound, Type argument) {
        if (EcoreUtil.equals((EObject)bound, (EObject)argument)) {
            return true;
        }
        if (argument instanceof ComplexType && ((ComplexType)argument).getSuperTypes().size() > 0) {
            ComplexType superType = (ComplexType)((ComplexType)argument).getSuperTypes().get(0);
            return this.isTypeCompatible(bound, (Type)superType);
        }
        return false;
    }
}

